/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.HashBuilder;
import dev.fileformat.drako.Struct;
import java.io.Serializable;

final class Quantizer
implements Struct<Quantizer>,
Serializable {
    private float inverse_delta_;
    static final long serialVersionUID = 1166676417L;

    public Quantizer(float range, int maxQuantizedValue) {
        this.inverse_delta_ = (float)maxQuantizedValue / range;
    }

    public int quantizeFloat(float val) {
        return (int)Math.floor((val *= this.inverse_delta_) + 0.5f);
    }

    public Quantizer() {
    }

    private Quantizer(Quantizer other) {
        this.inverse_delta_ = other.inverse_delta_;
    }

    @Override
    public Quantizer clone() {
        return new Quantizer(this);
    }

    @Override
    public void copyFrom(Quantizer src) {
        if (src == null) {
            return;
        }
        this.inverse_delta_ = src.inverse_delta_;
    }

    public int hashCode() {
        HashBuilder builder = new HashBuilder();
        builder.hash(this.inverse_delta_);
        return builder.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Quantizer)) {
            return false;
        }
        Quantizer rhs = (Quantizer)obj;
        return this.inverse_delta_ == rhs.inverse_delta_;
    }
}

