/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.IntVector;
import dev.fileformat.drako.PredictionSchemeNormalOctahedronTransformBase;

class PredictionSchemeNormalOctahedronTransform
extends PredictionSchemeNormalOctahedronTransformBase {
    public PredictionSchemeNormalOctahedronTransform() {
    }

    public PredictionSchemeNormalOctahedronTransform(int maxQuantizedValue) {
        this.setMaxQuantizedValue(maxQuantizedValue);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void decodeTransformData(DecoderBuffer buffer) throws DrakoException {
        int maxQuantizedValue = buffer.decodeI32();
        if (buffer.getBitstreamVersion() < 22) {
            int n = buffer.decodeI32();
        }
        this.setMaxQuantizedValue(maxQuantizedValue);
    }

    @Override
    public void encodeTransformData(EncoderBuffer buffer) {
        buffer.encode2(this.octahedronToolBox.getMaxQuantizedValue());
    }

    @Override
    public void computeCorrection(IntSpan originalVals, int originalOffset, IntSpan predictedVals, int predictedOffset, IntSpan outCorrVals, int outOffset, int valId) {
        IntVector orig = new IntVector(originalVals.get(originalOffset), originalVals.get(originalOffset + 1));
        IntVector pred = new IntVector(predictedVals.get(predictedOffset), predictedVals.get(predictedOffset + 1));
        IntVector corr = this.computeCorrection(orig, pred);
        outCorrVals.put(outOffset + valId, corr.x);
        outCorrVals.put(outOffset + valId + 1, corr.y);
    }

    @Override
    public void computeOriginalValue(IntSpan predictedVals, int predictedOffset, IntSpan corrVals, int corrOffset, IntSpan outOriginalVals, int outOffset) {
        IntVector pred = new IntVector(predictedVals.get(predictedOffset + 0), predictedVals.get(predictedOffset + 1));
        IntVector corr = new IntVector(corrVals.get(corrOffset), corrVals.get(corrOffset + 1));
        IntVector orig = this.computeOriginalValue(pred, corr);
        outOriginalVals.put(outOffset + 0, orig.x);
        outOriginalVals.put(outOffset + 1, orig.y);
    }

    private IntVector computeCorrection(IntVector orig, IntVector pred) {
        orig = orig == null ? new IntVector() : orig.clone();
        pred = pred == null ? new IntVector() : pred.clone();
        IntVector t = new IntVector(this.getCenterValue(), this.getCenterValue());
        int[] ref0 = new int[1];
        int[] ref1 = new int[1];
        int[] ref2 = new int[1];
        int[] ref3 = new int[1];
        orig.copyFrom(IntVector.sub(orig, t));
        pred.copyFrom(IntVector.sub(pred, t));
        if (!this.isInDiamond(pred.x, pred.y)) {
            ref0[0] = orig.x;
            ref1[0] = orig.y;
            this.octahedronToolBox.invertDiamond(ref0, ref1);
            orig.x = ref0[0];
            orig.y = ref1[0];
            ref2[0] = pred.x;
            ref3[0] = pred.y;
            this.octahedronToolBox.invertDiamond(ref2, ref3);
            pred.x = ref2[0];
            pred.y = ref3[0];
        }
        IntVector corr = IntVector.sub(orig, pred);
        corr.x = this.makePositive(corr.x);
        corr.y = this.makePositive(corr.y);
        return corr;
    }

    private IntVector computeOriginalValue(IntVector pred, IntVector corr) {
        pred = pred == null ? new IntVector() : pred.clone();
        IntVector t = new IntVector(this.getCenterValue(), this.getCenterValue());
        pred.copyFrom(IntVector.sub(pred, t));
        boolean predIsInDiamond = this.isInDiamond(pred.x, pred.y);
        if (!predIsInDiamond) {
            this.octahedronToolBox.invertDiamond(pred);
        }
        IntVector orig = IntVector.add(pred, corr);
        orig.x = this.modMax(orig.x);
        orig.y = this.modMax(orig.y);
        if (!predIsInDiamond) {
            this.octahedronToolBox.invertDiamond(orig);
        }
        orig.copyFrom(IntVector.add(orig, t));
        return orig;
    }
}

