/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshAttributeCornerTable;
import dev.fileformat.drako.MeshAttributeIndicesEncodingData;
import dev.fileformat.drako.MeshDecoder;
import dev.fileformat.drako.MeshEncoder;
import dev.fileformat.drako.MeshPredictionSchemeData;
import dev.fileformat.drako.MeshPredictionSchemeGeometricNormal;
import dev.fileformat.drako.MeshPredictionSchemeMultiParallelogram;
import dev.fileformat.drako.MeshPredictionSchemeParallelogram;
import dev.fileformat.drako.MeshPredictionSchemeTexCoords;
import dev.fileformat.drako.MeshPredictionSchemeTexCoordsPortableDecoder;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudDecoder;
import dev.fileformat.drako.PointCloudEncoder;
import dev.fileformat.drako.PredictionSchemeDeltaDecoder;
import dev.fileformat.drako.PredictionSchemeDifference;
import dev.fileformat.drako.PredictionSchemeTransform;

abstract class PredictionScheme {
    protected PointAttribute attribute_;
    protected PredictionSchemeTransform transform_;

    protected PredictionScheme(PointAttribute attribute, PredictionSchemeTransform transform) {
        this.attribute_ = attribute;
        this.transform_ = transform;
    }

    public PointAttribute getAttribute() {
        return this.attribute_;
    }

    public abstract boolean getInitialized();

    public int getNumParentAttributes() {
        return 0;
    }

    public int getParentAttributeType(int i) {
        return -1;
    }

    public void setParentAttribute(PointAttribute att) throws DrakoException {
        throw DracoUtils.failed();
    }

    public boolean areCorrectionsPositive() {
        return this.transform_.areCorrectionsPositive();
    }

    public int getTransformType() {
        return this.transform_.getType();
    }

    public abstract int getPredictionMethod();

    public void encodePredictionData(EncoderBuffer buffer) {
        this.transform_.encodeTransformData(buffer);
    }

    public void decodePredictionData(DecoderBuffer buffer) throws DrakoException {
        this.transform_.decodeTransformData(buffer);
    }

    public abstract void computeCorrectionValues(IntSpan var1, IntSpan var2, int var3, int var4, int[] var5);

    public abstract void computeOriginalValues(IntSpan var1, IntSpan var2, int var3, int var4, int[] var5) throws DrakoException;

    public static PredictionScheme create(int method, PointAttribute att, PredictionSchemeTransform transform) {
        if (method == -2) {
            return null;
        }
        return new PredictionSchemeDifference(att, transform);
    }

    public static PredictionScheme create(PointCloudEncoder encoder, int method, int attId, PredictionSchemeTransform transform) {
        MeshEncoder meshEncoder;
        PredictionScheme ret;
        PointAttribute attr = encoder.getPointCloud().attribute(attId);
        if (method == -1) {
            method = encoder.getOptions().getPredictionMethod(encoder.getGeometryType(), attr);
        }
        if (method == -2) {
            return null;
        }
        if (encoder.getGeometryType() == 1 && (ret = PredictionScheme.createMeshPredictionScheme(meshEncoder = (MeshEncoder)encoder, method, attId, transform)) != null) {
            return ret;
        }
        return new PredictionSchemeDifference(attr, transform);
    }

    static PredictionScheme createMeshPredictionScheme(MeshEncoder source, int method, int attId, PredictionSchemeTransform transform) {
        PointAttribute att = source.getPointCloud().attribute(attId);
        if (source.getGeometryType() == 1 && (method == 1 || method == 2 || method == 6 || method == 5 || method == 3)) {
            CornerTable ct = source.getCornerTable();
            MeshAttributeIndicesEncodingData encodingData = source.getAttributeEncodingData(attId);
            if (ct == null || encodingData == null) {
                return null;
            }
            MeshAttributeCornerTable attCt = source.getAttributeCornerTable(attId);
            MeshPredictionSchemeData md = new MeshPredictionSchemeData(source.getMesh(), attCt != null ? attCt : ct, encodingData.encodedAttributeValueIndexToCornerMap, encodingData.vertexToEncodedAttributeValueIndexMap);
            return PredictionScheme.createMeshPredictionSchemeInternal(method, att, transform, md);
        }
        return null;
    }

    public static PredictionScheme create(PointCloudDecoder source, int method, int attId, PredictionSchemeTransform transform) {
        if (method == -2) {
            return null;
        }
        PredictionScheme ret = null;
        if (source.getGeometryType() == 1) {
            ret = PredictionScheme.createMeshPredictionScheme((MeshDecoder)source, method, attId, transform);
        }
        if (ret != null) {
            return ret;
        }
        PointAttribute att = source.getPointCloud().attribute(attId);
        return new PredictionSchemeDeltaDecoder(att, transform);
    }

    public static PredictionScheme createMeshPredictionScheme(MeshDecoder source, int method, int attId, PredictionSchemeTransform transform) {
        PointAttribute att = source.getPointCloud().attribute(attId);
        if (method == 1 || method == 2 || method == 3 || method == 5 || method == 6) {
            CornerTable ct = source.getCornerTable();
            MeshAttributeIndicesEncodingData encodingData = source.getAttributeEncodingData(attId);
            if (ct == null || encodingData == null) {
                return null;
            }
            MeshAttributeCornerTable attCt = source.getAttributeCornerTable(attId);
            if (attCt != null) {
                MeshPredictionSchemeData md = new MeshPredictionSchemeData(source.getMesh(), attCt, encodingData.encodedAttributeValueIndexToCornerMap, encodingData.vertexToEncodedAttributeValueIndexMap);
                PredictionScheme ret = PredictionScheme.createMeshPredictionSchemeInternal(method, att, transform, md);
                if (ret != null) {
                    return ret;
                }
            } else {
                MeshPredictionSchemeData md = new MeshPredictionSchemeData(source.getMesh(), ct, encodingData.encodedAttributeValueIndexToCornerMap, encodingData.vertexToEncodedAttributeValueIndexMap);
                PredictionScheme ret = PredictionScheme.createMeshPredictionSchemeInternal(method, att, transform, md);
                if (ret != null) {
                    return ret;
                }
            }
        }
        return null;
    }

    static PredictionScheme createMeshPredictionSchemeInternal(int method, PointAttribute attribute, PredictionSchemeTransform transform, MeshPredictionSchemeData meshData) {
        if (method == 1) {
            return new MeshPredictionSchemeParallelogram(attribute, transform, meshData);
        }
        if (method == 2) {
            return new MeshPredictionSchemeMultiParallelogram(attribute, transform, meshData);
        }
        if (method == 3) {
            return new MeshPredictionSchemeTexCoords(attribute, transform, meshData);
        }
        if (method == 5) {
            return new MeshPredictionSchemeTexCoordsPortableDecoder(attribute, transform, meshData);
        }
        if (method == 6) {
            return new MeshPredictionSchemeGeometricNormal(attribute, transform, meshData);
        }
        return null;
    }
}

