/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.FloatSpan;
import dev.fileformat.drako.IntVector;

class OctahedronToolBox {
    int quantization_bits_;
    private int max_quantized_value_;
    private int max_value_;
    private int center_value_;

    public void setQuantizationBits(int q) {
        if (q < 2 || q > 30) {
            throw new IllegalArgumentException("Invalid quantization parameters");
        }
        this.quantization_bits_ = q;
        this.max_quantized_value_ = (1 << this.quantization_bits_) - 1;
        this.max_value_ = this.max_quantized_value_ - 1;
        this.center_value_ = this.max_value_ / 2;
    }

    public boolean isInitialized() {
        return this.quantization_bits_ != -1;
    }

    public boolean isInDiamond(int s, int t) {
        return Math.abs(s) + Math.abs(t) <= this.center_value_;
    }

    public void invertDiamond(IntVector v) {
        int sign_s = 0;
        int sign_t = 0;
        if (v.x >= 0 && v.y >= 0) {
            sign_s = 1;
            sign_t = 1;
        } else if (v.x <= 0 && v.y <= 0) {
            sign_s = -1;
            sign_t = -1;
        } else {
            sign_s = v.x > 0 ? 1 : -1;
            sign_t = v.y > 0 ? 1 : -1;
        }
        int corner_point_s = sign_s * this.center_value_;
        int corner_point_t = sign_t * this.center_value_;
        v.x = 2 * v.x - corner_point_s;
        v.y = 2 * v.y - corner_point_t;
        if (sign_s * sign_t >= 0) {
            int temp = v.x;
            v.x = -v.y;
            v.y = -temp;
        } else {
            int temp = v.x;
            v.x = v.y;
            v.y = temp;
        }
        v.x = (v.x + corner_point_s) / 2;
        v.y = (v.y + corner_point_t) / 2;
    }

    public void invertDiamond(int[] s, int[] t) {
        int sign_s = 0;
        int sign_t = 0;
        if (s[0] >= 0 && t[0] >= 0) {
            sign_s = 1;
            sign_t = 1;
        } else if (s[0] <= 0 && t[0] <= 0) {
            sign_s = -1;
            sign_t = -1;
        } else {
            sign_s = s[0] > 0 ? 1 : -1;
            sign_t = t[0] > 0 ? 1 : -1;
        }
        int corner_point_s = sign_s * this.center_value_;
        int corner_point_t = sign_t * this.center_value_;
        s[0] = 2 * s[0] - corner_point_s;
        t[0] = 2 * t[0] - corner_point_t;
        if (sign_s * sign_t >= 0) {
            int temp = s[0];
            s[0] = -t[0];
            t[0] = -temp;
        } else {
            int temp = s[0];
            s[0] = t[0];
            t[0] = temp;
        }
        s[0] = (s[0] + corner_point_s) / 2;
        t[0] = (t[0] + corner_point_t) / 2;
    }

    public void invertDirection(int[] s, int[] t) {
        s[0] = s[0] * -1;
        t[0] = t[0] * -1;
        this.invertDiamond(s, t);
    }

    public int modMax(int x) {
        if (x > this.center_value_) {
            return x - this.max_quantized_value_;
        }
        if (x < -this.center_value_) {
            return x + this.max_quantized_value_;
        }
        return x;
    }

    public int makePositive(int x) {
        if (x < 0) {
            return x + this.max_quantized_value_;
        }
        return x;
    }

    public int getQuantizationBits() {
        return this.quantization_bits_;
    }

    public int getMaxQuantizedValue() {
        return this.max_quantized_value_;
    }

    public int getMaxValue() {
        return this.max_value_;
    }

    public int getCenterValue() {
        return this.center_value_;
    }

    public void canonicalizeIntegerVector(int[] vec) {
        long abs_sum = Math.abs(vec[0]) + Math.abs(vec[1]) + Math.abs(vec[2]);
        if (abs_sum == 0L) {
            vec[0] = this.center_value_;
        } else {
            vec[0] = (int)((long)vec[0] * (long)this.center_value_ / abs_sum);
            vec[1] = (int)((long)vec[1] * (long)this.center_value_ / abs_sum);
            vec[2] = vec[2] >= 0 ? this.center_value_ - Math.abs(vec[0]) - Math.abs(vec[1]) : -(this.center_value_ - Math.abs(vec[0]) - Math.abs(vec[1]));
        }
    }

    public void integerVectorToQuantizedOctahedralCoords(int[] int_vec, int[] out_s, int[] out_t) {
        int t;
        int s;
        if (int_vec[0] >= 0) {
            s = int_vec[1] + this.center_value_;
            t = int_vec[2] + this.center_value_;
        } else {
            s = int_vec[1] < 0 ? Math.abs(int_vec[2]) : this.max_value_ - Math.abs(int_vec[2]);
            t = int_vec[2] < 0 ? Math.abs(int_vec[1]) : this.max_value_ - Math.abs(int_vec[1]);
        }
        this.canonicalizeOctahedralCoords(s, t, out_s, out_t);
    }

    private void canonicalizeOctahedralCoords(int s, int t, int[] out_s, int[] out_t) {
        if (s == 0 && t == 0 || s == 0 && t == this.max_value_ || s == this.max_value_ && t == 0) {
            s = this.max_value_;
            t = this.max_value_;
        } else if (s == 0 && t > this.center_value_) {
            t = this.center_value_ - (t - this.center_value_);
        } else if (s == this.max_value_ && t < this.center_value_) {
            t = this.center_value_ + (this.center_value_ - t);
        } else if (t == this.max_value_ && s < this.center_value_) {
            s = this.center_value_ + (this.center_value_ - s);
        } else if (t == 0 && s > this.center_value_) {
            s = this.center_value_ - (s - this.center_value_);
        }
        out_s[0] = s;
        out_t[0] = t;
    }

    public void floatVectorToQuantizedOctahedralCoords(FloatSpan vector, int[] out_s, int[] out_t) {
        int[] int_vec;
        double abs_sum = Math.abs(vector.get(0)) + Math.abs(vector.get(1)) + Math.abs(vector.get(2));
        double[] scaled_vector = new double[3];
        if (abs_sum > 1.0E-6) {
            double scale = 1.0 / abs_sum;
            scaled_vector[0] = (double)vector.get(0) * scale;
            scaled_vector[1] = (double)vector.get(1) * scale;
            scaled_vector[2] = (double)vector.get(2) * scale;
        } else {
            scaled_vector[0] = 1.0;
            scaled_vector[1] = 0.0;
            scaled_vector[2] = 0.0;
        }
        int_vec = new int[]{(int)Math.floor(scaled_vector[0] * (double)this.center_value_ + 0.5), (int)Math.floor(scaled_vector[1] * (double)this.center_value_ + 0.5), this.center_value_ - Math.abs(int_vec[0]) - Math.abs(int_vec[1])};
        if (int_vec[2] < 0) {
            int_vec[1] = int_vec[1] > 0 ? int_vec[1] + int_vec[2] : int_vec[1] - int_vec[2];
            int_vec[2] = 0;
        }
        if (scaled_vector[2] < 0.0) {
            int_vec[2] = int_vec[2] * -1;
        }
        this.integerVectorToQuantizedOctahedralCoords(int_vec, out_s, out_t);
    }

    public OctahedronToolBox() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.quantization_bits_ = -1;
            this.max_quantized_value_ = -1;
            this.max_value_ = -1;
            this.center_value_ = -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

