/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.GeometryMetadata;
import dev.fileformat.drako.Metadata;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

class MetadataDecoder {
    static final int K_MAX_SUBMETADATA_LEVEL = 1000;

    MetadataDecoder() {
    }

    public GeometryMetadata decode(DecoderBuffer buffer) throws DrakoException {
        int numAttrMetadata = Decoding.decodeVarintU32(buffer);
        GeometryMetadata metadata = new GeometryMetadata();
        int i = 0;
        while ((long)i < (0xFFFFFFFFL & (long)numAttrMetadata)) {
            int attUniqueId = Decoding.decodeVarintU32(buffer);
            Metadata attMetadata = new Metadata();
            this.decodeMetadata(buffer, attMetadata);
            metadata.attributeMetadata.put(attUniqueId, attMetadata);
            ++i;
        }
        this.decodeMetadata(buffer, metadata);
        return metadata;
    }

    private void decodeMetadata(DecoderBuffer buffer, Metadata metadata) throws DrakoException {
        ArrayList<MetadataTuple> stack = new ArrayList<MetadataTuple>();
        stack.add(new MetadataTuple(null, metadata, 0));
        while (!stack.isEmpty()) {
            MetadataTuple mp = (MetadataTuple)stack.get(stack.size() - 1);
            stack.remove(stack.size() - 1);
            metadata = mp.decoded;
            if (mp.parent != null) {
                Metadata subMetadata;
                if (mp.level > 1000) {
                    throw DracoUtils.failed();
                }
                String subMetadataName = this.decodeName(buffer);
                if (subMetadataName == null) {
                    throw DracoUtils.failed();
                }
                metadata = subMetadata = new Metadata();
                mp.parent.subMetadata.put(subMetadataName, subMetadata);
            }
            if (metadata == null) {
                throw DracoUtils.failed();
            }
            int numEntries = Decoding.decodeVarintU32(buffer);
            int i = 0;
            while ((long)i < (0xFFFFFFFFL & (long)numEntries)) {
                this.decodeEntry(buffer, metadata);
                ++i;
            }
            int numSubMetadata = Decoding.decodeVarintU32(buffer);
            if ((0xFFFFFFFFL & (long)numSubMetadata) > (long)buffer.getRemainingSize()) {
                throw DracoUtils.failed();
            }
            int i2 = 0;
            while ((long)i2 < (0xFFFFFFFFL & (long)numSubMetadata)) {
                stack.add(new MetadataTuple(metadata, null, mp.parent != null ? mp.level + 1 : mp.level));
                ++i2;
            }
        }
    }

    private void decodeEntry(DecoderBuffer buffer, Metadata metadata) throws DrakoException {
        String entryName = this.decodeName(buffer);
        if (entryName == null) {
            throw DracoUtils.failed();
        }
        int dataSize = Decoding.decodeVarintU32(buffer);
        if (dataSize == 0 || (0xFFFFFFFFL & (long)dataSize) > (long)buffer.getRemainingSize()) {
            throw DracoUtils.failed();
        }
        byte[] entryValue = new byte[dataSize];
        if (!buffer.decode(entryValue, dataSize)) {
            throw DracoUtils.failed();
        }
        metadata.entries.put(entryName, entryValue);
    }

    private String decodeName(DecoderBuffer buffer) throws DrakoException {
        int nameLen = Decoding.decodeVarintU32(buffer);
        byte[] bytes = new byte[nameLen];
        if (!buffer.decode(bytes, bytes.length)) {
            return null;
        }
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes)).toString();
    }

    static class MetadataTuple {
        public Metadata parent;
        public Metadata decoded;
        public int level;

        public MetadataTuple(Metadata parent, Metadata decoded, int level) {
            this.parent = parent;
            this.decoded = decoded;
            this.level = level;
        }
    }
}

