/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Convert;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshPredictionScheme;
import dev.fileformat.drako.MeshPredictionSchemeData;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PredictionSchemeTransform;
import dev.fileformat.drako.RAnsBitDecoder;
import dev.fileformat.drako.RAnsBitEncoder;
import dev.fileformat.drako.Vector2;
import dev.fileformat.drako.Vector3;
import java.util.ArrayList;

class MeshPredictionSchemeTexCoords
extends MeshPredictionScheme {
    private PointAttribute posAttribute;
    private int[] entryToPointIdMap;
    private int[] predictedValue;
    private int numComponents;
    private ArrayList<Boolean> orientations;

    public MeshPredictionSchemeTexCoords(PointAttribute attribute, PredictionSchemeTransform transform_, MeshPredictionSchemeData meshData) {
        super(attribute, transform_, meshData);
        this.$initFields$();
    }

    @Override
    public int getPredictionMethod() {
        return 3;
    }

    @Override
    public int getNumParentAttributes() {
        return 1;
    }

    @Override
    public int getParentAttributeType(int i) {
        return 0;
    }

    @Override
    public void setParentAttribute(PointAttribute att) {
        if (att.getAttributeType() != 0) {
            throw new IllegalArgumentException();
        }
        if (att.getComponentsCount() != 3) {
            throw new IllegalArgumentException();
        }
        this.posAttribute = att;
    }

    @Override
    public void computeCorrectionValues(IntSpan inData, IntSpan outCorr, int size, int numComponents, int[] entryToPointIdMap) {
        this.numComponents = numComponents;
        this.entryToPointIdMap = entryToPointIdMap;
        this.predictedValue = new int[numComponents];
        IntSpan predictedValueSpan = IntSpan.wrap(this.predictedValue);
        this.transform_.initializeEncoding(inData, numComponents);
        for (int p = this.meshData.dataToCornerMap.getCount() - 1; p >= 0; --p) {
            int cornerId = this.meshData.dataToCornerMap.get(p);
            this.computePredictedValue(true, cornerId, inData, p);
            int dstOffset = p * numComponents;
            this.transform_.computeCorrection(inData, dstOffset, predictedValueSpan, 0, outCorr, 0, dstOffset);
        }
    }

    @Override
    public void computeOriginalValues(IntSpan inCorr, IntSpan outData, int size, int numComponents, int[] entryToPointIdMap) {
        this.numComponents = numComponents;
        this.entryToPointIdMap = entryToPointIdMap;
        this.predictedValue = new int[numComponents];
        IntSpan predictedValueSpan = IntSpan.wrap(this.predictedValue);
        this.transform_.initializeDecoding(numComponents);
        int cornerMapSize = this.meshData.dataToCornerMap.getCount();
        for (int p = 0; p < cornerMapSize; ++p) {
            int cornerId = this.meshData.dataToCornerMap.get(p);
            this.computePredictedValue(false, cornerId, outData, p);
            int dstOffset = p * numComponents;
            this.transform_.computeOriginalValue(predictedValueSpan, 0, inCorr, dstOffset, outData, dstOffset);
        }
    }

    @Override
    public void encodePredictionData(EncoderBuffer buffer) {
        int numOrientations = this.orientations.size();
        buffer.encode2(numOrientations);
        boolean lastOrientation = true;
        RAnsBitEncoder encoder = new RAnsBitEncoder();
        encoder.startEncoding();
        for (int i = 0; i < this.orientations.size(); ++i) {
            boolean orientation = this.orientations.get(i);
            encoder.encodeBit(orientation == lastOrientation);
            lastOrientation = orientation;
        }
        encoder.endEncoding(buffer);
        super.encodePredictionData(buffer);
    }

    @Override
    public void decodePredictionData(DecoderBuffer buffer) throws DrakoException {
        int numOrientations = buffer.decodeI32();
        this.orientations.clear();
        this.orientations.addAll(Convert.asList(new boolean[numOrientations]));
        boolean lastOrientation = true;
        RAnsBitDecoder decoder = new RAnsBitDecoder();
        decoder.startDecoding(buffer);
        for (int i = 0; i < numOrientations; ++i) {
            if (!decoder.decodeNextBit()) {
                lastOrientation = !lastOrientation;
            }
            this.orientations.set(i, lastOrientation);
        }
        decoder.endDecoding();
        super.decodePredictionData(buffer);
    }

    private Vector3 getPositionForEntryId(int entryId) {
        int pointId = this.entryToPointIdMap[entryId];
        Vector3 pos = this.posAttribute.getValueAsVector3(this.posAttribute.mappedIndex(pointId));
        return pos;
    }

    private Vector2 getTexCoordForEntryId(int entryId, IntSpan data) {
        int dataOffset = entryId * this.numComponents;
        return new Vector2(data.get(dataOffset), data.get(dataOffset + 1));
    }

    private void computePredictedValue(boolean isEncoder, int cornerId, IntSpan data, int dataId) {
        int nextCornerId = this.meshData.getCornerTable().next(cornerId);
        int prevCornerId = this.meshData.getCornerTable().previous(cornerId);
        int nextVertId = this.meshData.getCornerTable().vertex(nextCornerId);
        int prevVertId = this.meshData.getCornerTable().vertex(prevCornerId);
        int nextDataId = this.meshData.vertexToDataMap[nextVertId];
        int prevDataId = this.meshData.vertexToDataMap[prevVertId];
        if (prevDataId < dataId && nextDataId < dataId) {
            Vector2 nUv = this.getTexCoordForEntryId(nextDataId, data);
            Vector2 pUv = this.getTexCoordForEntryId(prevDataId, data);
            if (Vector2.op_eq(pUv, nUv)) {
                this.predictedValue[0] = (int)pUv.x;
                this.predictedValue[1] = (int)pUv.y;
                return;
            }
            Vector3 tipPos = this.getPositionForEntryId(dataId);
            Vector3 nextPos = this.getPositionForEntryId(nextDataId);
            Vector3 prevPos = this.getPositionForEntryId(prevDataId);
            Vector3 pn = Vector3.sub(prevPos, nextPos);
            Vector3 cn = Vector3.sub(tipPos, nextPos);
            float pnNorm2Squared = Vector3.dot(pn, pn);
            float s = Vector3.dot(pn, cn) / pnNorm2Squared;
            float t = (float)Math.sqrt(Vector3.sub(cn, Vector3.mul(pn, s)).lengthSquared() / pnNorm2Squared);
            Vector2 pnUv = Vector2.sub(pUv, nUv);
            float pnus = pnUv.x * s + nUv.x;
            float pnut = pnUv.x * t;
            float pnvs = pnUv.y * s + nUv.y;
            float pnvt = pnUv.y * t;
            Vector2 predictedUv = new Vector2();
            if (isEncoder) {
                Vector2 predictedUv0 = new Vector2(pnus - pnvt, pnvs + pnut);
                Vector2 predictedUv1 = new Vector2(pnus + pnvt, pnvs - pnut);
                Vector2 cUv = this.getTexCoordForEntryId(dataId, data);
                if (Vector2.sub(cUv, predictedUv0).lengthSquared() < Vector2.sub(cUv, predictedUv1).lengthSquared()) {
                    predictedUv.copyFrom(predictedUv0);
                    this.orientations.add(true);
                } else {
                    predictedUv.copyFrom(predictedUv1);
                    this.orientations.add(false);
                }
            } else {
                boolean orientation = this.orientations.get(this.orientations.size() - 1);
                this.orientations.remove(this.orientations.size() - 1);
                if (orientation) {
                    predictedUv.copyFrom(new Vector2(pnus - pnvt, pnvs + pnut));
                } else {
                    predictedUv.copyFrom(new Vector2(pnus + pnvt, pnvs - pnut));
                }
            }
            this.predictedValue[0] = (int)Math.floor(predictedUv.x + 0.5f);
            this.predictedValue[1] = (int)Math.floor(predictedUv.y + 0.5f);
            return;
        }
        int dataOffset = 0;
        if (prevDataId < dataId) {
            dataOffset = prevDataId * this.numComponents;
        }
        if (nextDataId < dataId) {
            dataOffset = nextDataId * this.numComponents;
        } else if (dataId > 0) {
            dataOffset = (dataId - 1) * this.numComponents;
        } else {
            for (int i = 0; i < this.numComponents; ++i) {
                this.predictedValue[i] = 0;
            }
            return;
        }
        for (int i = 0; i < this.numComponents; ++i) {
            this.predictedValue[i] = data.get(dataOffset + i);
        }
    }

    private void $initFields$() {
        try {
            this.orientations = new ArrayList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

