/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshPredictionScheme;
import dev.fileformat.drako.MeshPredictionSchemeData;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PredictionSchemeTransform;

class MeshPredictionSchemeParallelogram
extends MeshPredictionScheme {
    public MeshPredictionSchemeParallelogram(PointAttribute attribute, PredictionSchemeTransform transform_, MeshPredictionSchemeData meshData) {
        super(attribute, transform_, meshData);
    }

    @Override
    public int getPredictionMethod() {
        return 1;
    }

    @Override
    public void computeCorrectionValues(IntSpan inData, IntSpan outCorr, int size, int numComponents, int[] entryToPointIdMap) {
        this.transform_.initializeEncoding(inData, numComponents);
        IntSpan predVals = IntSpan.wrap(new int[numComponents]);
        ICornerTable table = this.meshData.getCornerTable();
        int[] vertexToDataMap = this.meshData.vertexToDataMap;
        for (int p = this.meshData.dataToCornerMap.getCount() - 1; p > 0; --p) {
            int cornerId = this.meshData.dataToCornerMap.get(p);
            int dst_offset = p * numComponents;
            if (!MeshPredictionSchemeParallelogram.computeParallelogramPrediction(p, cornerId, table, vertexToDataMap, inData, numComponents, predVals)) {
                int src_offset = (p - 1) * numComponents;
                this.transform_.computeCorrection(inData, dst_offset, inData, src_offset, outCorr, dst_offset, 0);
                continue;
            }
            this.transform_.computeCorrection(inData, dst_offset, predVals, 0, outCorr, dst_offset, 0);
        }
        for (int i = 0; i < numComponents; ++i) {
            predVals.put(i, 0);
        }
        this.transform_.computeCorrection(inData, predVals, outCorr, 0);
    }

    @Override
    public void computeOriginalValues(IntSpan inCorr, IntSpan outData, int size, int numComponents, int[] entryToPointIdMap) {
        this.transform_.initializeDecoding(numComponents);
        ICornerTable table = this.meshData.getCornerTable();
        int[] vertexToDataMap = this.meshData.vertexToDataMap;
        IntSpan predVals = IntSpan.wrap(new int[numComponents]);
        this.transform_.computeOriginalValue(predVals, inCorr, outData);
        int cornerMapSize = this.meshData.dataToCornerMap.getCount();
        for (int p = 1; p < cornerMapSize; ++p) {
            int corner_id = this.meshData.dataToCornerMap.get(p);
            int dst_offset = p * numComponents;
            if (!MeshPredictionSchemeParallelogram.computeParallelogramPrediction(p, corner_id, table, vertexToDataMap, outData, numComponents, predVals)) {
                int src_offset = (p - 1) * numComponents;
                this.transform_.computeOriginalValue(outData, src_offset, inCorr, dst_offset, outData, dst_offset);
                continue;
            }
            this.transform_.computeOriginalValue(predVals, 0, inCorr, dst_offset, outData, dst_offset);
        }
    }

    public static boolean computeParallelogramPrediction(int data_entry_id, int ci, ICornerTable table, int[] vertex_to_data_map, IntSpan in_data, int num_components, IntSpan out_prediction) {
        int oci = table.opposite(ci);
        int[] ref0 = new int[1];
        int[] ref1 = new int[1];
        int[] ref2 = new int[1];
        if (oci == -1) {
            return false;
        }
        int vert_opp = 0;
        int vert_next = 0;
        int vert_prev = 0;
        ref0[0] = vert_opp;
        ref1[0] = vert_next;
        ref2[0] = vert_prev;
        MeshPredictionScheme.getParallelogramEntries(oci, table, vertex_to_data_map, ref0, ref1, ref2);
        vert_opp = ref0[0];
        vert_next = ref1[0];
        vert_prev = ref2[0];
        if (vert_opp < data_entry_id && vert_next < data_entry_id && vert_prev < data_entry_id) {
            int v_opp_off = vert_opp * num_components;
            int v_next_off = vert_next * num_components;
            int v_prev_off = vert_prev * num_components;
            for (int c = 0; c < num_components; ++c) {
                out_prediction.put(c, in_data.get(v_next_off + c) + in_data.get(v_prev_off + c) - in_data.get(v_opp_off + c));
            }
            return true;
        }
        return false;
    }
}

