/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.LongVector3;
import dev.fileformat.drako.MeshPredictionSchemeData;
import dev.fileformat.drako.MeshPredictionSchemeGeometricNormalPredictorBase;
import dev.fileformat.drako.VertexCornersIterator;

class MeshPredictionSchemeGeometricNormalPredictorArea
extends MeshPredictionSchemeGeometricNormalPredictorBase {
    public MeshPredictionSchemeGeometricNormalPredictorArea(MeshPredictionSchemeData meshData) {
        super(meshData);
        this.setNormalPredictionMode((byte)1);
    }

    @Override
    public void computePredictedValue(int corner_id, int[] prediction) {
        ICornerTable corner_table = this.mesh_data_.getCornerTable();
        VertexCornersIterator cit = VertexCornersIterator.fromCorner(corner_table, corner_id);
        LongVector3 pos_cent = this.getPositionForCorner(corner_id);
        LongVector3 normal = new LongVector3();
        while (!cit.getEnd()) {
            int c_prev;
            int c_next;
            if (this.normal_prediction_mode_ == 0) {
                c_next = corner_table.next(corner_id);
                c_prev = corner_table.previous(corner_id);
            } else {
                c_next = corner_table.next(cit.getCorner());
                c_prev = corner_table.previous(cit.getCorner());
            }
            LongVector3 pos_next = this.getPositionForCorner(c_next);
            LongVector3 pos_prev = this.getPositionForCorner(c_prev);
            LongVector3 delta_next = DracoUtils.sub(pos_next, pos_cent);
            LongVector3 delta_prev = DracoUtils.sub(pos_prev, pos_cent);
            LongVector3 cross = DracoUtils.crossProduct(delta_next, delta_prev);
            normal.copyFrom(DracoUtils.add(normal, cross));
            cit.next();
        }
        long upper_bound = 0x20000000L;
        if (this.normal_prediction_mode_ == 0) {
            int abs_sum = (int)DracoUtils.absSum(normal);
            if ((long)abs_sum > upper_bound) {
                long quotient = (long)abs_sum / upper_bound;
                normal.copyFrom(DracoUtils.div(normal, quotient));
            }
        } else {
            long abs_sum = DracoUtils.absSum(normal);
            if (abs_sum > upper_bound) {
                long quotient = abs_sum / upper_bound;
                normal.copyFrom(DracoUtils.div(normal, quotient));
            }
        }
        prediction[0] = (int)normal.x;
        prediction[1] = (int)normal.y;
        prediction[2] = (int)normal.z;
    }

    @Override
    public boolean setNormalPredictionMode(byte mode) {
        if (mode == 0) {
            this.normal_prediction_mode_ = mode;
            return true;
        }
        if (mode == 1) {
            this.normal_prediction_mode_ = mode;
            return true;
        }
        return false;
    }
}

