/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshPredictionScheme;
import dev.fileformat.drako.MeshPredictionSchemeData;
import dev.fileformat.drako.MeshPredictionSchemeGeometricNormalPredictorArea;
import dev.fileformat.drako.OctahedronToolBox;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PredictionSchemeNormalOctahedronTransformBase;
import dev.fileformat.drako.PredictionSchemeTransform;
import dev.fileformat.drako.RAnsBitDecoder;
import dev.fileformat.drako.RAnsBitEncoder;

class MeshPredictionSchemeGeometricNormal
extends MeshPredictionScheme {
    MeshPredictionSchemeGeometricNormalPredictorArea predictor_;
    RAnsBitDecoder flip_normal_bit_decoder_;
    OctahedronToolBox octahedron_tool_box_;
    private RAnsBitEncoder flip_normal_bit_encoder_;

    public MeshPredictionSchemeGeometricNormal(PointAttribute attribute, PredictionSchemeTransform transform, MeshPredictionSchemeData meshData) {
        super(attribute, transform, meshData);
        this.$initFields$();
        this.predictor_ = new MeshPredictionSchemeGeometricNormalPredictorArea(meshData);
        this.octahedron_tool_box_ = new OctahedronToolBox();
        this.flip_normal_bit_decoder_ = new RAnsBitDecoder();
    }

    @Override
    public int getNumParentAttributes() {
        return 1;
    }

    @Override
    public int getParentAttributeType(int i) {
        return 0;
    }

    @Override
    public void setParentAttribute(PointAttribute att) throws DrakoException {
        if (att.getAttributeType() != 0) {
            throw DracoUtils.failed();
        }
        if (att.getComponentsCount() != 3) {
            throw DracoUtils.failed();
        }
        this.predictor_.pos_attribute_ = att;
    }

    @Override
    public boolean getInitialized() {
        if (!this.predictor_.isInitialized()) {
            return false;
        }
        return this.octahedron_tool_box_.isInitialized();
    }

    @Override
    public void computeOriginalValues(IntSpan inCorr, IntSpan outData, int size, int numComponents, int[] entryToPointIdMap) {
        int[] ref0 = new int[1];
        int[] ref1 = new int[1];
        this.octahedron_tool_box_.setQuantizationBits(((PredictionSchemeNormalOctahedronTransformBase)this.transform_).getQuantizationBits());
        this.predictor_.entry_to_point_id_map_ = entryToPointIdMap;
        int corner_map_size = this.meshData.dataToCornerMap.getCount();
        int[] pred_normal_3d = new int[3];
        IntSpan pred_normal_oct = IntSpan.wrap(new int[2]);
        for (int data_id = 0; data_id < corner_map_size; ++data_id) {
            int corner_id = this.meshData.dataToCornerMap.get(data_id);
            this.predictor_.computePredictedValue(corner_id, pred_normal_3d);
            this.octahedron_tool_box_.canonicalizeIntegerVector(pred_normal_3d);
            if (this.flip_normal_bit_decoder_.decodeNextBit()) {
                pred_normal_3d[0] = -pred_normal_3d[0];
                pred_normal_3d[1] = -pred_normal_3d[1];
                pred_normal_3d[2] = -pred_normal_3d[2];
            }
            this.octahedron_tool_box_.integerVectorToQuantizedOctahedralCoords(pred_normal_3d, ref0, ref1);
            int s = ref0[0];
            int t = ref1[0];
            pred_normal_oct.put(0, s);
            pred_normal_oct.put(1, t);
            int data_offset = data_id * 2;
            this.transform_.computeOriginalValue(pred_normal_oct, 0, inCorr, data_offset, outData, data_offset);
        }
        this.flip_normal_bit_decoder_.endDecoding();
    }

    @Override
    public void decodePredictionData(DecoderBuffer buffer) throws DrakoException {
        byte prediction_mode;
        this.transform_.decodeTransformData(buffer);
        if (buffer.getBitstreamVersion() < 22 && !this.predictor_.setNormalPredictionMode(prediction_mode = buffer.decodeU8())) {
            throw DracoUtils.failed();
        }
        this.flip_normal_bit_decoder_.startDecoding(buffer);
    }

    @Override
    public int getPredictionMethod() {
        return 6;
    }

    @Override
    public void computeCorrectionValues(IntSpan in_data, IntSpan out_corr, int size, int num_components, int[] entry_to_point_id_map) {
        int[] ref2 = new int[1];
        int[] ref3 = new int[1];
        int[] ref4 = new int[1];
        int[] ref5 = new int[1];
        this.octahedron_tool_box_.setQuantizationBits(((PredictionSchemeNormalOctahedronTransformBase)this.transform_).getQuantizationBits());
        this.predictor_.entry_to_point_id_map_ = entry_to_point_id_map;
        this.flip_normal_bit_encoder_.startEncoding();
        int corner_map_size = this.meshData.dataToCornerMap.getCount();
        int[] pred_normal_3d = new int[3];
        IntSpan pos_pred_normal_oct = IntSpan.wrap(new int[2]);
        IntSpan neg_pred_normal_oct = IntSpan.wrap(new int[2]);
        IntSpan pos_correction = IntSpan.wrap(new int[2]);
        IntSpan neg_correction = IntSpan.wrap(new int[2]);
        for (int data_id = 0; data_id < corner_map_size; ++data_id) {
            int corner_id = this.meshData.dataToCornerMap.get(data_id);
            this.predictor_.computePredictedValue(corner_id, pred_normal_3d);
            this.octahedron_tool_box_.canonicalizeIntegerVector(pred_normal_3d);
            this.octahedron_tool_box_.integerVectorToQuantizedOctahedralCoords(pred_normal_3d, ref2, ref3);
            int s = ref2[0];
            int t = ref3[0];
            pos_pred_normal_oct.put(0, s);
            pos_pred_normal_oct.put(1, t);
            pred_normal_3d[0] = -pred_normal_3d[0];
            pred_normal_3d[1] = -pred_normal_3d[1];
            pred_normal_3d[2] = -pred_normal_3d[2];
            this.octahedron_tool_box_.integerVectorToQuantizedOctahedralCoords(pred_normal_3d, ref4, ref5);
            s = ref4[0];
            t = ref5[0];
            neg_pred_normal_oct.put(0, s);
            neg_pred_normal_oct.put(1, t);
            int data_offset = data_id * 2;
            this.transform_.computeCorrection(in_data.slice(data_offset), pos_pred_normal_oct, pos_correction, 0);
            this.transform_.computeCorrection(in_data.slice(data_offset), neg_pred_normal_oct, neg_correction, 0);
            pos_correction.put(0, this.octahedron_tool_box_.modMax(pos_correction.get(0)));
            pos_correction.put(1, this.octahedron_tool_box_.modMax(pos_correction.get(1)));
            neg_correction.put(0, this.octahedron_tool_box_.modMax(neg_correction.get(0)));
            neg_correction.put(1, this.octahedron_tool_box_.modMax(neg_correction.get(1)));
            if (DracoUtils.absSum(pos_correction) < DracoUtils.absSum(neg_correction)) {
                this.flip_normal_bit_encoder_.encodeBit(false);
                out_corr.put(data_offset, this.octahedron_tool_box_.makePositive(pos_correction.get(0)));
                out_corr.put(data_offset + 1, this.octahedron_tool_box_.makePositive(pos_correction.get(1)));
                continue;
            }
            this.flip_normal_bit_encoder_.encodeBit(true);
            out_corr.put(data_offset, this.octahedron_tool_box_.makePositive(neg_correction.get(0)));
            out_corr.put(data_offset + 1, this.octahedron_tool_box_.makePositive(neg_correction.get(1)));
        }
    }

    @Override
    public void encodePredictionData(EncoderBuffer buffer) {
        this.transform_.encodeTransformData(buffer);
        this.flip_normal_bit_encoder_.endEncoding(buffer);
    }

    private void $initFields$() {
        try {
            this.flip_normal_bit_encoder_ = new RAnsBitEncoder();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

