/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IMeshEdgeBreakerDecoderImpl;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshEdgeBreakerTraversalDecoder;

class MeshEdgeBreakerTraversalValenceDecoder
extends MeshEdgeBreakerTraversalDecoder {
    private static final int[] EDGE_BREAKER_SYMBOL_TO_TOPOLOGY_ID = new int[]{0, 1, 3, 5, 7};
    CornerTable cornerTable;
    int numVertices = 0;
    private int[] vertexValences;
    private int lastSymbol;
    int activeContext;
    int minValence = 2;
    int maxValence = 7;
    private int[][] contextSymbols;
    private int[] contextCounters;

    @Override
    public void init(IMeshEdgeBreakerDecoderImpl decoder) {
        super.init(decoder);
        this.cornerTable = decoder.getCornerTable();
    }

    @Override
    public void setNumEncodedVertices(int numVertices) {
        this.numVertices = numVertices;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DecoderBuffer start() throws DrakoException {
        DecoderBuffer outBuffer = null;
        if (this.getBitstreamVersion() < 22) {
            super.decodeTraversalSymbols();
        }
        super.decodeStartFaces();
        super.decodeAttributeSeams();
        outBuffer = this.buffer.clone();
        if (this.getBitstreamVersion() < 22) {
            int numSplitSymbols = this.getBitstreamVersion() < 20 ? outBuffer.decodeI32() : Decoding.decodeVarintU32(outBuffer);
            if (numSplitSymbols >= this.numVertices) {
                throw DracoUtils.failed();
            }
            byte mode = outBuffer.decodeU8();
            if (mode != 0) throw DracoUtils.failed();
            this.minValence = 2;
            this.maxValence = 7;
        } else {
            this.minValence = 2;
            this.maxValence = 7;
        }
        if (this.numVertices < 0) {
            throw DracoUtils.failed();
        }
        this.vertexValences = new int[this.numVertices];
        int numUniqueValences = this.maxValence - this.minValence + 1;
        this.contextSymbols = new int[numUniqueValences][];
        this.contextCounters = new int[this.contextSymbols.length];
        for (int i = 0; i < this.contextSymbols.length; ++i) {
            int numSymbols = Decoding.decodeVarintU32(outBuffer);
            if ((0xFFFFFFFFL & (long)numSymbols) <= 0L) continue;
            this.contextSymbols[i] = new int[numSymbols];
            Decoding.decodeSymbols(numSymbols, 1, outBuffer, IntSpan.wrap(this.contextSymbols[i]));
            this.contextCounters[i] = numSymbols;
        }
        return outBuffer;
    }

    @Override
    public int decodeSymbol() {
        if (this.activeContext != -1) {
            int n = this.activeContext;
            this.contextCounters[n] = this.contextCounters[n] - 1;
            int contextCounter = this.contextCounters[n];
            if (contextCounter < 0) {
                return 9;
            }
            int symbol_id = this.contextSymbols[this.activeContext][contextCounter];
            this.lastSymbol = EDGE_BREAKER_SYMBOL_TO_TOPOLOGY_ID[symbol_id];
        } else {
            this.lastSymbol = this.getBitstreamVersion() < 22 ? super.decodeSymbol() : 7;
        }
        return this.lastSymbol;
    }

    @Override
    public void newActiveCornerReached(int corner) {
        int next = this.cornerTable.next(corner);
        int prev = this.cornerTable.previous(corner);
        switch (this.lastSymbol) {
            case 0: 
            case 1: {
                int n = this.cornerTable.vertex(next);
                this.vertexValences[n] = this.vertexValences[n] + 1;
                int n2 = this.cornerTable.vertex(prev);
                this.vertexValences[n2] = this.vertexValences[n2] + 1;
                break;
            }
            case 5: {
                int n = this.cornerTable.vertex(corner);
                this.vertexValences[n] = this.vertexValences[n] + 1;
                int n3 = this.cornerTable.vertex(next);
                this.vertexValences[n3] = this.vertexValences[n3] + 1;
                int n4 = this.cornerTable.vertex(prev);
                this.vertexValences[n4] = this.vertexValences[n4] + 2;
                break;
            }
            case 3: {
                int n = this.cornerTable.vertex(corner);
                this.vertexValences[n] = this.vertexValences[n] + 1;
                int n5 = this.cornerTable.vertex(next);
                this.vertexValences[n5] = this.vertexValences[n5] + 2;
                int n6 = this.cornerTable.vertex(prev);
                this.vertexValences[n6] = this.vertexValences[n6] + 1;
                break;
            }
            case 7: {
                int n = this.cornerTable.vertex(corner);
                this.vertexValences[n] = this.vertexValences[n] + 2;
                int n7 = this.cornerTable.vertex(next);
                this.vertexValences[n7] = this.vertexValences[n7] + 2;
                int n8 = this.cornerTable.vertex(prev);
                this.vertexValences[n8] = this.vertexValences[n8] + 2;
                break;
            }
        }
        int activeValence = this.vertexValences[this.cornerTable.vertex(next)];
        int clampedValence = activeValence < this.minValence ? this.minValence : (activeValence > this.maxValence ? this.maxValence : activeValence);
        this.activeContext = clampedValence - this.minValence;
    }

    @Override
    public void mergeVertices(int dest, int source) {
        int n = dest;
        this.vertexValences[n] = this.vertexValences[n] + this.vertexValences[source];
    }

    public MeshEdgeBreakerTraversalValenceDecoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.lastSymbol = 9;
            this.activeContext = -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

