/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IMeshEdgeBreakerDecoderImpl;
import dev.fileformat.drako.MeshEdgeBreakerTraversalDecoder;
import dev.fileformat.drako.RAnsBitDecoder;
import java.util.Arrays;

class MeshEdgeBreakerTraversalPredictiveDecoder
extends MeshEdgeBreakerTraversalDecoder {
    private CornerTable corner_table_;
    private int num_vertices_;
    private int[] vertex_valences_;
    private RAnsBitDecoder prediction_decoder_;
    private int last_symbol_;
    private int predicted_symbol_;

    @Override
    public void init(IMeshEdgeBreakerDecoderImpl decoder) {
        super.init(decoder);
        this.corner_table_ = decoder.getCornerTable();
    }

    @Override
    public void setNumEncodedVertices(int num_vertices) {
        this.num_vertices_ = num_vertices;
    }

    @Override
    public DecoderBuffer start() throws DrakoException {
        DecoderBuffer out_buffer = super.start();
        int num_split_symbols = out_buffer.decodeI32();
        this.num_vertices_ += num_split_symbols;
        this.vertex_valences_ = this.vertex_valences_ == null ? new int[this.num_vertices_] : Arrays.copyOf(this.vertex_valences_, this.num_vertices_);
        this.prediction_decoder_.startDecoding(out_buffer);
        return out_buffer;
    }

    @Override
    public int decodeSymbol() {
        if (this.predicted_symbol_ != 9 && this.prediction_decoder_.decodeNextBit()) {
            this.last_symbol_ = this.predicted_symbol_;
            return this.predicted_symbol_;
        }
        this.last_symbol_ = super.decodeSymbol();
        return this.last_symbol_;
    }

    @Override
    public void newActiveCornerReached(int corner) {
        int pivot;
        int next = this.corner_table_.next(corner);
        int prev = this.corner_table_.previous(corner);
        switch (this.last_symbol_) {
            case 0: 
            case 1: {
                int n = this.corner_table_.vertex(next);
                this.vertex_valences_[n] = this.vertex_valences_[n] + 1;
                int n2 = this.corner_table_.vertex(prev);
                this.vertex_valences_[n2] = this.vertex_valences_[n2] + 1;
                break;
            }
            case 5: {
                int n = this.corner_table_.vertex(corner);
                this.vertex_valences_[n] = this.vertex_valences_[n] + 1;
                int n3 = this.corner_table_.vertex(next);
                this.vertex_valences_[n3] = this.vertex_valences_[n3] + 1;
                int n4 = this.corner_table_.vertex(prev);
                this.vertex_valences_[n4] = this.vertex_valences_[n4] + 2;
                break;
            }
            case 3: {
                int n = this.corner_table_.vertex(corner);
                this.vertex_valences_[n] = this.vertex_valences_[n] + 1;
                int n5 = this.corner_table_.vertex(next);
                this.vertex_valences_[n5] = this.vertex_valences_[n5] + 2;
                int n6 = this.corner_table_.vertex(prev);
                this.vertex_valences_[n6] = this.vertex_valences_[n6] + 1;
                break;
            }
            case 7: {
                int n = this.corner_table_.vertex(corner);
                this.vertex_valences_[n] = this.vertex_valences_[n] + 2;
                int n7 = this.corner_table_.vertex(next);
                this.vertex_valences_[n7] = this.vertex_valences_[n7] + 2;
                int n8 = this.corner_table_.vertex(prev);
                this.vertex_valences_[n8] = this.vertex_valences_[n8] + 2;
                break;
            }
        }
        this.predicted_symbol_ = this.last_symbol_ == 0 || this.last_symbol_ == 5 ? (this.vertex_valences_[pivot = this.corner_table_.vertex(this.corner_table_.next(corner))] < 6 ? 5 : 0) : 9;
    }

    @Override
    public void mergeVertices(int dest, int source) {
        int n = dest;
        this.vertex_valences_[n] = this.vertex_valences_[n] + this.vertex_valences_[source];
    }

    public MeshEdgeBreakerTraversalPredictiveDecoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.prediction_decoder_ = new RAnsBitDecoder();
            this.last_symbol_ = 9;
            this.predicted_symbol_ = 9;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

