/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IMeshEdgeBreakerDecoderImpl;
import dev.fileformat.drako.ITraversalDecoder;
import dev.fileformat.drako.RAnsBitDecoder;

class MeshEdgeBreakerTraversalDecoder
implements ITraversalDecoder {
    protected DecoderBuffer buffer;
    protected DecoderBuffer symbol_buffer_;
    protected DecoderBuffer startFaceBuffer;
    protected RAnsBitDecoder startFaceDecoder;
    protected RAnsBitDecoder[] attributeConnectivityDecoders;
    protected int numAttributeData;
    protected IMeshEdgeBreakerDecoderImpl decoderImpl;

    @Override
    public boolean decodeAttributeSeam(int attribute) {
        return this.attributeConnectivityDecoders[attribute].decodeNextBit();
    }

    protected int getBitstreamVersion() {
        return this.decoderImpl.getDecoder().getBitstreamVersion();
    }

    @Override
    public void init(IMeshEdgeBreakerDecoderImpl decoder) {
        this.decoderImpl = decoder;
        this.buffer = decoder.getDecoder().getBuffer().subBuffer(0);
    }

    @Override
    public void setNumEncodedVertices(int numVertices) {
    }

    @Override
    public void setNumAttributeData(int numData) {
        this.numAttributeData = numData;
    }

    @Override
    public DecoderBuffer start() throws DrakoException {
        this.decodeTraversalSymbols();
        this.decodeStartFaces();
        this.decodeAttributeSeams();
        return this.buffer;
    }

    @Override
    public void done() {
        if (this.symbol_buffer_.getBitDecoderActive()) {
            this.symbol_buffer_.endBitDecoding();
        }
        if (this.getBitstreamVersion() < 22) {
            this.startFaceBuffer.endBitDecoding();
        } else {
            this.startFaceDecoder.endDecoding();
        }
    }

    @Override
    public int decodeSymbol() {
        int s;
        int[] ref0 = new int[1];
        int[] ref1 = new int[1];
        this.symbol_buffer_.decodeLeastSignificantBits32(1, ref0);
        int symbol = s = ref0[0];
        if (symbol == 0) {
            return symbol;
        }
        this.symbol_buffer_.decodeLeastSignificantBits32(2, ref1);
        int symbolSuffix = ref1[0];
        return s |= symbolSuffix << 1;
    }

    @Override
    public void mergeVertices(int dest, int source) {
    }

    @Override
    public void newActiveCornerReached(int corner) {
    }

    @Override
    public boolean decodeStartFaceConfiguration() {
        int[] ref2 = new int[1];
        if (this.getBitstreamVersion() < 22) {
            this.startFaceBuffer.decodeLeastSignificantBits32(1, ref2);
            int face_configuration = ref2[0];
            return (0xFFFFFFFFL & (long)face_configuration) != 0L;
        }
        boolean ret = this.startFaceDecoder.decodeNextBit();
        return ret;
    }

    protected void decodeTraversalSymbols() throws DrakoException {
        this.symbol_buffer_ = this.buffer.clone();
        long traversalSize = this.symbol_buffer_.startBitDecoding(true);
        this.buffer = this.symbol_buffer_.clone();
        if (traversalSize > (long)this.buffer.getRemainingSize()) {
            throw DracoUtils.failed();
        }
        this.buffer.advance((int)traversalSize);
    }

    protected void decodeStartFaces() throws DrakoException {
        if (this.getBitstreamVersion() < 22) {
            this.startFaceBuffer = this.buffer.clone();
            long traversalSize = this.startFaceBuffer.startBitDecoding(true);
            this.buffer = this.startFaceBuffer.clone();
            if (traversalSize > (long)this.buffer.getRemainingSize()) {
                throw DracoUtils.failed();
            }
            this.buffer.advance((int)traversalSize);
            return;
        }
        this.startFaceDecoder.startDecoding(this.buffer);
    }

    protected void decodeAttributeSeams() throws DrakoException {
        if (this.numAttributeData > 0) {
            this.attributeConnectivityDecoders = new RAnsBitDecoder[this.numAttributeData];
            for (int i = 0; i < this.numAttributeData; ++i) {
                this.attributeConnectivityDecoders[i] = new RAnsBitDecoder();
                this.attributeConnectivityDecoders[i].startDecoding(this.buffer);
            }
        }
    }

    public MeshEdgeBreakerTraversalDecoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.symbol_buffer_ = new DecoderBuffer();
            this.startFaceDecoder = new RAnsBitDecoder();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

