/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AsposeUtils;
import dev.fileformat.drako.AttributesDecoder;
import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DracoMesh;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EdgeBreakerTraverser;
import dev.fileformat.drako.HoleEventData;
import dev.fileformat.drako.IMeshEdgeBreakerDecoderImpl;
import dev.fileformat.drako.ITraversalDecoder;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.MeshAttributeCornerTable;
import dev.fileformat.drako.MeshAttributeIndicesEncodingData;
import dev.fileformat.drako.MeshAttributeIndicesEncodingObserver;
import dev.fileformat.drako.MeshEdgeBreakerDecoder;
import dev.fileformat.drako.MeshTraversalSequencer;
import dev.fileformat.drako.PredictionDegreeTraverser;
import dev.fileformat.drako.SequentialAttributeDecodersController;
import dev.fileformat.drako.Struct;
import dev.fileformat.drako.TopologySplitEventData;
import dev.fileformat.drako.TraverserBase;
import dev.fileformat.drako.VertexCornersIterator;
import java.util.ArrayList;
import java.util.HashMap;

class MeshEdgeBreakerDecoderImpl
implements IMeshEdgeBreakerDecoderImpl {
    private MeshEdgeBreakerDecoder decoder;
    private CornerTable cornerTable;
    private IntList cornerTraversalStack;
    private IntList vertexTraversalLength;
    private ArrayList<TopologySplitEventData> topologySplitData;
    private ArrayList<HoleEventData> holeEventData;
    private int numProcessedHoleEvents;
    private ArrayList<Boolean> initFaceConfigurations;
    private IntList initCorners;
    private IntList vertexIdMap;
    private int lastSymbolId;
    private int lastVertId;
    private int lastFaceId;
    private ArrayList<Boolean> visitedFaces;
    private ArrayList<Boolean> visitedVerts;
    private boolean[] isVertHole;
    private int numNewVertices;
    private HashMap<Integer, Integer> newToParentVertexMap;
    private int numEncodedVertices;
    private IntList processedCornerIds;
    private IntList processedConnectivityCorners;
    private MeshAttributeIndicesEncodingData posEncodingData;
    private int posDataDecoderId;
    private AttributeData[] attributeData;
    private ITraversalDecoder traversalDecoder;

    public MeshEdgeBreakerDecoderImpl(MeshEdgeBreakerDecoder decoder, ITraversalDecoder traversalDecoder) {
        this.$initFields$();
        this.init(decoder);
        this.traversalDecoder = traversalDecoder;
    }

    @Override
    public void init(MeshEdgeBreakerDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public MeshAttributeCornerTable getAttributeCornerTable(int attId) {
        for (int i = 0; i < this.attributeData.length; ++i) {
            AttributesDecoder dec = this.decoder.getAttributesDecoders()[this.attributeData[i].decoderId];
            for (int j = 0; j < dec.getNumAttributes(); ++j) {
                if (dec.getAttributeId(j) != attId) continue;
                if (this.attributeData[i].isConnectivityUsed) {
                    return this.attributeData[i].connectivityData;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public MeshAttributeIndicesEncodingData getAttributeEncodingData(int attId) {
        for (int i = 0; i < this.attributeData.length; ++i) {
            AttributesDecoder dec = this.decoder.getAttributesDecoders()[this.attributeData[i].decoderId];
            for (int j = 0; j < dec.getNumAttributes(); ++j) {
                if (dec.getAttributeId(j) != attId) continue;
                return this.attributeData[i].encodingData;
            }
        }
        return this.posEncodingData;
    }

    @Override
    public void createAttributesDecoder(int attDecoderId) throws DrakoException {
        MeshTraversalSequencer<CornerTable> sequencer;
        byte attDataId = this.decoder.getBuffer().decodeI8();
        byte decoderType = this.decoder.getBuffer().decodeU8();
        if (attDataId >= 0) {
            if (attDataId >= this.attributeData.length) {
                throw DracoUtils.failed();
            }
            this.attributeData[0xFF & attDataId].decoderId = attDecoderId;
        } else {
            if (this.posDataDecoderId >= 0) {
                throw DracoUtils.failed();
            }
            this.posDataDecoderId = attDecoderId;
        }
        byte traversalMethod = 0;
        if (this.decoder.getBitstreamVersion() >= 12) {
            byte encoded;
            traversalMethod = encoded = this.decoder.getBuffer().decodeU8();
        }
        DracoMesh mesh = this.decoder.getMesh();
        if (decoderType == 0) {
            TraverserBase attTraverser;
            MeshAttributeIndicesEncodingData encodingData = null;
            if (attDataId < 0) {
                encodingData = this.posEncodingData;
            } else {
                encodingData = this.attributeData[0xFF & attDataId].encodingData;
                this.attributeData[0xFF & attDataId].isConnectivityUsed = false;
            }
            MeshTraversalSequencer<CornerTable> traversalSequencer = new MeshTraversalSequencer<CornerTable>(mesh, encodingData);
            MeshAttributeIndicesEncodingObserver<CornerTable> attObserver = new MeshAttributeIndicesEncodingObserver<CornerTable>(this.cornerTable, mesh, traversalSequencer, encodingData);
            if (traversalMethod == 0) {
                attTraverser = new EdgeBreakerTraverser<CornerTable>(attObserver);
            } else if (traversalMethod == 1) {
                attTraverser = new PredictionDegreeTraverser(attObserver);
            } else {
                throw DracoUtils.failed();
            }
            traversalSequencer.setTraverser(attTraverser);
            sequencer = traversalSequencer;
        } else {
            if (attDataId < 0) {
                throw DracoUtils.failed();
            }
            MeshTraversalSequencer<MeshAttributeCornerTable> traversalSequencer = new MeshTraversalSequencer<MeshAttributeCornerTable>(mesh, this.attributeData[0xFF & attDataId].encodingData);
            MeshAttributeIndicesEncodingObserver<MeshAttributeCornerTable> attObserver = new MeshAttributeIndicesEncodingObserver<MeshAttributeCornerTable>(this.attributeData[0xFF & attDataId].connectivityData, mesh, traversalSequencer, this.attributeData[0xFF & attDataId].encodingData);
            EdgeBreakerTraverser<MeshAttributeCornerTable> attTraverser = new EdgeBreakerTraverser<MeshAttributeCornerTable>(attObserver);
            traversalSequencer.setTraverser(attTraverser);
            sequencer = traversalSequencer;
        }
        SequentialAttributeDecodersController attController = new SequentialAttributeDecodersController(sequencer);
        this.decoder.setAttributesDecoder(attDecoderId, attController);
    }

    @Override
    public void decodeConnectivity() throws DrakoException {
        int i;
        int i2;
        this.numNewVertices = 0;
        this.newToParentVertexMap.clear();
        if (this.decoder.getBitstreamVersion() < 22) {
            int num_new_verts = this.decoder.getBitstreamVersion() < 20 ? this.decoder.getBuffer().decodeU32() : Decoding.decodeVarintU32(this.decoder.getBuffer());
            this.numNewVertices = num_new_verts;
        }
        int numEncodedVertices = this.decoder.getBitstreamVersion() < 20 ? this.decoder.getBuffer().decodeU32() : Decoding.decodeVarintU32(this.decoder.getBuffer());
        this.numEncodedVertices = numEncodedVertices;
        int numFaces = this.decoder.getBitstreamVersion() < 20 ? this.decoder.getBuffer().decodeU32() : Decoding.decodeVarintU32(this.decoder.getBuffer());
        if ((0xFFFFFFFFL & (long)numFaces) > 0x2FFFFFFFL) {
            throw DracoUtils.failed();
        }
        if ((0xFFFFFFFFL & (long)numEncodedVertices) > (long)(numFaces * 3)) {
            throw DracoUtils.failed();
        }
        byte numAttributeData = this.decoder.getBuffer().decodeU8();
        int numEncodedSymbols = this.decoder.getBitstreamVersion() < 20 ? this.decoder.getBuffer().decodeU32() : Decoding.decodeVarintU32(this.decoder.getBuffer());
        if ((0xFFFFFFFFL & (long)numFaces) < (0xFFFFFFFFL & (long)numEncodedSymbols)) {
            throw DracoUtils.failed();
        }
        int max_encoded_faces = numEncodedSymbols + numEncodedSymbols / 3;
        if ((0xFFFFFFFFL & (long)numFaces) > (0xFFFFFFFFL & (long)max_encoded_faces)) {
            throw DracoUtils.failed();
        }
        int numEncodedSplitSymbols = this.decoder.getBitstreamVersion() < 20 ? this.decoder.getBuffer().decodeU32() : Decoding.decodeVarintU32(this.decoder.getBuffer());
        if ((0xFFFFFFFFL & (long)numEncodedSplitSymbols) > (0xFFFFFFFFL & (long)numEncodedSymbols)) {
            throw DracoUtils.failed();
        }
        this.vertexTraversalLength.clear();
        this.cornerTable = new CornerTable();
        this.processedCornerIds.clear();
        this.processedCornerIds.setCapacity(numFaces);
        this.processedConnectivityCorners.clear();
        this.processedConnectivityCorners.setCapacity(numFaces);
        this.topologySplitData.clear();
        this.holeEventData.clear();
        this.initFaceConfigurations.clear();
        this.initCorners.clear();
        this.numProcessedHoleEvents = 0;
        this.lastSymbolId = -1;
        this.lastFaceId = -1;
        this.lastVertId = -1;
        this.attributeData = new AttributeData[0xFF & numAttributeData];
        this.cornerTable.reset(numFaces, numEncodedVertices + numEncodedSplitSymbols);
        for (i2 = 0; i2 < this.attributeData.length; ++i2) {
            this.attributeData[i2] = new AttributeData();
        }
        this.isVertHole = new boolean[numEncodedVertices + numEncodedSplitSymbols];
        for (i2 = 0; i2 < this.isVertHole.length; ++i2) {
            this.isVertHole[i2] = true;
        }
        int topologySplitDecodedBytes = -1;
        if (this.decoder.getBitstreamVersion() < 22) {
            int encodedConnectivitySize = this.decoder.getBitstreamVersion() < 20 ? this.decoder.getBuffer().decodeU32() : Decoding.decodeVarintU32(this.decoder.getBuffer());
            if (encodedConnectivitySize == 0 || (0xFFFFFFFFL & (long)encodedConnectivitySize) > (long)this.decoder.getBuffer().getRemainingSize()) {
                throw DracoUtils.failed();
            }
            DecoderBuffer eventBuffer = this.decoder.getBuffer().subBuffer(encodedConnectivitySize);
            topologySplitDecodedBytes = this.decodeHoleAndTopologySplitEvents(eventBuffer);
            if (topologySplitDecodedBytes == -1) {
                throw DracoUtils.failed();
            }
        } else if (this.decodeHoleAndTopologySplitEvents(this.decoder.getBuffer()) == -1) {
            throw DracoUtils.failed();
        }
        this.traversalDecoder.init(this);
        this.traversalDecoder.setNumEncodedVertices(numEncodedVertices + numEncodedSplitSymbols);
        this.traversalDecoder.setNumAttributeData(0xFF & numAttributeData);
        DecoderBuffer traversalEndBuffer = this.traversalDecoder.start();
        int numConnectivityVerts = this.decodeConnectivity(numEncodedSymbols);
        if (numConnectivityVerts == -1) {
            throw DracoUtils.failed();
        }
        this.decoder.setBuffer(traversalEndBuffer.subBuffer(0));
        if (this.decoder.getBitstreamVersion() < 22) {
            this.decoder.getBuffer().advance(topologySplitDecodedBytes);
        }
        if (this.attributeData.length > 0) {
            int ci;
            if (this.decoder.getBitstreamVersion() < 21) {
                for (ci = 0; ci < this.cornerTable.getNumCorners(); ci += 3) {
                    this.decodeAttributeConnectivitiesOnFaceLegacy(ci);
                }
            } else {
                for (ci = 0; ci < this.cornerTable.getNumCorners(); ci += 3) {
                    this.decodeAttributeConnectivitiesOnFace(ci);
                }
            }
        }
        this.traversalDecoder.done();
        for (i = 0; i < this.attributeData.length; ++i) {
            this.attributeData[i].connectivityData = new MeshAttributeCornerTable(this.cornerTable);
            IntList corners = this.attributeData[i].attributeSeamCorners;
            for (int j = 0; j < corners.getCount(); ++j) {
                int c = corners.get(j);
                this.attributeData[i].connectivityData.addSeamEdge(c);
            }
            this.attributeData[i].connectivityData.recomputeVertices(null, null);
        }
        this.posEncodingData.vertexToEncodedAttributeValueIndexMap = new int[this.cornerTable.getNumVertices()];
        for (i = 0; i < this.attributeData.length; ++i) {
            int attConnectivityVerts = this.attributeData[i].connectivityData.getNumVertices();
            if (attConnectivityVerts < this.cornerTable.getNumVertices()) {
                attConnectivityVerts = this.cornerTable.getNumVertices();
            }
            this.attributeData[i].encodingData.vertexToEncodedAttributeValueIndexMap = new int[attConnectivityVerts];
        }
        if (!this.assignPointsToCorners()) {
            throw DracoUtils.failed();
        }
    }

    @Override
    public void onAttributesDecoded() {
    }

    @Override
    public MeshEdgeBreakerDecoder getDecoder() {
        return this.decoder;
    }

    @Override
    public CornerTable getCornerTable() {
        return this.cornerTable;
    }

    private boolean assignPointsToCorners() {
        int c;
        this.decoder.getMesh().setNumFaces(this.cornerTable.getNumFaces());
        int[] face = new int[3];
        if (this.attributeData.length == 0) {
            int numPoints = 0;
            int[] vertexToPointMap = new int[this.cornerTable.getNumVertices()];
            DracoUtils.fill(vertexToPointMap, -1);
            for (int f = 0; f < this.decoder.getMesh().getNumFaces(); ++f) {
                for (int c2 = 0; c2 < 3; ++c2) {
                    int vertId = this.cornerTable.vertex(3 * f + c2);
                    int pointId = vertexToPointMap[vertId];
                    if (pointId == -1) {
                        int tmp0;
                        vertexToPointMap[vertId] = tmp0 = numPoints++;
                        pointId = tmp0;
                    }
                    face[c2] = pointId;
                }
                this.decoder.getMesh().setFace(f, face);
            }
            this.decoder.getPointCloud().setNumPoints(numPoints);
            return true;
        }
        IntList pointToCornerMap = new IntList();
        int[] cornerToPointMap = new int[this.cornerTable.getNumCorners()];
        for (int v = 0; v < this.cornerTable.getNumVertices(); ++v) {
            c = this.cornerTable.leftMostCorner(v);
            if (c < 0) continue;
            int deduplicationFirstCorner = c;
            if (this.isVertHole[v]) {
                deduplicationFirstCorner = c;
            } else {
                for (int i = 0; i < this.attributeData.length; ++i) {
                    if (!this.attributeData[i].connectivityData.isCornerOnSeam(c)) continue;
                    int vertId = this.attributeData[i].connectivityData.vertex(c);
                    int actC = this.cornerTable.swingRight(c);
                    boolean seamFound = false;
                    while (actC != c) {
                        if (this.attributeData[i].connectivityData.vertex(actC) != vertId) {
                            deduplicationFirstCorner = actC;
                            seamFound = true;
                            break;
                        }
                        actC = this.cornerTable.swingRight(actC);
                    }
                    if (seamFound) break;
                }
            }
            c = deduplicationFirstCorner;
            cornerToPointMap[c] = pointToCornerMap.getCount();
            pointToCornerMap.add(c);
            int prevC = c;
            c = this.cornerTable.swingRight(c);
            while (c >= 0 && c != deduplicationFirstCorner) {
                boolean attributeSeam = false;
                for (int i = 0; i < this.attributeData.length; ++i) {
                    if (this.attributeData[i].connectivityData.vertex(c) == this.attributeData[i].connectivityData.vertex(prevC)) continue;
                    attributeSeam = true;
                    break;
                }
                if (attributeSeam) {
                    cornerToPointMap[c] = pointToCornerMap.getCount();
                    pointToCornerMap.add(c);
                } else {
                    cornerToPointMap[c] = cornerToPointMap[prevC];
                }
                prevC = c;
                c = this.cornerTable.swingRight(c);
            }
        }
        for (int f = 0; f < this.decoder.getMesh().getNumFaces(); ++f) {
            for (c = 0; c < 3; ++c) {
                face[c] = cornerToPointMap[3 * f + c];
            }
            this.decoder.getMesh().setFace(f, face);
        }
        this.decoder.getPointCloud().setNumPoints(pointToCornerMap.getCount());
        return true;
    }

    int decodeHoleAndTopologySplitEvents(DecoderBuffer decoderBuffer) throws DrakoException {
        block17: {
            int[] ref1 = new int[1];
            int[] ref2 = new int[1];
            int numTopologySplits = this.decoder.getBitstreamVersion() < 20 ? decoderBuffer.decodeU32() : Decoding.decodeVarintU32(decoderBuffer);
            if ((0xFFFFFFFFL & (long)numTopologySplits) > 0L) {
                if ((0xFFFFFFFFL & (long)numTopologySplits) > (long)this.cornerTable.getNumFaces()) {
                    return -1;
                }
                if (this.decoder.getBitstreamVersion() < 12) {
                    int i = 0;
                    while ((long)i < (0xFFFFFFFFL & (long)numTopologySplits)) {
                        TopologySplitEventData eventData = new TopologySplitEventData();
                        eventData.splitSymbolId = decoderBuffer.decodeI32();
                        eventData.sourceSymbolId = decoderBuffer.decodeI32();
                        byte edgeData = decoderBuffer.decodeU8();
                        eventData.sourceEdge = (byte)(0xFF & edgeData & 1);
                        eventData.splitEdge = (byte)((0xFF & edgeData) >>> 1 & 1);
                        this.topologySplitData.add(eventData);
                        ++i;
                    }
                } else {
                    int last_source_symbol_id = 0;
                    int i = 0;
                    while ((long)i < (0xFFFFFFFFL & (long)numTopologySplits)) {
                        TopologySplitEventData event_data = new TopologySplitEventData();
                        int delta = Decoding.decodeVarintU32(decoderBuffer);
                        event_data.sourceSymbolId = delta + last_source_symbol_id;
                        delta = Decoding.decodeVarintU32(decoderBuffer);
                        if ((0xFFFFFFFFL & (long)delta) > (long)event_data.sourceSymbolId) {
                            return -1;
                        }
                        event_data.splitSymbolId = event_data.sourceSymbolId - delta;
                        last_source_symbol_id = event_data.sourceSymbolId;
                        this.topologySplitData.add(event_data);
                        ++i;
                    }
                    long tmp = decoderBuffer.startBitDecoding(false);
                    int i2 = 0;
                    while ((long)i2 < (0xFFFFFFFFL & (long)numTopologySplits)) {
                        int edge_data;
                        if (this.decoder.getBitstreamVersion() < 22) {
                            decoderBuffer.decodeLeastSignificantBits32(2, ref1);
                            edge_data = ref1[0];
                        } else {
                            decoderBuffer.decodeLeastSignificantBits32(1, ref2);
                            edge_data = ref2[0];
                        }
                        this.topologySplitData.get((int)i2).sourceEdge = (byte)(edge_data & 1);
                        ++i2;
                    }
                    decoderBuffer.endBitDecoding();
                }
            }
            int numHoleEvents = 0;
            if (this.decoder.getBitstreamVersion() < 20) {
                numHoleEvents = decoderBuffer.decodeU32();
            } else if (this.decoder.getBitstreamVersion() < 21) {
                numHoleEvents = Decoding.decodeVarintU32(decoderBuffer);
            }
            if ((0xFFFFFFFFL & (long)numHoleEvents) <= 0L) break block17;
            if (this.decoder.getBitstreamVersion() < 12) {
                int i = 0;
                while ((0xFFFFFFFFL & (long)i) < (0xFFFFFFFFL & (long)numHoleEvents)) {
                    HoleEventData eventData = new HoleEventData();
                    eventData.symbolId = decoderBuffer.decodeI32();
                    this.holeEventData.add(Struct.byVal(eventData));
                    ++i;
                }
            } else {
                int last_symbol_id = 0;
                int i = 0;
                while ((long)i < (0xFFFFFFFFL & (long)numHoleEvents)) {
                    HoleEventData event_data = new HoleEventData();
                    int delta = Decoding.decodeVarintU32(decoderBuffer);
                    last_symbol_id = event_data.symbolId = delta + last_symbol_id;
                    this.holeEventData.add(Struct.byVal(event_data));
                    ++i;
                }
            }
        }
        return decoderBuffer.getDecodedSize();
    }

    private int decodeConnectivity(int numSymbols) {
        int corner_b;
        IntList activeCornerStack = new IntList();
        HashMap<Integer, Integer> topologySplitActiveCorners = new HashMap<Integer, Integer>();
        boolean removeInvalidVertices = this.attributeData.length == 0;
        IntList invalidVertices = new IntList();
        int maxNumVertices = this.isVertHole.length;
        int numFaces = 0;
        Integer[] ref3 = new Integer[1];
        byte[] ref5 = new byte[1];
        int[] ref6 = new int[1];
        for (int symbolId = 0; symbolId < numSymbols; ++symbolId) {
            int encoderSplitSymbolId;
            byte split_edge;
            int face = numFaces++;
            boolean checkTopologySplit = false;
            int symbol = this.traversalDecoder.decodeSymbol();
            if (symbol == 0) {
                if (activeCornerStack.getCount() == 0) {
                    return -1;
                }
                int cornerA = activeCornerStack.get(activeCornerStack.getCount() - 1);
                int vertexX = this.cornerTable.vertex(this.cornerTable.next(cornerA));
                int cornerB = this.cornerTable.next(this.cornerTable.leftMostCorner(vertexX));
                int corner = 3 * face;
                this.setOppositeCorners(cornerA, corner + 1);
                this.setOppositeCorners(cornerB, corner + 2);
                this.cornerTable.mapCornerToVertex(corner, vertexX);
                this.cornerTable.mapCornerToVertex(corner + 1, this.cornerTable.vertex(this.cornerTable.next(cornerB)));
                int vert_a_prev = this.cornerTable.vertex(this.cornerTable.previous(cornerA));
                this.cornerTable.mapCornerToVertex(corner + 2, vert_a_prev);
                this.cornerTable.setLeftMostCorner(vert_a_prev, corner + 2);
                this.isVertHole[vertexX] = false;
                activeCornerStack.set(activeCornerStack.getCount() - 1, corner);
            } else if (symbol == 5 || symbol == 3) {
                int corner_r;
                int corner_l;
                int opp_corner;
                if (activeCornerStack.getCount() == 0) {
                    return -1;
                }
                int corner_a = activeCornerStack.get(activeCornerStack.getCount() - 1);
                int corner = 3 * face;
                if (symbol == 5) {
                    opp_corner = corner + 2;
                    corner_l = corner + 1;
                    corner_r = corner;
                } else {
                    opp_corner = corner + 1;
                    corner_l = corner;
                    corner_r = corner + 2;
                }
                this.setOppositeCorners(opp_corner, corner_a);
                int new_vert_index = this.cornerTable.addNewVertex();
                if (this.cornerTable.getNumVertices() > maxNumVertices) {
                    return -1;
                }
                this.cornerTable.mapCornerToVertex(opp_corner, new_vert_index);
                this.cornerTable.setLeftMostCorner(new_vert_index, opp_corner);
                int vertex_r = this.cornerTable.vertex(this.cornerTable.previous(corner_a));
                this.cornerTable.mapCornerToVertex(corner_r, vertex_r);
                this.cornerTable.setLeftMostCorner(vertex_r, corner_r);
                this.cornerTable.mapCornerToVertex(corner_l, this.cornerTable.vertex(this.cornerTable.next(corner_a)));
                activeCornerStack.set(activeCornerStack.getCount() - 1, corner);
                checkTopologySplit = true;
            } else if (symbol == 1) {
                boolean tmp4;
                int tmp;
                if (activeCornerStack.getCount() == 0) {
                    return -1;
                }
                corner_b = activeCornerStack.get(activeCornerStack.getCount() - 1);
                activeCornerStack.removeAt(activeCornerStack.getCount() - 1);
                if (AsposeUtils.tryGetValue(topologySplitActiveCorners, Integer.valueOf(symbolId), ref3)) {
                    tmp = ref3[0] == null ? 0 : ref3[0];
                    activeCornerStack.add(tmp);
                } else {
                    int n = tmp = ref3[0] == null ? 0 : ref3[0];
                }
                if (activeCornerStack.getCount() == 0) {
                    return -1;
                }
                int corner_a = activeCornerStack.get(activeCornerStack.getCount() - 1);
                boolean bl = tmp4 = this.cornerTable.opposite(corner_a) != -1;
                if (tmp4 || this.cornerTable.opposite(corner_b) != -1) {
                    return -1;
                }
                int corner = 3 * face;
                this.setOppositeCorners(corner_a, corner + 2);
                this.setOppositeCorners(corner_b, corner + 1);
                int vertex_p = this.cornerTable.vertex(this.cornerTable.previous(corner_a));
                this.cornerTable.mapCornerToVertex(corner, vertex_p);
                this.cornerTable.mapCornerToVertex(corner + 1, this.cornerTable.vertex(this.cornerTable.next(corner_a)));
                int vert_b_prev = this.cornerTable.vertex(this.cornerTable.previous(corner_b));
                this.cornerTable.mapCornerToVertex(corner + 2, vert_b_prev);
                this.cornerTable.setLeftMostCorner(vert_b_prev, corner + 2);
                int corner_n = this.cornerTable.next(corner_b);
                int vertex_n = this.cornerTable.vertex(corner_n);
                this.traversalDecoder.mergeVertices(vertex_p, vertex_n);
                this.cornerTable.setLeftMostCorner(vertex_p, this.cornerTable.leftMostCorner(vertex_n));
                while (corner_n != -1) {
                    this.cornerTable.mapCornerToVertex(corner_n, vertex_p);
                    corner_n = this.cornerTable.swingLeft(corner_n);
                }
                this.cornerTable.makeVertexIsolated(vertex_n);
                if (removeInvalidVertices) {
                    invalidVertices.add(vertex_n);
                }
                activeCornerStack.set(activeCornerStack.getCount() - 1, corner);
            } else if (symbol == 7) {
                int corner = 3 * face;
                int firstVertIdx = this.cornerTable.addNewVertex();
                this.cornerTable.mapCornerToVertex(corner, firstVertIdx);
                this.cornerTable.mapCornerToVertex(corner + 1, this.cornerTable.addNewVertex());
                this.cornerTable.mapCornerToVertex(corner + 2, this.cornerTable.addNewVertex());
                if (this.cornerTable.getNumVertices() > maxNumVertices) {
                    return -1;
                }
                this.cornerTable.setLeftMostCorner(firstVertIdx, corner);
                this.cornerTable.setLeftMostCorner(firstVertIdx + 1, corner + 1);
                this.cornerTable.setLeftMostCorner(firstVertIdx + 2, corner + 2);
                activeCornerStack.add(corner);
                checkTopologySplit = true;
            } else {
                return -1;
            }
            this.traversalDecoder.newActiveCornerReached(activeCornerStack.get(activeCornerStack.getCount() - 1));
            if (!checkTopologySplit) continue;
            int encoder_symbol_id = numSymbols - symbolId - 1;
            while (this.isTopologySplit(encoder_symbol_id, ref5, ref6)) {
                split_edge = ref5[0];
                encoderSplitSymbolId = ref6[0];
                if (encoderSplitSymbolId < 0) {
                    return -1;
                }
                int act_top_corner = activeCornerStack.getBack();
                int new_active_corner = split_edge == 1 ? this.cornerTable.next(act_top_corner) : this.cornerTable.previous(act_top_corner);
                int decoderSplitSymbolId = numSymbols - encoderSplitSymbolId - 1;
                topologySplitActiveCorners.put(decoderSplitSymbolId, new_active_corner);
            }
            split_edge = ref5[0];
            encoderSplitSymbolId = ref6[0];
        }
        if (this.cornerTable.getNumVertices() > maxNumVertices) {
            return -1;
        }
        while (activeCornerStack.getCount() > 0) {
            int corner = activeCornerStack.getBack();
            activeCornerStack.popBack();
            boolean interior_face = this.traversalDecoder.decodeStartFaceConfiguration();
            if (interior_face) {
                if (numFaces >= this.cornerTable.getNumFaces()) {
                    return -1;
                }
                int corner_a = corner;
                int vert_n = this.cornerTable.vertex(this.cornerTable.next(corner_a));
                corner_b = this.cornerTable.next(this.cornerTable.leftMostCorner(vert_n));
                int vert_x = this.cornerTable.vertex(this.cornerTable.next(corner_b));
                int corner_c = this.cornerTable.next(this.cornerTable.leftMostCorner(vert_x));
                int vert_p = this.cornerTable.vertex(this.cornerTable.next(corner_c));
                int face = numFaces++;
                int new_corner = 3 * face;
                this.setOppositeCorners(new_corner, corner);
                this.setOppositeCorners(new_corner + 1, corner_b);
                this.setOppositeCorners(new_corner + 2, corner_c);
                this.cornerTable.mapCornerToVertex(new_corner, vert_x);
                this.cornerTable.mapCornerToVertex(new_corner + 1, vert_p);
                this.cornerTable.mapCornerToVertex(new_corner + 2, vert_n);
                for (int ci = 0; ci < 3; ++ci) {
                    this.isVertHole[this.cornerTable.vertex((int)(new_corner + ci))] = false;
                }
                this.initFaceConfigurations.add(true);
                this.initCorners.add(new_corner);
                continue;
            }
            this.initFaceConfigurations.add(false);
            this.initCorners.add(corner);
        }
        if (numFaces != this.cornerTable.getNumFaces()) {
            return -1;
        }
        int num_vertices = this.cornerTable.getNumVertices();
        for (int i = 0; i < invalidVertices.getCount(); ++i) {
            int invalidVert = invalidVertices.get(i);
            int srcVert = num_vertices - 1;
            while (this.cornerTable.leftMostCorner(srcVert) == -1) {
                srcVert = --num_vertices - 1;
            }
            if (srcVert < invalidVert) continue;
            VertexCornersIterator vcit = VertexCornersIterator.fromVertex(this.cornerTable, srcVert);
            while (!vcit.getEnd()) {
                int cid = vcit.getCorner();
                this.cornerTable.mapCornerToVertex(cid, invalidVert);
                vcit.next();
            }
            this.cornerTable.setLeftMostCorner(invalidVert, this.cornerTable.leftMostCorner(srcVert));
            this.cornerTable.makeVertexIsolated(srcVert);
            this.isVertHole[invalidVert] = this.isVertHole[srcVert];
            this.isVertHole[srcVert] = false;
            --num_vertices;
        }
        return num_vertices;
    }

    private void setOppositeCorners(int corner0, int corner1) {
        this.cornerTable.setOppositeCorner(corner0, corner1);
        this.cornerTable.setOppositeCorner(corner1, corner0);
    }

    private boolean isTopologySplit(int encoderSymbolId, byte[] outFaceEdge, int[] outEncoderSplitSymbolId) {
        outFaceEdge[0] = 0;
        outEncoderSplitSymbolId[0] = 0;
        if (this.topologySplitData.isEmpty()) {
            return false;
        }
        TopologySplitEventData back = this.topologySplitData.get(this.topologySplitData.size() - 1);
        if (back.sourceSymbolId > encoderSymbolId) {
            outEncoderSplitSymbolId[0] = -1;
            return true;
        }
        if (back.sourceSymbolId != encoderSymbolId) {
            return false;
        }
        outFaceEdge[0] = back.sourceEdge;
        outEncoderSplitSymbolId[0] = back.splitSymbolId;
        this.topologySplitData.remove(this.topologySplitData.size() - 1);
        return true;
    }

    private void decodeAttributeConnectivitiesOnFaceLegacy(int corner) {
        this.decodeAttributeConnectivitiesOnFaceLegacyImpl(corner);
        this.decodeAttributeConnectivitiesOnFaceLegacyImpl(this.cornerTable.next(corner));
        this.decodeAttributeConnectivitiesOnFaceLegacyImpl(this.cornerTable.previous(corner));
    }

    private void decodeAttributeConnectivitiesOnFaceLegacyImpl(int corner) {
        int oppCorner = this.cornerTable.opposite(corner);
        if (oppCorner < 0) {
            for (int i = 0; i < this.attributeData.length; ++i) {
                this.attributeData[i].attributeSeamCorners.add(corner);
            }
            return;
        }
        for (int i = 0; i < this.attributeData.length; ++i) {
            boolean isSeam = this.traversalDecoder.decodeAttributeSeam(i);
            if (!isSeam) continue;
            this.attributeData[i].attributeSeamCorners.add(corner);
        }
    }

    private void decodeAttributeConnectivitiesOnFace(int corner) {
        int src_face_id = this.cornerTable.face(corner);
        this.decodeAttributeConnectivitiesOnFace(corner, src_face_id);
        this.decodeAttributeConnectivitiesOnFace(this.cornerTable.next(corner), src_face_id);
        this.decodeAttributeConnectivitiesOnFace(this.cornerTable.previous(corner), src_face_id);
    }

    private void decodeAttributeConnectivitiesOnFace(int corner, int src_face_id) {
        int opp_corner = this.cornerTable.opposite(corner);
        if (opp_corner == -1) {
            for (int i = 0; i < this.attributeData.length; ++i) {
                this.attributeData[i].attributeSeamCorners.add(corner);
            }
            return;
        }
        int opp_face_id = this.cornerTable.face(opp_corner);
        if (opp_face_id < src_face_id) {
            return;
        }
        for (int i = 0; i < this.attributeData.length; ++i) {
            boolean is_seam = this.traversalDecoder.decodeAttributeSeam(i);
            if (!is_seam) continue;
            this.attributeData[i].attributeSeamCorners.add(corner);
        }
    }

    private void $initFields$() {
        try {
            this.cornerTraversalStack = new IntList();
            this.vertexTraversalLength = new IntList();
            this.topologySplitData = new ArrayList();
            this.holeEventData = new ArrayList();
            this.initFaceConfigurations = new ArrayList();
            this.initCorners = new IntList();
            this.vertexIdMap = new IntList();
            this.lastSymbolId = -1;
            this.lastVertId = -1;
            this.lastFaceId = -1;
            this.visitedFaces = new ArrayList();
            this.visitedVerts = new ArrayList();
            this.newToParentVertexMap = new HashMap();
            this.processedCornerIds = new IntList();
            this.processedConnectivityCorners = new IntList();
            this.posEncodingData = new MeshAttributeIndicesEncodingData();
            this.posDataDecoderId = -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class AttributeData {
        int decoderId = -1;
        MeshAttributeCornerTable connectivityData;
        boolean isConnectivityUsed = true;
        MeshAttributeIndicesEncodingData encodingData = new MeshAttributeIndicesEncodingData();
        IntList attributeSeamCorners = new IntList();

        AttributeData() {
        }
    }
}

