/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Convert;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.NotImplementedException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@Internal
class ListUtils {
    ListUtils() {
    }

    public static class NativeArrayList<T>
    extends AbstractList<T>
    implements List<T> {
        private Object array;
        private int size;

        public NativeArrayList(Object data) {
            this.array = data;
            this.size = Array.getLength(data);
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            return false;
        }

        @Override
        public T get(int index) {
            return (T)Array.get(this.array, index);
        }

        @Override
        public T set(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < this.size; ++i) {
                if (this.get(i) != o) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.get(i) != o) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return new GeneralArrayListIterator(this, index);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    public static class IntList
    extends AbstractCollection<Integer>
    implements List<Integer> {
        private int[] data;
        private int fromIndex;
        private int size;

        public IntList(int[] data) {
            this(data, 0, data.length);
        }

        private IntList(int[] data, int fromIndex, int size) {
            this.data = data;
            this.fromIndex = fromIndex;
            this.size = size;
        }

        @Override
        public Integer get(int index) {
            return this.data[index];
        }

        @Override
        public Integer set(int index, Integer element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Integer element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof Integer)) {
                return -1;
            }
            int val = (Integer)o;
            for (int i = 0; i < this.data.length; ++i) {
                if (val != this.data[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!(o instanceof Integer)) {
                return -1;
            }
            int val = (Integer)o;
            for (int i = this.data.length - 1; i >= 0; --i) {
                if (val != this.data[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<Integer> listIterator(int index) {
            return new GeneralArrayListIterator<Integer>(this, index);
        }

        @Override
        public List<Integer> subList(int fromIndex, int toIndex) {
            return new IntList(this.data, this.fromIndex + fromIndex, this.fromIndex + toIndex);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.listIterator();
        }

        @Override
        public Object[] toArray() {
            return Convert.box(this.data);
        }

        public int[] toNativeArray() {
            throw new NotImplementedException();
        }

        public Integer[] toArray(Integer[] a) {
            Integer[] ret = a;
            if (a.length != this.size()) {
                ret = new Integer[this.size()];
            }
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.get(i);
            }
            return ret;
        }

        @Override
        public boolean add(Integer integer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Integer> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public static class GeneralArrayListIterator<T>
    implements ListIterator<T> {
        private List<T> list;
        private int start;
        private int end;
        private int index;

        public GeneralArrayListIterator(List<T> list, int start) {
            this.list = list;
            this.start = start;
            this.end = list.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.end;
        }

        @Override
        public T next() {
            return this.list.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > this.start;
        }

        @Override
        public T previous() {
            return this.list.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }
    }
}

