/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributeQuantizationTransform;
import dev.fileformat.drako.AttributesDecoder;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.Dequantizer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.DynamicIntegerPointsKdTreeDecoder;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointAttributeInfo;
import dev.fileformat.drako.PointAttributeVectorOutputIterator;
import java.util.ArrayList;

class KdTreeAttributesDecoder
extends AttributesDecoder {
    private ArrayList<AttributeQuantizationTransform> attribute_quantization_transforms_;
    private IntList min_signed_values_;
    private ArrayList<PointAttribute> quantized_portable_attributes_;

    @Override
    protected void decodePortableAttributes(DecoderBuffer buffer) throws DrakoException {
        if (buffer.getBitstreamVersion() < 23) {
            return;
        }
        byte compression_level = buffer.decodeU8();
        int num_points = this.getDecoder().getPointCloud().getNumPoints();
        int num_attributes = this.getNumAttributes();
        int total_dimensionality = 0;
        PointAttributeInfo[] atts = new PointAttributeInfo[num_attributes];
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            int att_id = this.getAttributeId(i);
            PointAttribute att = this.getDecoder().getPointCloud().attribute(att_id);
            att.reset(num_points);
            att.setIdentityMapping(true);
            PointAttribute target_att = null;
            if (att.getDataType() == 6 || att.getDataType() == 4 || att.getDataType() == 2) {
                target_att = att;
            } else if (att.getDataType() == 5 || att.getDataType() == 3 || att.getDataType() == 1) {
                for (int c = 0; c < att.getComponentsCount(); ++c) {
                    this.min_signed_values_.add(0);
                }
                target_att = att;
            } else if (att.getDataType() == 9) {
                PointAttribute port_att = new PointAttribute(att.getAttributeType(), 6, att.getComponentsCount(), false, att.getComponentsCount() * DracoUtils.dataTypeLength(6), 0);
                port_att.setIdentityMapping(true);
                port_att.reset(num_points);
                this.quantized_portable_attributes_.add(port_att);
                target_att = port_att;
            } else {
                throw DracoUtils.failed();
            }
            int data_type = target_att.getDataType();
            int data_size = Math.max(0, DracoUtils.dataTypeLength(data_type));
            int num_components = target_att.getComponentsCount();
            atts[i] = new PointAttributeInfo(target_att, total_dimensionality, data_type, data_size, num_components);
            total_dimensionality += num_components;
        }
        PointAttributeVectorOutputIterator out_it = new PointAttributeVectorOutputIterator(atts);
        DynamicIntegerPointsKdTreeDecoder decoder = new DynamicIntegerPointsKdTreeDecoder(0xFF & compression_level, total_dimensionality);
        decoder.decodePoints(buffer, out_it);
    }

    @Override
    protected void decodeDataNeededByPortableTransforms(DecoderBuffer in_buffer) throws DrakoException {
        if (in_buffer.getBitstreamVersion() >= 23) {
            int i;
            for (i = 0; i < this.getNumAttributes(); ++i) {
                int att_id = this.getAttributeId(i);
                PointAttribute att = this.getDecoder().getPointCloud().attribute(att_id);
                if (att.getDataType() != 9) continue;
                int num_components = att.getComponentsCount();
                float[] min_value = new float[num_components];
                if (!in_buffer.decode(min_value)) {
                    throw DracoUtils.failed();
                }
                float max_value_dif = in_buffer.decodeF32();
                byte quantization_bits = in_buffer.decodeU8();
                if ((0xFF & quantization_bits) > 31) {
                    throw DracoUtils.failed();
                }
                AttributeQuantizationTransform transform = new AttributeQuantizationTransform();
                transform.setParameters(0xFF & quantization_bits, min_value, num_components, max_value_dif);
                int num_transforms = this.attribute_quantization_transforms_.size();
                transform.transferToAttribute(this.quantized_portable_attributes_.get(num_transforms));
                this.attribute_quantization_transforms_.add(transform);
            }
            for (i = 0; i < this.min_signed_values_.getCount(); ++i) {
                int val = Decoding.decodeVarintU32(in_buffer);
                this.min_signed_values_.set(i, val);
            }
            return;
        }
        throw DracoUtils.failed();
    }

    void transformAttributeBackToSignedType_short(PointAttribute att, int num_processed_signed_components) {
        short[] unsigned_val = new short[att.getComponentsCount()];
        short[] signed_val = new short[att.getComponentsCount()];
        for (int avi = 0; avi < att.getNumUniqueEntries(); ++avi) {
            att.getValue(avi, unsigned_val);
            for (int c = 0; c < att.getComponentsCount(); ++c) {
                signed_val[c] = (short)((0xFFFF & unsigned_val[c]) + this.min_signed_values_.get(num_processed_signed_components + c));
            }
            att.setAttributeValue(avi, signed_val);
        }
    }

    void transformAttributeBackToSignedType_sbyte(PointAttribute att, int num_processed_signed_components) {
        byte[] unsigned_val = new byte[att.getComponentsCount()];
        byte[] signed_val = new byte[att.getComponentsCount()];
        for (int avi = 0; avi < att.getNumUniqueEntries(); ++avi) {
            att.getValue(avi, unsigned_val);
            for (int c = 0; c < att.getComponentsCount(); ++c) {
                signed_val[c] = (byte)((0xFF & unsigned_val[c]) + this.min_signed_values_.get(num_processed_signed_components + c));
            }
            att.setAttributeValue(avi, signed_val, 0);
        }
    }

    void transformAttributeBackToSignedType_int(PointAttribute att, int num_processed_signed_components) {
        int[] unsigned_val = new int[att.getComponentsCount()];
        int[] signed_val = new int[att.getComponentsCount()];
        for (int avi = 0; avi < att.getNumUniqueEntries(); ++avi) {
            att.getValue(avi, unsigned_val);
            for (int c = 0; c < att.getComponentsCount(); ++c) {
                signed_val[c] = unsigned_val[c] + this.min_signed_values_.get(num_processed_signed_components + c);
            }
            att.setAttributeValue(avi, signed_val);
        }
    }

    @Override
    protected void transformAttributesToOriginalFormat() {
        if (this.quantized_portable_attributes_.isEmpty() && this.min_signed_values_.getCount() == 0) {
            return;
        }
        int num_processed_quantized_attributes = 0;
        int num_processed_signed_components = 0;
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            int att_id = this.getAttributeId(i);
            PointAttribute att = this.getDecoder().getPointCloud().attribute(att_id);
            if (att.getDataType() == 5 || att.getDataType() == 3 || att.getDataType() == 1) {
                int[] unsigned_val = new int[att.getComponentsCount()];
                int[] signed_val = new int[att.getComponentsCount()];
                if (att.getDataType() == 5) {
                    this.transformAttributeBackToSignedType_int(att, num_processed_signed_components);
                } else if (att.getDataType() == 3) {
                    this.transformAttributeBackToSignedType_short(att, num_processed_signed_components);
                } else if (att.getDataType() == 1) {
                    this.transformAttributeBackToSignedType_sbyte(att, num_processed_signed_components);
                }
                num_processed_signed_components += att.getComponentsCount();
                continue;
            }
            if (att.getDataType() != 9) continue;
            PointAttribute src_att = this.quantized_portable_attributes_.get(num_processed_quantized_attributes);
            AttributeQuantizationTransform transform = this.attribute_quantization_transforms_.get(num_processed_quantized_attributes);
            ++num_processed_quantized_attributes;
            if (this.getDecoder().options.skipAttributeTransform) {
                att.copyFrom(src_att);
                continue;
            }
            int max_quantized_value = (1 << transform.quantization_bits_) - 1;
            int num_components = att.getComponentsCount();
            int entry_size = 4 * num_components;
            float[] att_val = new float[num_components];
            int quant_val_id = 0;
            int out_byte_pos = 0;
            Dequantizer dequantizer = new Dequantizer(transform.range_, max_quantized_value);
            IntSpan portable_attribute_data = src_att.getBuffer().asIntArray();
            for (int j = 0; j < src_att.getNumUniqueEntries(); ++j) {
                for (int c = 0; c < num_components; ++c) {
                    float value = dequantizer.dequantizeFloat(portable_attribute_data.get(quant_val_id++));
                    att_val[c] = value += transform.min_values_[c];
                }
                att.getBuffer().write(out_byte_pos, att_val);
                out_byte_pos += entry_size;
            }
        }
    }

    @Override
    public PointAttribute getPortableAttribute(int attId) {
        return null;
    }

    public KdTreeAttributesDecoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.attribute_quantization_transforms_ = new ArrayList();
            this.min_signed_values_ = new IntList();
            this.quantized_portable_attributes_ = new ArrayList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

