/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IBitDecoder;
import dev.fileformat.drako.RAnsBitDecoder;

class FoldedBit32Decoder
implements IBitDecoder {
    RAnsBitDecoder[] folded_number_decoders_;
    RAnsBitDecoder bit_decoder_;

    public FoldedBit32Decoder() {
        this.$initFields$();
        for (int i = 0; i < this.folded_number_decoders_.length; ++i) {
            this.folded_number_decoders_[i] = new RAnsBitDecoder();
        }
        this.bit_decoder_ = new RAnsBitDecoder();
    }

    @Override
    public void startDecoding(DecoderBuffer source_buffer) throws DrakoException {
        for (int i = 0; i < 32; ++i) {
            this.folded_number_decoders_[i].startDecoding(source_buffer);
        }
        this.bit_decoder_.startDecoding(source_buffer);
    }

    @Override
    public boolean decodeNextBit() {
        return this.bit_decoder_.decodeNextBit();
    }

    @Override
    public int decodeLeastSignificantBits32(int nbits) {
        int result = 0;
        for (int i = 0; i < nbits; ++i) {
            boolean bit = this.folded_number_decoders_[i].decodeNextBit();
            result = (result << 1) + (bit ? 1 : 0);
        }
        return result;
    }

    @Override
    public void endDecoding() {
        for (int i = 0; i < 32; ++i) {
            this.folded_number_decoders_[i].endDecoding();
        }
        this.bit_decoder_.endDecoding();
    }

    public void clear() {
        for (int i = 0; i < 32; ++i) {
            this.folded_number_decoders_[i].clear();
        }
        this.bit_decoder_.clear();
    }

    private void $initFields$() {
        try {
            this.folded_number_decoders_ = new RAnsBitDecoder[32];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

