/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Stream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileStream
extends Stream {
    public static final int CREATE = 0;
    public static final int OPEN = 1;
    public static final int APPEND = 2;
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static final int WRITE_BUF_SIZE = 2048;
    private static final int READ_BUF_SIZE = 2048;
    RandomAccessFile ra;
    private long cursor;
    private long length;
    private byte[] writeBuf;
    private int writeBufSize = 0;
    private byte[] readBuf;
    private int readBufSize = 0;
    private int readBufStart = 0;
    private byte[] tmp = new byte[1];

    public FileStream(String fileName, int fileMode, int fileAccess) throws IOException {
        this.init(fileName, fileMode, fileAccess);
    }

    public FileStream(String fileName, int fileMode) throws IOException {
        this.init(fileName, fileMode, fileMode == 2 ? 2 : 3);
    }

    public FileStream(File file, int fileMode, int fileAccess) throws IOException {
        this.init(file, fileMode, fileAccess);
    }

    private void init(String fileName, int fileMode, int fileAccess) throws IOException {
        File f = new File(fileName);
        if (!f.exists() && fileMode != 0) {
            throw new FileNotFoundException();
        }
        this.init(f, fileMode, fileAccess);
    }

    private void init(File file, int fileMode, int fileAccess) throws IOException {
        if (fileMode == 0 && file.exists()) {
            file.delete();
        }
        String mode = null;
        if (fileAccess == 1) {
            mode = "r";
        } else if (fileAccess == 2) {
            mode = "rw";
        } else if (fileAccess == 3) {
            mode = "rw";
        } else {
            throw new IOException("Invalid file access.");
        }
        this.ra = new RandomAccessFile(file, mode);
        this.length = this.ra.length();
        if ((fileAccess & 2) != 0) {
            this.writeBuf = new byte[2048];
        }
        if ((fileAccess & 1) != 0) {
            this.readBuf = new byte[2048];
        }
    }

    @Override
    public long getLength() throws IOException {
        return this.ra.length();
    }

    @Override
    public void setLength(long len) throws IOException {
        this.ra.setLength(len);
    }

    @Override
    public int readByte() throws IOException {
        int bytesRead = this.read(this.tmp, 0, 1);
        if (bytesRead == 0) {
            return -1;
        }
        return this.tmp[0] & 0xFF;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int start, int len) throws IOException {
        int expectToRead;
        int p = start;
        int end = start + len;
        boolean eof = false;
        for (long available = this.length - this.cursor; p < end && available > 0L; available -= (long)expectToRead) {
            expectToRead = (int)Math.min(available, (long)Math.min(end - p, this.readBufSize));
            if (expectToRead == 0) {
                int t = this.ra.read(this.readBuf, 0, this.readBuf.length);
                if (t == -1) {
                    eof = true;
                    break;
                }
                this.readBufStart = 0;
                this.readBufSize = t;
                expectToRead = Math.min(end - p, this.readBufSize);
            }
            if (expectToRead == -1) break;
            System.arraycopy(this.readBuf, this.readBufStart, buf, p, expectToRead);
            p += expectToRead;
            this.readBufStart += expectToRead;
            this.readBufSize -= expectToRead;
        }
        int bytesToRead = p - start;
        this.cursor += (long)bytesToRead;
        return bytesToRead;
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int start, int len) throws IOException {
        int p = start;
        int end = start + len;
        int bytesToWrite = 0;
        while (p < end) {
            int cap = 2048 - this.writeBufSize;
            int rest = end - p;
            int write = Math.min(cap, rest);
            if (write == 0) {
                this.flush();
                write = Math.min(cap, rest);
            }
            System.arraycopy(buf, p, this.writeBuf, this.writeBufSize, write);
            p += write;
            this.writeBufSize += write;
            bytesToWrite += write;
        }
        this.cursor += (long)bytesToWrite;
        if (this.cursor > this.length) {
            this.length = this.cursor;
        }
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.tmp[0] = (byte)b;
        this.write(this.tmp, 0, 1);
    }

    @Override
    public long seek(long offset, int seek) throws IOException {
        if (offset == 0L && seek == 1) {
            return this.cursor;
        }
        long newCursor = 0L;
        this.flush();
        switch (seek) {
            case 0: {
                newCursor = offset;
                break;
            }
            case 1: {
                newCursor = this.cursor + offset;
                break;
            }
            case 2: {
                newCursor = this.length + offset;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SeekOrigin type.");
            }
        }
        if (newCursor != this.cursor) {
            this.cursor = newCursor;
            this.ra.seek(newCursor);
            this.readBufSize = 0;
            this.readBufStart = 0;
        }
        return this.cursor;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.ra.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.writeBufSize > 0) {
            this.ra.write(this.writeBuf, 0, this.writeBufSize);
            this.writeBufSize = 0;
        }
    }
}

