/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IBitEncoder;
import dev.fileformat.drako.IntList;

class DirectBitEncoder
implements IBitEncoder {
    private IntList bits_;
    int local_bits_;
    int num_local_bits_;

    @Override
    public void startEncoding() {
        this.clear();
    }

    @Override
    public void encodeBit(boolean bit) {
        if (bit) {
            this.local_bits_ |= 1 << 31 - this.num_local_bits_;
        }
        ++this.num_local_bits_;
        if (this.num_local_bits_ == 32) {
            this.bits_.add(this.local_bits_);
            this.num_local_bits_ = 0;
            this.local_bits_ = 0;
        }
    }

    @Override
    public void encodeLeastSignificantBits32(int nbits, int value) {
        int remaining = 32 - this.num_local_bits_;
        value <<= 32 - nbits;
        if (nbits <= remaining) {
            this.local_bits_ |= (value >>>= this.num_local_bits_);
            this.num_local_bits_ += nbits;
            if (this.num_local_bits_ == 32) {
                this.bits_.add(this.local_bits_);
                this.local_bits_ = 0;
                this.num_local_bits_ = 0;
            }
        } else {
            this.num_local_bits_ = nbits - remaining;
            int value_l = (value >>>= 32 - nbits) >>> this.num_local_bits_;
            this.local_bits_ |= value_l;
            this.bits_.add(this.local_bits_);
            this.local_bits_ = value << 32 - this.num_local_bits_;
        }
    }

    @Override
    public void endEncoding(EncoderBuffer target_buffer) {
        this.bits_.add(this.local_bits_);
        int size_in_byte = this.bits_.getCount() * 4;
        target_buffer.encode2(size_in_byte);
        target_buffer.encode(this.bits_);
        this.clear();
    }

    @Override
    public void clear() {
        this.bits_.clear();
        this.local_bits_ = 0;
        this.num_local_bits_ = 0;
    }

    public DirectBitEncoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.bits_ = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

