/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IBitDecoder;

class DirectBitDecoder
implements IBitDecoder {
    int[] bits_;
    int pos_;
    int num_used_bits_;

    DirectBitDecoder() {
    }

    public void clear() {
        this.bits_ = null;
        this.num_used_bits_ = 0;
        this.pos_ = 0;
    }

    @Override
    public void startDecoding(DecoderBuffer source_buffer) throws DrakoException {
        this.clear();
        int size_in_bytes = source_buffer.decodeI32();
        if (size_in_bytes == 0 || (size_in_bytes & 3) != 0) {
            throw DracoUtils.failed();
        }
        if (size_in_bytes > source_buffer.getRemainingSize()) {
            throw DracoUtils.failed();
        }
        int num_32bit_elements = size_in_bytes / 4;
        this.bits_ = new int[num_32bit_elements];
        if (!source_buffer.decode(this.bits_)) {
            throw DracoUtils.failed();
        }
        this.pos_ = 0;
        this.num_used_bits_ = 0;
    }

    @Override
    public boolean decodeNextBit() {
        int selector = 1 << 31 - this.num_used_bits_;
        if (this.pos_ == this.bits_.length) {
            return false;
        }
        boolean bit = (this.bits_[this.pos_] & selector) != 0;
        ++this.num_used_bits_;
        if (this.num_used_bits_ == 32) {
            ++this.pos_;
            this.num_used_bits_ = 0;
        }
        return bit;
    }

    @Override
    public int decodeLeastSignificantBits32(int nbits) {
        int remaining = 32 - this.num_used_bits_;
        int value = 0;
        if (nbits <= remaining) {
            if (this.pos_ == this.bits_.length) {
                return 0;
            }
            value = this.bits_[this.pos_] << this.num_used_bits_ >>> 32 - nbits;
            this.num_used_bits_ += nbits;
            if (this.num_used_bits_ == 32) {
                ++this.pos_;
                this.num_used_bits_ = 0;
            }
        } else {
            if (this.pos_ + 1 == this.bits_.length) {
                return 0;
            }
            int value_l = this.bits_[this.pos_] << this.num_used_bits_;
            this.num_used_bits_ = nbits - remaining;
            ++this.pos_;
            int value_r = this.bits_[this.pos_] >>> 32 - this.num_used_bits_;
            value = value_l >>> 32 - this.num_used_bits_ - remaining | value_r;
        }
        return value;
    }

    @Override
    public void endDecoding() {
    }
}

