/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.RAnsSymbolDecoder;

class Decoding {
    Decoding() {
    }

    static void decodeSymbols(int numValues, int numComponents, DecoderBuffer srcBuffer, IntSpan outValues) throws DrakoException {
        if (numValues < 0) {
            throw DracoUtils.failed();
        }
        if (numValues == 0) {
            return;
        }
        byte scheme = srcBuffer.decodeU8();
        if (scheme == 0) {
            Decoding.decodeTaggedSymbols(numValues, numComponents, srcBuffer, outValues);
        } else if (scheme == 1) {
            Decoding.decodeRawSymbols(numValues, srcBuffer, outValues);
        } else {
            throw DracoUtils.failed();
        }
    }

    static boolean decodeTaggedSymbols(int numValues, int numComponents, DecoderBuffer srcBuffer, IntSpan outValues) throws DrakoException {
        RAnsSymbolDecoder tagDecoder = new RAnsSymbolDecoder(5);
        int[] ref0 = new int[1];
        tagDecoder.create(srcBuffer);
        tagDecoder.startDecoding(srcBuffer);
        if (numValues > 0 && tagDecoder.getNumSymbols() == 0) {
            throw DracoUtils.failed();
        }
        long tmp = srcBuffer.startBitDecoding(false);
        int valueId = 0;
        for (int i = 0; i < numValues; i += numComponents) {
            int bitLength = tagDecoder.decodeSymbol();
            for (int j = 0; j < numComponents; ++j) {
                int val;
                if (!srcBuffer.decodeLeastSignificantBits32(bitLength, ref0)) {
                    val = ref0[0];
                    throw DracoUtils.failed();
                }
                val = ref0[0];
                outValues.put(valueId++, val);
            }
        }
        tagDecoder.endDecoding();
        srcBuffer.endBitDecoding();
        return true;
    }

    static void decodeRawSymbols(int numValues, DecoderBuffer srcBuffer, IntSpan outValues) throws DrakoException {
        byte maxBitLength = srcBuffer.decodeU8();
        RAnsSymbolDecoder decoder = new RAnsSymbolDecoder(0xFF & maxBitLength);
        decoder.create(srcBuffer);
        if (numValues > 0 && decoder.getNumSymbols() == 0) {
            throw DracoUtils.failed();
        }
        decoder.startDecoding(srcBuffer);
        for (int i = 0; i < numValues; ++i) {
            int value = decoder.decodeSymbol();
            outValues.put(i, value);
        }
        decoder.endDecoding();
    }

    public static void convertSymbolsToSignedInts(IntSpan symbols, IntSpan result) {
        for (int i = 0; i < symbols.size(); ++i) {
            int val = symbols.get(i);
            boolean isNegative = (val & 1) != 0;
            int ret = val >>= 1;
            if (isNegative) {
                ret = -ret - 1;
            }
            result.put(i, ret);
        }
    }

    public static int decodeVarintU32(DecoderBuffer buffer) throws DrakoException {
        int out_val;
        byte in_ = buffer.decodeU8();
        if ((0xFF & in_ & 0x80) != 0) {
            out_val = Decoding.decodeVarintU32(buffer);
            out_val <<= 7;
            out_val |= 0xFF & in_ & 0x7F;
        } else {
            out_val = 0xFF & in_;
        }
        return out_val;
    }

    public static short decodeVarintU16(DecoderBuffer buffer) throws DrakoException {
        short out_val;
        byte in_ = buffer.decodeU8();
        if ((0xFF & in_ & 0x80) != 0) {
            out_val = Decoding.decodeVarintU16(buffer);
            out_val = (short)(out_val << 7);
            out_val = (short)(out_val | (short)(0xFF & in_ & 0x7F));
        } else {
            out_val = (short)(0xFF & in_);
        }
        return out_val;
    }

    public static long decodeVarintU64(DecoderBuffer buffer) throws DrakoException {
        long out_val;
        byte in_ = buffer.decodeU8();
        if ((0xFF & in_ & 0x80) != 0) {
            out_val = Decoding.decodeVarintU64(buffer);
            out_val <<= 7;
            out_val |= 0xFFFFFFFFL & (long)(0xFF & in_ & 0x7F);
        } else {
            out_val = 0xFF & in_;
        }
        return out_val;
    }
}

