/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.HashBuilder;
import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.Int2D;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.MetaClasses;
import dev.fileformat.drako.Struct;
import dev.fileformat.drako.ValenceCache;
import java.io.Serializable;
import java.util.Arrays;

class CornerTable
extends ICornerTable {
    public static final int K_INVALID_FACE_INDEX = -1;
    public static final int K_INVALID_CORNER_INDEX = -1;
    public static final int K_INVALID_VERTEX_INDEX = -1;
    private int[] oppositeCorners;
    private IntList vertexCorners;
    private int[] cornerToVertexMap;
    private int numOriginalVertices;
    private int numDegeneratedFaces;
    private int numIsolatedVertices;
    private IntList nonManifoldVertexParents;
    private ValenceCache valenceCache;

    public CornerTable() {
        this.$initFields$();
        this.valenceCache = new ValenceCache(this);
    }

    public void initialize(Int2D faces) {
        int[] ref0 = new int[1];
        this.valenceCache.clearValenceCache();
        this.valenceCache.clearValenceCacheInaccurate();
        int numFaces = faces.getLength(0);
        this.cornerToVertexMap = new int[numFaces * 3];
        for (int fi = 0; fi < numFaces; ++fi) {
            for (int i = 0; i < 3; ++i) {
                int corner = this.firstCorner(fi);
                this.cornerToVertexMap[corner + i] = faces.get(fi, i);
            }
        }
        int numVertices = -1;
        this.computeOppositeCorners(ref0);
        numVertices = ref0[0];
        this.computeVertexCorners(numVertices);
    }

    public int[] allCorners(int face) {
        int ci = face * 3;
        return new int[]{ci, ci + 1, ci + 2};
    }

    @Override
    public int opposite(int corner) {
        if (corner < 0) {
            return corner;
        }
        return this.oppositeCorners[corner];
    }

    @Override
    public int vertex(int corner) {
        if (corner < 0) {
            return -1;
        }
        return this.cornerToVertexMap[corner];
    }

    public int face(int corner) {
        if (corner < 0) {
            return -1;
        }
        return corner / 3;
    }

    public int firstCorner(int face) {
        if (face < 0) {
            return -1;
        }
        return face * 3;
    }

    @Override
    public int swingRight(int corner) {
        return this.previous(this.opposite(this.previous(corner)));
    }

    public int getNumNewVertices() {
        return this.getNumVertices() - this.numOriginalVertices;
    }

    public int getNumOriginalVertices() {
        return this.numOriginalVertices;
    }

    public int getNumDegeneratedFaces() {
        return this.numDegeneratedFaces;
    }

    public int getNumIsolatedVertices() {
        return this.numIsolatedVertices;
    }

    @Override
    public int getNumVertices() {
        return this.vertexCorners.getCount();
    }

    public int getNumCorners() {
        return this.cornerToVertexMap.length;
    }

    @Override
    public int getNumFaces() {
        return this.cornerToVertexMap.length / 3;
    }

    @Override
    public int swingLeft(int corner) {
        return this.next(this.opposite(this.next(corner)));
    }

    private void computeOppositeCorners(int[] numVertices) {
        this.oppositeCorners = new int[this.getNumCorners()];
        for (int i = 0; i < this.oppositeCorners.length; ++i) {
            this.oppositeCorners[i] = -1;
        }
        IntList numCornersOnVertices = new IntList();
        numCornersOnVertices.setCapacity(this.getNumCorners());
        for (int c = 0; c < this.getNumCorners(); ++c) {
            int v1 = this.vertex(c);
            if (v1 >= numCornersOnVertices.getCount()) {
                numCornersOnVertices.resize(v1 + 1, 0);
            }
            numCornersOnVertices.set(v1, numCornersOnVertices.get(v1) + 1);
        }
        VertexEdgePair[] vertexEdges = (VertexEdgePair[])MetaClasses.VertexEdgePair.newArray(this.getNumCorners());
        for (int i = 0; i < vertexEdges.length; ++i) {
            vertexEdges[i] = new VertexEdgePair(-1, -1);
        }
        int[] vertexOffset = new int[numCornersOnVertices.getCount()];
        int offset = 0;
        for (int i = 0; i < numCornersOnVertices.getCount(); ++i) {
            vertexOffset[i] = offset;
            offset += numCornersOnVertices.get(i);
        }
        block4: for (int c = 0; c < this.getNumCorners(); ++c) {
            int otherV;
            int v0;
            int sourceV = this.vertex(this.next(c));
            int sinkV = this.vertex(this.previous(c));
            int faceIndex = this.face(c);
            if (c == this.firstCorner(faceIndex) && ((v0 = this.vertex(c)) == sourceV || v0 == sinkV || sourceV == sinkV)) {
                ++this.numDegeneratedFaces;
                c += 2;
                continue;
            }
            int oppositeC = -1;
            int numCornersOnVert = numCornersOnVertices.get(sinkV);
            offset = vertexOffset[sinkV];
            int i = 0;
            while (i < numCornersOnVert && (otherV = vertexEdges[offset].sinkVert) >= 0) {
                if (otherV == sourceV) {
                    oppositeC = vertexEdges[offset].edgeCorner;
                    int j = i + 1;
                    while (j < numCornersOnVert) {
                        vertexEdges[offset] = Struct.byVal(vertexEdges[offset + 1]);
                        if (vertexEdges[offset].sinkVert < 0) break;
                        ++j;
                        ++offset;
                    }
                    vertexEdges[offset].sinkVert = -1;
                    break;
                }
                ++i;
                ++offset;
            }
            if (oppositeC < 0) {
                int numCornersOnSourceVert = numCornersOnVertices.get(sourceV);
                offset = vertexOffset[sourceV];
                int i2 = 0;
                while (i2 < numCornersOnSourceVert) {
                    if (vertexEdges[offset].sinkVert < 0) {
                        vertexEdges[offset].sinkVert = sinkV;
                        vertexEdges[offset].edgeCorner = c;
                        continue block4;
                    }
                    ++i2;
                    ++offset;
                }
                continue;
            }
            this.oppositeCorners[c] = oppositeC;
            this.oppositeCorners[oppositeC] = c;
        }
        numVertices[0] = numCornersOnVertices.getCount();
    }

    void computeVertexCorners(int numVertices) {
        this.numOriginalVertices = numVertices;
        this.vertexCorners.resize(numVertices, -1);
        boolean[] visitedVertices = new boolean[numVertices];
        int numVisitedVertices = numVertices;
        boolean[] visitedCorners = new boolean[this.getNumCorners()];
        for (int f = 0; f < this.getNumFaces(); ++f) {
            int firstFaceCorner = this.firstCorner(f);
            if (this.isDegenerated(f)) continue;
            for (int k = 0; k < 3; ++k) {
                int c = firstFaceCorner + k;
                if (visitedCorners[c]) continue;
                int v = this.cornerToVertexMap[c];
                boolean isNonManifoldVertex = false;
                if (visitedVertices[v]) {
                    this.vertexCorners.add(-1);
                    this.nonManifoldVertexParents.add(v);
                    if (numVisitedVertices >= visitedVertices.length) {
                        visitedVertices = visitedVertices == null ? new boolean[visitedVertices.length * 2] : Arrays.copyOf(visitedVertices, visitedVertices.length * 2);
                    }
                    visitedVertices[numVisitedVertices++] = false;
                    v = numVertices++;
                    isNonManifoldVertex = true;
                }
                visitedVertices[v] = true;
                int actC = c;
                while (actC != -1) {
                    visitedCorners[actC] = true;
                    this.vertexCorners.set(v, actC);
                    if (isNonManifoldVertex) {
                        this.cornerToVertexMap[actC] = v;
                    }
                    if ((actC = this.swingLeft(actC)) != c) continue;
                }
                if (actC != -1) continue;
                actC = this.swingRight(c);
                while (actC != -1) {
                    visitedCorners[actC] = true;
                    if (isNonManifoldVertex) {
                        int actF = this.face(actC);
                        this.cornerToVertexMap[actC] = v;
                    }
                    actC = this.swingRight(actC);
                }
            }
        }
        this.numIsolatedVertices = 0;
        for (int i = 0; i < numVisitedVertices; ++i) {
            if (visitedVertices[i]) continue;
            ++this.numIsolatedVertices;
        }
    }

    public boolean isDegenerated(int face) {
        if (face == -1) {
            return true;
        }
        int firstFaceCorner = this.firstCorner(face);
        int v0 = this.vertex(firstFaceCorner);
        int v1 = this.vertex(this.next(firstFaceCorner));
        int v2 = this.vertex(this.previous(firstFaceCorner));
        return v0 == v1 || v0 == v2 || v1 == v2;
    }

    @Override
    public int leftMostCorner(int v) {
        return this.vertexCorners.get(v);
    }

    @Override
    public boolean isOnBoundary(int vert) {
        int corner = this.leftMostCorner(vert);
        return this.swingLeft(corner) < 0;
    }

    @Override
    public int getLeftCorner(int cornerId) {
        if (cornerId < 0) {
            return -1;
        }
        return this.opposite(this.previous(cornerId));
    }

    @Override
    public int getRightCorner(int cornerId) {
        if (cornerId < 0) {
            return -1;
        }
        return this.opposite(this.next(cornerId));
    }

    public void setOppositeCorner(int cornerId, int oppCornerId) {
        this.oppositeCorners[cornerId] = oppCornerId;
    }

    public void mapCornerToVertex(int cornerId, int vertId) {
        if (vertId >= 0) {
            if (this.vertexCorners.getCount() <= vertId) {
                this.vertexCorners.resize(vertId + 1);
            }
            this.cornerToVertexMap[cornerId] = vertId;
        }
    }

    public void setLeftMostCorner(int vert, int corner) {
        if (vert != -1) {
            this.vertexCorners.set(vert, corner);
        }
    }

    public void makeVertexIsolated(int vert) {
        this.vertexCorners.set(vert, -1);
    }

    public boolean isVertexIsolated(int v) {
        return this.leftMostCorner(v) < 0;
    }

    public void updateVertexToCornerMap(int vert) {
        int firstC = this.vertexCorners.get(vert);
        if (firstC < 0) {
            return;
        }
        int actC = this.swingLeft(firstC);
        int c = firstC;
        while (actC >= 0 && actC != firstC) {
            c = actC;
            actC = this.swingLeft(actC);
        }
        if (actC != firstC) {
            this.vertexCorners.set(vert, c);
        }
    }

    public void reset(int numFaces, int numVertices) {
        if (numFaces < 0 || numVertices < 0) {
            throw new IllegalArgumentException();
        }
        if (numFaces > 0x2AAAAAAA) {
            throw new IllegalArgumentException();
        }
        this.cornerToVertexMap = new int[numFaces * 3];
        this.oppositeCorners = new int[numFaces * 3];
        for (int i = 0; i < this.cornerToVertexMap.length; ++i) {
            this.cornerToVertexMap[i] = -1;
            this.oppositeCorners[i] = -1;
        }
        this.vertexCorners.setCapacity(numVertices);
        this.valenceCache.clearValenceCache();
        this.valenceCache.clearValenceCacheInaccurate();
    }

    public int confidentVertex(int corner) {
        return this.cornerToVertexMap[corner];
    }

    public int valence(int v) {
        int startCorner;
        if (v == -1) {
            return -1;
        }
        int valence = 0;
        int corner = startCorner = this.leftMostCorner(v);
        boolean leftTraversal = true;
        while (corner >= 0) {
            ++valence;
            if (leftTraversal) {
                if ((corner = this.swingLeft(corner)) < 0) {
                    corner = startCorner;
                    leftTraversal = false;
                    continue;
                }
                if (corner != startCorner) continue;
                corner = -1;
                continue;
            }
            corner = this.swingRight(corner);
        }
        return valence;
    }

    public int addNewVertex() {
        this.vertexCorners.add(-1);
        return this.vertexCorners.getCount() - 1;
    }

    private void $initFields$() {
        try {
            this.vertexCorners = new IntList();
            this.nonManifoldVertexParents = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class VertexEdgePair
    implements Struct<VertexEdgePair>,
    Serializable {
        public int sinkVert;
        public int edgeCorner;
        static final long serialVersionUID = -478043180L;

        public VertexEdgePair(int sinkVert, int edgeCorner) {
            this.sinkVert = sinkVert;
            this.edgeCorner = edgeCorner;
        }

        public VertexEdgePair() {
        }

        private VertexEdgePair(VertexEdgePair other) {
            this.sinkVert = other.sinkVert;
            this.edgeCorner = other.edgeCorner;
        }

        @Override
        public VertexEdgePair clone() {
            return new VertexEdgePair(this);
        }

        @Override
        public void copyFrom(VertexEdgePair src) {
            if (src == null) {
                return;
            }
            this.sinkVert = src.sinkVert;
            this.edgeCorner = src.edgeCorner;
        }

        public int hashCode() {
            HashBuilder builder = new HashBuilder();
            builder.hash(this.sinkVert);
            builder.hash(this.edgeCorner);
            return builder.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VertexEdgePair)) {
                return false;
            }
            VertexEdgePair rhs = (VertexEdgePair)obj;
            if (this.sinkVert != rhs.sinkVert) {
                return false;
            }
            return this.edgeCorner == rhs.edgeCorner;
        }
    }
}

