/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BitUtils;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.ListUtils;
import dev.fileformat.drako.Out;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

@Internal
class Convert {
    private static final char[] map1;
    private static final byte[] map2;
    private static SimpleDateFormat[] iso8601Formats;

    Convert() {
    }

    public static byte[] fromBase64(String str) {
        char[] chars = str.toCharArray();
        return Convert.decode(chars, 0, chars.length);
    }

    private static byte[] decode(char[] in, int iOff, int iLen) {
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && in[iOff + iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i3;
            char i0 = in[ip++];
            char i1 = in[ip++];
            int i2 = ip < iEnd ? in[ip++] : 65;
            int n = i3 = ip < iEnd ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = map2[i0];
            byte b1 = map2[i1];
            byte b2 = map2[i2];
            byte b3 = map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    public static UUID toUUID(byte[] b) {
        long most = (long)(b[3] & 0xFF) << 56 | (long)(b[2] & 0xFF) << 48 | (long)(b[1] & 0xFF) << 40 | (long)(b[0] & 0xFF) << 32 | (long)(b[5] & 0xFF) << 24 | (long)(b[4] & 0xFF) << 16 | (long)(b[7] & 0xFF) << 8 | (long)(b[6] & 0xFF) << 0;
        long least = (long)(b[8] & 0xFF) << 56 | (long)(b[9] & 0xFF) << 48 | (long)(b[10] & 0xFF) << 40 | (long)(b[11] & 0xFF) << 32 | (long)(b[12] & 0xFF) << 24 | (long)(b[13] & 0xFF) << 16 | (long)(b[14] & 0xFF) << 8 | (long)(b[15] & 0xFF);
        return new UUID(most, least);
    }

    public static String toBase64(byte[] bytes, int start, int len) {
        char[] chars = Convert.encode(bytes, start, len);
        return new String(chars);
    }

    public static String toBase64(byte[] bytes) {
        return Convert.toBase64(bytes, 0, bytes.length);
    }

    private static char[] encode(byte[] in, int iOff, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int i2 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    public static String formatISO8601(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static String formatISO8601(Calendar date) {
        return Convert.formatISO8601(date.getTime());
    }

    public static Calendar parseISO8601(String str) {
        long t = Convert.parseISO8601AsMilliseconds(str);
        if (t == -1L) {
            return null;
        }
        Calendar ret = Calendar.getInstance();
        ret.setTimeInMillis(t);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long parseISO8601AsMilliseconds(String str) {
        for (int i = 0; i < iso8601Formats.length; ++i) {
            SimpleDateFormat simpleDateFormat = iso8601Formats[i];
            synchronized (simpleDateFormat) {
                try {
                    Date date = iso8601Formats[i].parse(str);
                    return date.getTime();
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
        }
        return -1L;
    }

    public static void blockCopy(Object src, int srcOffset, Object dst, int dstOffset, int count) {
        if (dst == null || src == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (dst.getClass() != byte[].class) {
            throw new IllegalArgumentException("Dst only supports byte[]");
        }
        byte[] dest = (byte[])dst;
        if (src instanceof byte[]) {
            Convert.blockCopy((byte[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof boolean[]) {
            Convert.blockCopy((boolean[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof Boolean[]) {
            Convert.blockCopy((Boolean[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof int[]) {
            Convert.blockCopy((int[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof Integer[]) {
            Convert.blockCopy((Integer[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof short[]) {
            Convert.blockCopy((short[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof long[]) {
            Convert.blockCopy((long[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof float[]) {
            Convert.blockCopy((float[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof double[]) {
            Convert.blockCopy((double[])src, srcOffset, dest, dstOffset, count);
        } else if (src instanceof Double[]) {
            Convert.blockCopy((Double[])src, srcOffset, dest, dstOffset, count);
        } else {
            throw new IllegalArgumentException("Unsupported src type");
        }
    }

    private static void blockCopy(byte[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        System.arraycopy(src, srcOffset, dst, dstOffset, count);
    }

    private static void blockCopy(Boolean[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        boolean size = true;
        int psrc = srcOffset;
        int pdst = dstOffset;
        int i = srcOffset;
        for (int rest = count; rest > 1; --rest) {
            dst[pdst] = (byte)(src[psrc] != false ? 1 : 0);
            ++pdst;
            ++psrc;
        }
    }

    private static void blockCopy(boolean[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        boolean size = true;
        int psrc = srcOffset;
        int pdst = dstOffset;
        int i = srcOffset;
        for (int rest = count; rest > 1; --rest) {
            dst[pdst] = (byte)(src[psrc] ? 1 : 0);
            ++pdst;
            ++psrc;
        }
    }

    private static void blockCopy(Integer[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        int right;
        int left = srcOffset & 3;
        int intOffset = srcOffset >> 2;
        int intSize = count >> 2;
        if (left != 0) {
            int head = src[0];
            switch (left) {
                case 1: {
                    dst[dstOffset] = (byte)(head >>> 24);
                    break;
                }
                case 2: {
                    dst[dstOffset] = (byte)(head >>> 16);
                    dst[dstOffset + 1] = (byte)(head >>> 24);
                    break;
                }
                case 3: {
                    dst[dstOffset] = (byte)(head >>> 8);
                    dst[dstOffset + 1] = (byte)(head >>> 16);
                    dst[dstOffset + 2] = (byte)(head >>> 24);
                }
            }
            dstOffset += left;
            count -= left;
            ++intOffset;
            --intSize;
        }
        if (intSize != 0) {
            BitUtils.toBytes(dst, dstOffset, src, intOffset, intSize);
        }
        if ((right = count & 3) > 0) {
            int tail = src[intOffset + intSize];
            int ptail = dstOffset + (intSize << 2);
            switch (right) {
                case 1: {
                    dst[ptail] = (byte)tail;
                    break;
                }
                case 2: {
                    dst[ptail] = (byte)tail;
                    dst[ptail + 1] = (byte)(tail >>> 8);
                    break;
                }
                case 3: {
                    dst[ptail] = (byte)tail;
                    dst[ptail + 1] = (byte)(tail >>> 8);
                    dst[ptail + 2] = (byte)(tail >>> 16);
                }
            }
        }
    }

    private static void blockCopy(int[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        int right;
        int left = srcOffset & 3;
        int intOffset = srcOffset >> 2;
        int intSize = count >> 2;
        if (left != 0) {
            int head = src[0];
            switch (left) {
                case 1: {
                    dst[dstOffset] = (byte)(head >>> 24);
                    break;
                }
                case 2: {
                    dst[dstOffset] = (byte)(head >>> 16);
                    dst[dstOffset + 1] = (byte)(head >>> 24);
                    break;
                }
                case 3: {
                    dst[dstOffset] = (byte)(head >>> 8);
                    dst[dstOffset + 1] = (byte)(head >>> 16);
                    dst[dstOffset + 2] = (byte)(head >>> 24);
                }
            }
            dstOffset += left;
            count -= left;
            ++intOffset;
            --intSize;
        }
        if (intSize != 0) {
            BitUtils.toBytes(dst, dstOffset, src, intOffset, intSize);
        }
        if ((right = count & 3) > 0) {
            int tail = src[intOffset + intSize];
            int ptail = dstOffset + (intSize << 2);
            switch (right) {
                case 1: {
                    dst[ptail] = (byte)tail;
                    break;
                }
                case 2: {
                    dst[ptail] = (byte)tail;
                    dst[ptail + 1] = (byte)(tail >>> 8);
                    break;
                }
                case 3: {
                    dst[ptail] = (byte)tail;
                    dst[ptail + 1] = (byte)(tail >>> 8);
                    dst[ptail + 2] = (byte)(tail >>> 16);
                }
            }
        }
    }

    private static void blockCopy(short[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        if (srcOffset != 0 || dstOffset != 0 || (count & 1) != 0) {
            throw new IllegalArgumentException("Unsupported call to blockCopy");
        }
        BitUtils.toBytes(dst, 0, src, srcOffset / 2, count / 2);
    }

    private static void blockCopy(long[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        if (srcOffset != 0 || dstOffset != 0 || (count & 7) != 0) {
            throw new IllegalArgumentException("Unsupported call to blockCopy");
        }
        BitUtils.toBytes(dst, 0, src, srcOffset / 8, count / 8);
    }

    private static void blockCopy(float[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        if (srcOffset != 0 || dstOffset != 0 || (count & 3) != 0) {
            throw new IllegalArgumentException("Unsupported call to blockCopy");
        }
        BitUtils.toBytes(dst, 0, src, srcOffset / 4, count / 4);
    }

    private static void blockCopy(double[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        if (srcOffset != 0 || dstOffset != 0 || (count & 7) != 0) {
            throw new IllegalArgumentException("Unsupported call to blockCopy");
        }
        BitUtils.toBytes(dst, 0, src, srcOffset / 8, count / 8);
    }

    private static void blockCopy(Double[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        if (srcOffset != 0 || dstOffset != 0 || (count & 7) != 0) {
            throw new IllegalArgumentException("Unsupported call to blockCopy");
        }
        BitUtils.toBytes(dst, 0, src, srcOffset / 8, count / 8);
    }

    public static boolean tryParseLong(String str, @Out long[] ret) {
        try {
            ret[0] = Long.parseLong(Convert.trim(str));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean tryParseDouble(String str, @Out double[] ret) {
        try {
            ret[0] = Double.parseDouble(Convert.trim(str));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static String trim(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (Character.isWhitespace(s.charAt(0)) || Character.isWhitespace(s.charAt(s.length() - 1))) {
            return s.trim();
        }
        return s;
    }

    public static int tryParseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(Convert.trim(str));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean tryParseInt(String str, @Out int[] ret) {
        try {
            ret[0] = Integer.parseInt(Convert.trim(str));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Object changeType(Object value, Class<?> clazz) {
        throw new RuntimeException("Not implemented");
    }

    public static Class<?> getUnderlyingType(Object value) {
        throw new RuntimeException("Not implemented");
    }

    public static boolean parseDateTime(String input, String pattern, @Out Calendar[] ret) {
        try {
            String newPattern = Convert.normalizeDateFormat(pattern);
            SimpleDateFormat sdf = new SimpleDateFormat(newPattern);
            Date d = sdf.parse(Convert.trim(input));
            ret[0] = Calendar.getInstance();
            ret[0].setTimeInMillis(d.getTime());
            return true;
        }
        catch (Exception e) {
            ret[0] = null;
            return false;
        }
    }

    public static String normalizeDateFormat(String netFormat) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < netFormat.length(); ++i) {
            char ch = netFormat.charAt(i);
            if (ch == 'f') {
                sb.append('S');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static <T> ArrayList<T> asList(Iterable<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("collection cannot be null");
        }
        if (collection instanceof ArrayList) {
            return (ArrayList)collection;
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (T t : collection) {
            ret.add(t);
        }
        return ret;
    }

    public static List<?> asList(Object array) {
        if (array == null) {
            return null;
        }
        if (array instanceof Iterable) {
            return Convert.asList((Iterable)array);
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Cannot convert non-array into list");
        }
        if (array instanceof int[]) {
            return Convert.asList((int[])array);
        }
        if (array instanceof long[]) {
            return Convert.asList((long[])array);
        }
        if (array instanceof float[]) {
            return Convert.asList((float[])array);
        }
        if (array instanceof double[]) {
            return Convert.asList((double[])array);
        }
        if (array instanceof boolean[]) {
            return Convert.asList((boolean[])array);
        }
        if (array instanceof byte[]) {
            return Convert.asList((byte[])array);
        }
        if (array instanceof short[]) {
            return Convert.asList((short[])array);
        }
        if (array instanceof char[]) {
            return Convert.asList((char[])array);
        }
        return Arrays.asList((Object[])array);
    }

    public static List<Character> asList(char[] array) {
        return new ListUtils.NativeArrayList<Character>(array);
    }

    public static List<Boolean> asList(boolean[] array) {
        return new ListUtils.NativeArrayList<Boolean>(array);
    }

    public static List<Byte> asList(byte[] array) {
        return new ListUtils.NativeArrayList<Byte>(array);
    }

    public static List<Short> asList(short[] array) {
        return new ListUtils.NativeArrayList<Short>(array);
    }

    public static List<Integer> asList(int[] array) {
        return new ListUtils.IntList(array);
    }

    public static List<Long> asList(long[] array) {
        return new ListUtils.NativeArrayList<Long>(array);
    }

    public static List<Float> asList(float[] array) {
        return new ListUtils.NativeArrayList<Float>(array);
    }

    public static List<Double> asList(double[] array) {
        return new ListUtils.NativeArrayList<Double>(array);
    }

    public static Object unbox(Object[] array, Class<?> elementType) {
        Object ret;
        block27: {
            if (array == null) {
                throw new IllegalArgumentException("array cannot be null");
            }
            if (elementType == null) {
                throw new IllegalArgumentException("elementType cannot be null");
            }
            ret = Array.newInstance(elementType, array.length);
            if (array.length <= 0) break block27;
            if (elementType == Integer.TYPE) {
                int[] ints = (int[])ret;
                for (int i = 0; i < array.length; ++i) {
                    ints[i] = ((Number)array[i]).intValue();
                }
            } else if (elementType == Short.TYPE) {
                short[] vals = (short[])ret;
                for (int i = 0; i < array.length; ++i) {
                    vals[i] = ((Number)array[i]).shortValue();
                }
            } else if (elementType == Byte.TYPE) {
                byte[] vals = (byte[])ret;
                for (int i = 0; i < array.length; ++i) {
                    vals[i] = ((Number)array[i]).byteValue();
                }
            } else if (elementType == Long.TYPE) {
                long[] vals = (long[])ret;
                for (int i = 0; i < array.length; ++i) {
                    vals[i] = ((Number)array[i]).longValue();
                }
            } else if (elementType == Double.TYPE) {
                double[] vals = (double[])ret;
                for (int i = 0; i < array.length; ++i) {
                    vals[i] = ((Number)array[i]).doubleValue();
                }
            } else if (elementType == Float.TYPE) {
                float[] vals = (float[])ret;
                for (int i = 0; i < array.length; ++i) {
                    vals[i] = ((Number)array[i]).floatValue();
                }
            } else if (elementType == Boolean.TYPE) {
                boolean[] vals = (boolean[])ret;
                for (int i = 0; i < array.length; ++i) {
                    vals[i] = (Boolean)array[i];
                }
            } else if (elementType == Character.TYPE) {
                char[] vals = (char[])ret;
                for (int i = 0; i < array.length; ++i) {
                    vals[i] = ((Character)array[i]).charValue();
                }
            } else {
                for (int i = 0; i < array.length; ++i) {
                    Array.set(ret, i, array[i]);
                }
            }
        }
        return ret;
    }

    public static char[] unbox(Character[] array) {
        if (array == null) {
            return null;
        }
        char[] ret = new char[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i].charValue();
        }
        return ret;
    }

    public static byte[] unbox(Byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] ret = new byte[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static boolean[] unbox(Boolean[] array) {
        if (array == null) {
            return null;
        }
        boolean[] ret = new boolean[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static short[] unbox(Short[] array) {
        if (array == null) {
            return null;
        }
        short[] ret = new short[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static int[] unbox(Integer[] array) {
        if (array == null) {
            return null;
        }
        int[] ret = new int[array.length];
        if (array.getClass() == Object[].class) {
            Object[] objects = array;
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) continue;
                ret[i] = (Integer)objects[i];
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                if (array[i] == null) continue;
                ret[i] = array[i];
            }
        }
        return ret;
    }

    public static long[] unbox(Long[] array) {
        if (array == null) {
            return null;
        }
        long[] ret = new long[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static float[] unbox(Float[] array) {
        if (array == null) {
            return null;
        }
        float[] ret = new float[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i].floatValue();
        }
        return ret;
    }

    public static double[] unbox(Double[] array) {
        if (array == null) {
            return null;
        }
        double[] ret = new double[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Character[] box(char[] array) {
        if (array == null) {
            return null;
        }
        Character[] ret = new Character[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Character.valueOf(array[i]);
        }
        return ret;
    }

    public static Byte[] box(byte[] array) {
        if (array == null) {
            return null;
        }
        Byte[] ret = new Byte[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Boolean[] box(boolean[] array) {
        if (array == null) {
            return null;
        }
        Boolean[] ret = new Boolean[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Short[] box(short[] array) {
        if (array == null) {
            return null;
        }
        Short[] ret = new Short[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Integer[] box(int[] array) {
        if (array == null) {
            return null;
        }
        Integer[] ret = new Integer[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Long[] box(long[] array) {
        if (array == null) {
            return null;
        }
        Long[] ret = new Long[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Float[] box(float[] array) {
        if (array == null) {
            return null;
        }
        Float[] ret = new Float[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Float.valueOf(array[i]);
        }
        return ret;
    }

    public static Double[] box(double[] array) {
        if (array == null) {
            return null;
        }
        Double[] ret = new Double[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    static {
        int c;
        map1 = new char[64];
        map2 = new byte[128];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Convert.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Convert.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Convert.map1[i++] = c;
        }
        Convert.map1[i++] = 43;
        Convert.map1[i++] = 47;
        for (i = 0; i < map2.length; ++i) {
            Convert.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Convert.map2[Convert.map1[i]] = (byte)i;
        }
        iso8601Formats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'")};
    }
}

