/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BytePointer;

class BitEncoder {
    private BytePointer buffer = new BytePointer();
    private int bitOffset;

    public BitEncoder(BytePointer buffer) {
        this.buffer.copyFrom(buffer);
    }

    public void putBits(int data, int nbits) {
        for (int bit = 0; bit < nbits; ++bit) {
            this.putBit((byte)(data >>> bit & 1));
        }
    }

    public int getBits() {
        return this.bitOffset;
    }

    private void putBit(byte value) {
        int byteSize = 8;
        int off = this.bitOffset++;
        int byteOffset = off / byteSize;
        int bitShift = off % byteSize;
        this.buffer.set(byteOffset, (byte)(0xFF & this.buffer.get(byteOffset) & ~(1 << bitShift) | (0xFF & value) << bitShift));
        byte t = this.buffer.get(byteOffset);
        t = (byte)(0xFF & t & ~(1 << bitShift));
        t = (byte)(0xFF & t | (0xFF & value) << bitShift);
        this.buffer.set(byteOffset, t);
    }
}

