/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BytePointer;

final class BitDecoder {
    private BytePointer data = new BytePointer();
    private int dataEnd;
    private int bitOffset;

    BitDecoder() {
    }

    public void copyFrom(BitDecoder bitDecoder) {
        this.data.copyFrom(bitDecoder.data);
        this.dataEnd = bitDecoder.dataEnd;
        this.bitOffset = bitDecoder.bitOffset;
    }

    public void load(BytePointer data, int count) {
        this.data.copyFrom(data);
        this.dataEnd = count;
        this.bitOffset = 0;
    }

    public int getBitsDecoded() {
        return this.bitOffset;
    }

    public void consume(int k) {
        this.bitOffset += k;
    }

    public int getBit() {
        int off = this.bitOffset++;
        int byteOffset = off >> 3;
        int bitShift = off & 7;
        if (byteOffset < this.dataEnd) {
            int bit = (0xFF & this.data.get(byteOffset)) >>> bitShift & 1;
            return bit;
        }
        return 0;
    }

    public int peekBit(int offset) {
        int off = this.bitOffset + offset;
        int byteOffset = off >> 3;
        int bitShift = off & 7;
        if (byteOffset < this.dataEnd) {
            int bit = (0xFF & this.data.get(byteOffset)) >>> bitShift & 1;
            return bit;
        }
        return 0;
    }

    public int getBits(int nbits) {
        int ret = 0;
        for (int bit = 0; bit < nbits; ++bit) {
            ret |= this.getBit() << bit;
        }
        return ret;
    }
}

