/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoPointCloud;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.Encoding;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudEncoder;

abstract class AttributesEncoder {
    private int[] pointAttributeIds;
    private int[] pointAttributeToLocalIdMap;
    PointCloudEncoder pointCloudEncoder;
    DracoPointCloud pointCloud;

    public AttributesEncoder() {
    }

    public AttributesEncoder(int pointAttribId) {
        this.pointAttributeIds = new int[]{pointAttribId};
        this.pointAttributeToLocalIdMap = new int[]{0};
    }

    public void initialize(PointCloudEncoder encoder, DracoPointCloud pc) throws DrakoException {
        this.pointCloudEncoder = encoder;
        this.pointCloud = pc;
    }

    public void encodeAttributesEncoderData(EncoderBuffer outBuffer) {
        Encoding.encodeVarint2(this.getNumAttributes(), outBuffer);
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            int attId = this.pointAttributeIds[i];
            PointAttribute pa = this.pointCloud.attribute(attId);
            outBuffer.encode((byte)pa.getAttributeType());
            outBuffer.encode((byte)pa.getDataType());
            outBuffer.encode((byte)pa.getComponentsCount());
            outBuffer.encode((byte)(pa.getNormalized() ? 1 : 0));
            Encoding.encodeVarint(0xFFFF & pa.getUniqueId(), outBuffer);
        }
    }

    public abstract byte getUniqueId();

    public void encodeAttributes(EncoderBuffer out_buffer) throws DrakoException {
        this.transformAttributesToPortableFormat();
        this.encodePortableAttributes(out_buffer);
        this.encodeDataNeededByPortableTransforms(out_buffer);
    }

    protected void transformAttributesToPortableFormat() throws DrakoException {
    }

    protected abstract void encodePortableAttributes(EncoderBuffer var1) throws DrakoException;

    protected void encodeDataNeededByPortableTransforms(EncoderBuffer out_buffer) throws DrakoException {
    }

    public int numParentAttributes(int pointAttributeId) {
        return 0;
    }

    public int getParentAttributeId(int pointAttributeId, int parentI) {
        return -1;
    }

    public boolean markParentAttribute(int pointAttributeId) {
        return false;
    }

    public void addAttributeId(int id) {
        int[] ids = this.pointAttributeIds;
        if (ids == null || ids.length == 0) {
            ids = new int[]{id};
        } else {
            ids = new int[this.pointAttributeIds.length + 1];
            System.arraycopy(this.pointAttributeIds, 0, ids, 0, this.pointAttributeIds.length);
            ids[ids.length - 1] = id;
        }
        this.setAttributeIds(ids);
    }

    public void setAttributeIds(int[] pointAttributeIds) {
        this.pointAttributeIds = new int[pointAttributeIds.length];
        this.pointAttributeToLocalIdMap = new int[pointAttributeIds.length];
        for (int i = 0; i < pointAttributeIds.length; ++i) {
            this.pointAttributeIds[i] = pointAttributeIds[i];
            this.pointAttributeToLocalIdMap[i] = this.pointAttributeIds.length - 1;
        }
    }

    public int getAttributeId(int i) {
        return this.pointAttributeIds[i];
    }

    public int getNumAttributes() {
        return this.pointAttributeIds == null ? 0 : this.pointAttributeIds.length;
    }

    public PointCloudEncoder getEncoder() {
        return this.pointCloudEncoder;
    }

    protected int getLocalIdForPointAttribute(int pointAttributeId) {
        if (this.pointAttributeToLocalIdMap == null) {
            return -1;
        }
        int idMapSize = this.pointAttributeToLocalIdMap.length;
        if (pointAttributeId >= idMapSize) {
            return -1;
        }
        return this.pointAttributeToLocalIdMap[pointAttributeId];
    }

    public PointAttribute getPortableAttribute(int parentAttId) {
        return null;
    }
}

