/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Pure;
import java.util.Arrays;
import java.util.Comparator;

@Internal
final class Algorithms {
    Algorithms() {
    }

    public static <T> int indexOf(T[] array, T find) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != find) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(char[] array, char find) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != find) continue;
            return i;
        }
        return -1;
    }

    public static int binarySearch(@Pure int[] array, int val, Comparator<Integer> comparator) {
        Algorithms.rangeCheck(array, array.length, 0, 0);
        return Algorithms.binarySearch(array, 0, array.length, val, comparator);
    }

    public static int binarySearch(int[] array, long val) {
        int low = 0;
        int high = array.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = array[mid];
            if (midVal < val) {
                low = mid + 1;
                continue;
            }
            if (midVal > val) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ~low;
    }

    public static int binarySearch(long[] array, long val) {
        int low = 0;
        int high = array.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = array[mid];
            if (midVal < val) {
                low = mid + 1;
                continue;
            }
            if (midVal > val) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ~low;
    }

    public static int binarySearch(int[] array, int start, int len, int val, Comparator<Integer> comparator) {
        Algorithms.rangeCheck(array, array.length, start, len);
        int low = start;
        int high = start + len - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = array[mid];
            if (comparator.compare(midVal, val) < 0) {
                low = mid + 1;
                continue;
            }
            if (comparator.compare(midVal, val) > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ~low;
    }

    private static void rangeCheck(Object array, int arrayLength, int start, int len) {
        if (array == null) {
            throw new IllegalArgumentException("array cannot be null");
        }
        int end = start + len;
        if (start < 0 || start >= arrayLength || end < 0 || end > arrayLength) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static <T> void sort(T[] array, Comparator<T> comparator) {
        Arrays.sort(array, 0, array.length, comparator);
    }

    public static <T> void sort(T[] array, int start, int len, Comparator<T> comparator) {
        Arrays.sort(array, start, start + len, comparator);
    }

    public static void sort(int[] array, Comparator<Integer> comparator) {
        if (array.length > 0) {
            Algorithms.rangeCheck(array, array.length, 0, array.length);
            Algorithms.sort(array, 0, array.length, comparator);
        }
    }

    public static void sort(int[] array, int start, int len, Comparator<Integer> comparator) {
        if (array.length > 0) {
            Algorithms.rangeCheck(array, array.length, start, len);
            Algorithms.quickSort(array, start, start + len - 1, comparator);
        }
    }

    public static void sort(int[] keys, int[] values) {
        int i;
        Pair[] pairs = new Pair[keys.length];
        for (i = 0; i < keys.length; ++i) {
            pairs[i] = new Pair(keys[i], values[i]);
        }
        Arrays.sort(pairs, new Comparator<Pair>(){

            @Override
            public int compare(Pair o1, Pair o2) {
                return Long.compare(o1.key, o2.key);
            }
        });
        for (i = 0; i < pairs.length; ++i) {
            Pair p = pairs[i];
            keys[i] = (int)p.key;
            values[i] = p.value;
        }
    }

    public static void sort(long[] keys, int[] values) {
        int i;
        Pair[] pairs = new Pair[keys.length];
        for (i = 0; i < keys.length; ++i) {
            pairs[i] = new Pair(keys[i], values[i]);
        }
        Arrays.sort(pairs, new Comparator<Pair>(){

            @Override
            public int compare(Pair o1, Pair o2) {
                return Long.compare(o1.key, o2.key);
            }
        });
        for (i = 0; i < pairs.length; ++i) {
            Pair p = pairs[i];
            keys[i] = p.key;
            values[i] = p.value;
        }
    }

    private static void quickSort(int[] array, int lowerIndex, int higherIndex, Comparator<Integer> comparator) {
        int i = lowerIndex;
        int j = higherIndex;
        Integer pivot = array[lowerIndex + (higherIndex - lowerIndex) / 2];
        while (i <= j) {
            while (comparator.compare(array[i], pivot) < 0) {
                ++i;
            }
            while (comparator.compare(array[j], pivot) > 0) {
                --j;
            }
            if (i > j) continue;
            int t = array[i];
            array[i] = array[j];
            array[j] = t;
            ++i;
            --j;
        }
        if (lowerIndex < j) {
            Algorithms.quickSort(array, lowerIndex, j, comparator);
        }
        if (i < higherIndex) {
            Algorithms.quickSort(array, i, higherIndex, comparator);
        }
    }

    public static void reverse(Object[] array, int start, int len) {
        Algorithms.rangeCheck(array, array.length, start, len);
        int end = start + len / 2;
        int i = start;
        int j = start + len - 1;
        while (i < end) {
            Object t = array[i];
            array[i] = array[j];
            array[j] = t;
            ++i;
            --j;
        }
    }

    public static void reverse(int[] array, int start, int len) {
        Algorithms.rangeCheck(array, array.length, start, len);
        int end = start + len / 2;
        int i = start;
        int j = start + len - 1;
        while (i < end) {
            int t = array[i];
            array[i] = array[j];
            array[j] = t;
            ++i;
            --j;
        }
    }

    private static class Pair {
        public long key;
        public int value;

        public Pair(long key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

