/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.volley.ui.RecyclingBitmapDrawable;

public class RecyclingImageView
extends ImageView {
    public RecyclingImageView(Context context) {
        super(context);
    }

    public RecyclingImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RecyclingImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onDetachedFromWindow() {
        this.setImageDrawable(null);
        super.onDetachedFromWindow();
    }

    public void setImageDrawable(Drawable drawable) {
        Drawable previousDrawable = this.getDrawable();
        super.setImageDrawable(drawable);
        RecyclingImageView.notifyDrawable(drawable, true);
        RecyclingImageView.notifyDrawable(previousDrawable, false);
    }

    private static void notifyDrawable(Drawable drawable, boolean isDisplayed) {
        if (drawable instanceof RecyclingBitmapDrawable) {
            ((RecyclingBitmapDrawable)drawable).setIsDisplayed(isDisplayed);
        } else if (drawable instanceof LayerDrawable) {
            LayerDrawable layerDrawable = (LayerDrawable)drawable;
            int z = layerDrawable.getNumberOfLayers();
            for (int i = 0; i < z; ++i) {
                RecyclingImageView.notifyDrawable(layerDrawable.getDrawable(i), isDisplayed);
            }
        }
    }
}

