/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.android.volley.Response;
import com.android.volley.cache.plus.ImageLoader;
import com.android.volley.cache.plus.SimpleImageLoader;
import com.android.volley.error.VolleyError;
import com.android.volley.misc.Utils;
import com.android.volley.ui.RecyclingImageView;

public class NetworkImageViewPlus
extends RecyclingImageView {
    private final int[] attrsArray = new int[]{0x1010119};
    private static final ColorDrawable transparentDrawable = new ColorDrawable(17170445);
    private static final int HALF_FADE_IN_TIME = 100;
    protected String mUrl;
    int mDefaultImageId;
    int mErrorImageId;
    protected ImageLoader mImageLoader;
    protected ImageLoader.ImageContainer mImageContainer;
    private boolean mFadeInImage = false;
    private int mMaxImageHeight = 0;
    private int mMaxImageWidth = 0;
    private Response.Listener<BitmapDrawable> mListener;

    public NetworkImageViewPlus(Context context) {
        this(context, null);
    }

    public NetworkImageViewPlus(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NetworkImageViewPlus(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, this.attrsArray);
        this.setDefaultImageResId(a.getResourceId(0, 0));
        a.recycle();
    }

    public void setImageUrl(String url, ImageLoader imageLoader) {
        this.mUrl = url;
        this.mImageLoader = imageLoader;
        this.loadImageIfNecessary(false);
    }

    public void setResetImageUrl(String url, ImageLoader imageLoader) {
        this.mImageContainer = null;
        this.mUrl = url;
        this.mImageLoader = imageLoader;
        this.loadImageIfNecessary(false);
    }

    public void setDefaultImageResId(int defaultImage) {
        this.mDefaultImageId = defaultImage;
    }

    public void setErrorImageResId(int errorImage) {
        this.mErrorImageId = errorImage;
    }

    public void setMaxImageSize(int maxImageWidth, int maxImageHeight) {
        this.mMaxImageWidth = maxImageWidth;
        this.mMaxImageHeight = maxImageHeight;
    }

    public void setMaxImageSize(int maxImageSize) {
        this.setMaxImageSize(maxImageSize, maxImageSize);
    }

    public void setFadeInImage(boolean fadeInImage) {
        this.mFadeInImage = fadeInImage;
    }

    public void setImageListener(Response.Listener<BitmapDrawable> listener) {
        this.mListener = listener;
    }

    void loadImageIfNecessary(final boolean isInLayoutPass) {
        ImageLoader.ImageContainer newContainer;
        boolean isFullyWrapContent;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean wrapWidth = false;
        boolean wrapHeight = false;
        if (this.getLayoutParams() != null) {
            wrapWidth = this.getLayoutParams().width == -2;
            wrapHeight = this.getLayoutParams().height == -2;
        }
        boolean bl = isFullyWrapContent = wrapWidth && wrapHeight;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        int maxWidth = 0;
        int maxHeight = 0;
        if (this.mImageLoader instanceof SimpleImageLoader) {
            SimpleImageLoader loader = (SimpleImageLoader)this.mImageLoader;
            maxWidth = this.mMaxImageWidth == 0 ? loader.getMaxImageWidth() : this.mMaxImageWidth;
            maxHeight = this.mMaxImageHeight == 0 ? loader.getMaxImageHeight() : this.mMaxImageHeight;
        } else {
            maxWidth = wrapWidth ? 0 : width;
            maxHeight = wrapHeight ? 0 : height;
        }
        this.mImageContainer = newContainer = this.mImageLoader.get(this.mUrl, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (NetworkImageViewPlus.this.mErrorImageId != 0) {
                    NetworkImageViewPlus.this.setImageResource(NetworkImageViewPlus.this.mErrorImageId);
                }
            }

            @Override
            public void onResponse(final ImageLoader.ImageContainer response, boolean isImmediate) {
                if (isImmediate && isInLayoutPass) {
                    NetworkImageViewPlus.this.post(new Runnable(){

                        @Override
                        public void run() {
                            this.onResponse(response, false);
                        }
                    });
                    return;
                }
                if (response.getBitmap() != null) {
                    NetworkImageViewPlus.this.setAnimateImageBitmap(response.getBitmap(), NetworkImageViewPlus.this.mFadeInImage);
                    if (null != NetworkImageViewPlus.this.mListener) {
                        NetworkImageViewPlus.this.mListener.onResponse(response.getBitmap());
                    }
                } else if (NetworkImageViewPlus.this.mDefaultImageId != 0) {
                    NetworkImageViewPlus.this.setImageResource(NetworkImageViewPlus.this.mDefaultImageId);
                }
            }
        }, maxWidth, maxHeight);
    }

    @SuppressLint(value={"NewApi"})
    private void setAnimateImageBitmap(final BitmapDrawable bitmap, boolean fadeIn) {
        if (fadeIn && Utils.hasHoneycombMR1()) {
            this.animate().scaleY(0.95f).scaleX(0.95f).alpha(0.0f).setDuration(this.getDrawable() == null ? 0L : 100L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    NetworkImageViewPlus.this.setImageDrawable((Drawable)bitmap);
                    NetworkImageViewPlus.this.animate().alpha(1.0f).scaleY(1.0f).scaleX(1.0f).setDuration(100L).setListener(null);
                }
            });
        } else if (fadeIn) {
            Object initialDrawable = this.getDrawable() != null ? this.getDrawable() : transparentDrawable;
            TransitionDrawable td = new TransitionDrawable(new Drawable[]{initialDrawable, bitmap});
            this.setImageDrawable((Drawable)td);
            td.startTransition(200);
        } else {
            this.setImageDrawable((Drawable)bitmap);
        }
    }

    protected void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            this.setImageResource(this.mDefaultImageId);
        } else {
            this.setImageDrawable(null);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mImageLoader != null) {
            this.loadImageIfNecessary(true);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mImageContainer != null) {
            this.mImageContainer.cancelRequest();
            this.setImageDrawable(null);
            this.mImageContainer = null;
        }
        super.onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }
}

