/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.content.Context;
import android.net.http.AndroidHttpClient;
import com.android.volley.NetworkResponse;
import com.android.volley.RequestTickle;
import com.android.volley.cache.DiskBasedCache;
import com.android.volley.misc.NetUtils;
import com.android.volley.misc.Utils;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.HttpClientStack;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.HttpStack;
import com.android.volley.toolbox.HurlStack;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.apache.http.client.HttpClient;

public class VolleyTickle {
    private static final String DEFAULT_CACHE_DIR = "volley";

    public static RequestTickle newRequestTickle(Context context, HttpStack stack) {
        File cacheDir = new File(context.getCacheDir(), DEFAULT_CACHE_DIR);
        if (stack == null) {
            stack = Utils.hasHoneycomb() ? new HurlStack() : new HttpClientStack((HttpClient)AndroidHttpClient.newInstance((String)NetUtils.getUserAgent(context)));
        }
        BasicNetwork network = new BasicNetwork(stack);
        RequestTickle tickle = new RequestTickle(new DiskBasedCache(cacheDir), network);
        return tickle;
    }

    public static RequestTickle newRequestTickle(Context context) {
        return VolleyTickle.newRequestTickle(context, null);
    }

    public static String parseResponse(NetworkResponse response) {
        String parsed;
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset(response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return parsed;
    }
}

