/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.graphics.Bitmap;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;

public class HttpHeaderParser {
    public static Cache.Entry parseCacheHeaders(NetworkResponse response) {
        long now = System.currentTimeMillis();
        long serverDate = 0L;
        long lastModified = 0L;
        long serverExpires = 0L;
        long softExpire = 0L;
        long finalExpire = 0L;
        long maxAge = 0L;
        long staleWhileRevalidate = 0L;
        boolean hasCacheControl = false;
        Map<String, String> headers = null;
        String serverEtag = null;
        if (null != response) {
            headers = response.headers;
            String headerValue = headers.get("Date");
            if (headerValue != null) {
                serverDate = HttpHeaderParser.parseDateAsEpoch(headerValue);
            }
            if ((headerValue = headers.get("Cache-Control")) != null) {
                hasCacheControl = true;
                String[] tokens = headerValue.split(",");
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i].trim();
                    if (token.equals("no-cache") || token.equals("no-store")) {
                        hasCacheControl = false;
                        continue;
                    }
                    if (token.startsWith("max-age=")) {
                        hasCacheControl = true;
                        try {
                            maxAge = Long.parseLong(token.substring(8));
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (token.startsWith("stale-while-revalidate=")) {
                        try {
                            staleWhileRevalidate = Long.parseLong(token.substring(23));
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (!token.equals("must-revalidate") && !token.equals("proxy-revalidate")) continue;
                    maxAge = 0L;
                }
            }
            if ((headerValue = headers.get("Expires")) != null) {
                serverExpires = HttpHeaderParser.parseDateAsEpoch(headerValue);
            }
            if ((headerValue = headers.get("Last-Modified")) != null) {
                lastModified = HttpHeaderParser.parseDateAsEpoch(headerValue);
            }
            serverEtag = headers.get("ETag");
            if (hasCacheControl) {
                softExpire = now + maxAge * 1000L;
                finalExpire = softExpire + staleWhileRevalidate * 1000L;
            } else if (serverDate > 0L && serverExpires >= serverDate) {
                finalExpire = softExpire = now + (serverExpires - serverDate);
            }
        }
        Cache.Entry entry = new Cache.Entry();
        entry.data = response == null ? null : response.data;
        entry.etag = serverEtag;
        entry.softTtl = softExpire;
        entry.ttl = finalExpire;
        entry.serverDate = serverDate;
        entry.lastModified = lastModified;
        entry.responseHeaders = headers;
        return entry;
    }

    public static Cache.Entry parseBitmapCacheHeaders(Bitmap bitmap) {
        NetworkResponse response = null;
        if (null != bitmap) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)stream);
            byte[] byteArray = stream.toByteArray();
            response = new NetworkResponse(byteArray);
        }
        return HttpHeaderParser.parseCacheHeaders(response);
    }

    public static Cache.Entry parseIgnoreCacheHeaders(NetworkResponse response) {
        long now = System.currentTimeMillis();
        Map<String, String> headers = response.headers;
        long serverDate = 0L;
        String serverEtag = null;
        String headerValue = headers.get("Date");
        if (headerValue != null) {
            serverDate = HttpHeaderParser.parseDateAsEpoch(headerValue);
        }
        serverEtag = headers.get("ETag");
        long cacheHitButRefreshed = 180000L;
        long cacheExpired = 86400000L;
        long softExpire = now + 180000L;
        long ttl = now + 86400000L;
        Cache.Entry entry = new Cache.Entry();
        entry.data = response.data;
        entry.etag = serverEtag;
        entry.softTtl = softExpire;
        entry.ttl = ttl;
        entry.serverDate = serverDate;
        entry.responseHeaders = headers;
        return entry;
    }

    public static Cache.Entry parseIgnoreCacheHeaders(NetworkResponse response, long soft_expire, long expire) {
        long now = System.currentTimeMillis();
        Map<String, String> headers = response.headers;
        long serverDate = 0L;
        String serverEtag = null;
        String headerValue = headers.get("Date");
        if (headerValue != null) {
            serverDate = HttpHeaderParser.parseDateAsEpoch(headerValue);
        }
        serverEtag = headers.get("ETag");
        long cacheHitButRefreshed = soft_expire;
        long cacheExpired = expire;
        long softExpire = now + cacheHitButRefreshed;
        long ttl = now + cacheExpired;
        Cache.Entry entry = new Cache.Entry();
        entry.data = response.data;
        entry.etag = serverEtag;
        entry.softTtl = softExpire;
        entry.ttl = ttl;
        entry.serverDate = serverDate;
        entry.responseHeaders = headers;
        return entry;
    }

    public static long parseDateAsEpoch(String dateStr) {
        try {
            return DateUtils.parseDate((String)dateStr).getTime();
        }
        catch (DateParseException e) {
            return 0L;
        }
    }

    public static String parseCharset(Map<String, String> headers, String defaultCharset) {
        String contentType = headers.get("Content-Type");
        if (contentType != null) {
            String[] params = contentType.split(";");
            for (int i = 1; i < params.length; ++i) {
                String[] pair = params[i].trim().split("=");
                if (pair.length != 2 || !pair[0].equals("charset")) continue;
                return pair[1];
            }
        }
        return defaultCharset;
    }

    public static String parseCharset(Map<String, String> headers) {
        return HttpHeaderParser.parseCharset(headers, "ISO-8859-1");
    }
}

