/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.misc;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IOUtils {
    public static int read(InputStream is) throws IOException {
        int b = is.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    public static void writeInt(OutputStream os, int n) throws IOException {
        os.write(n >> 0 & 0xFF);
        os.write(n >> 8 & 0xFF);
        os.write(n >> 16 & 0xFF);
        os.write(n >> 24 & 0xFF);
    }

    public static int readInt(InputStream is) throws IOException {
        int n = 0;
        n |= IOUtils.read(is) << 0;
        n |= IOUtils.read(is) << 8;
        n |= IOUtils.read(is) << 16;
        return n |= IOUtils.read(is) << 24;
    }

    public static void writeLong(OutputStream os, long n) throws IOException {
        os.write((byte)(n >>> 0));
        os.write((byte)(n >>> 8));
        os.write((byte)(n >>> 16));
        os.write((byte)(n >>> 24));
        os.write((byte)(n >>> 32));
        os.write((byte)(n >>> 40));
        os.write((byte)(n >>> 48));
        os.write((byte)(n >>> 56));
    }

    public static long readLong(InputStream is) throws IOException {
        long n = 0L;
        n |= ((long)IOUtils.read(is) & 0xFFL) << 0;
        n |= ((long)IOUtils.read(is) & 0xFFL) << 8;
        n |= ((long)IOUtils.read(is) & 0xFFL) << 16;
        n |= ((long)IOUtils.read(is) & 0xFFL) << 24;
        n |= ((long)IOUtils.read(is) & 0xFFL) << 32;
        n |= ((long)IOUtils.read(is) & 0xFFL) << 40;
        n |= ((long)IOUtils.read(is) & 0xFFL) << 48;
        return n |= ((long)IOUtils.read(is) & 0xFFL) << 56;
    }

    public static void writeString(OutputStream os, String s) throws IOException {
        byte[] b = s.getBytes("UTF-8");
        IOUtils.writeLong(os, b.length);
        os.write(b, 0, b.length);
    }

    public static String readString(InputStream is) throws IOException {
        int n = (int)IOUtils.readLong(is);
        byte[] b = IOUtils.streamToBytes(is, n);
        return new String(b, "UTF-8");
    }

    public static void writeStringStringMap(Map<String, String> map, OutputStream os) throws IOException {
        if (map != null) {
            IOUtils.writeInt(os, map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                IOUtils.writeString(os, entry.getKey());
                IOUtils.writeString(os, entry.getValue());
            }
        } else {
            IOUtils.writeInt(os, 0);
        }
    }

    public static Map<String, String> readStringStringMap(InputStream is) throws IOException {
        int size = IOUtils.readInt(is);
        HashMap<String, String> result = size == 0 ? Collections.emptyMap() : new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = IOUtils.readString(is).intern();
            String value = IOUtils.readString(is).intern();
            result.put(key, value);
        }
        return result;
    }

    public static byte[] streamToBytes(InputStream in, int length) throws IOException {
        int pos;
        int count;
        byte[] bytes = new byte[length];
        for (pos = 0; pos < length && (count = in.read(bytes, pos, length - pos)) != -1; pos += count) {
        }
        if (pos != length) {
            throw new IOException("Expected " + length + " bytes, read " + pos + " bytes");
        }
        return bytes;
    }

    public static class CountingInputStream
    extends FilterInputStream {
        private int bytesRead = 0;

        public CountingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            if (result != -1) {
                ++this.bytesRead;
            }
            return result;
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            int result = super.read(buffer, offset, count);
            if (result != -1) {
                this.bytesRead += result;
            }
            return result;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }
    }
}

