/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.cache.plus;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.net.http.AndroidHttpClient;
import android.support.v4.app.FragmentActivity;
import android.widget.ImageView;
import com.android.volley.RequestQueue;
import com.android.volley.cache.DiskLruBasedCache;
import com.android.volley.cache.plus.BitmapImageCache;
import com.android.volley.cache.plus.ImageCache;
import com.android.volley.cache.plus.ImageLoader;
import com.android.volley.error.VolleyError;
import com.android.volley.misc.NetUtils;
import com.android.volley.misc.Utils;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.HttpClientStack;
import com.android.volley.toolbox.HurlStack;
import com.android.volley.ui.PhotoView;
import java.util.ArrayList;
import org.apache.http.client.HttpClient;

public class SimpleImageLoader
extends ImageLoader {
    private static final ColorDrawable transparentDrawable = new ColorDrawable(17170445);
    private static final int HALF_FADE_IN_TIME = 100;
    protected static final String CACHE_DIR = "images";
    private ArrayList<Drawable> mPlaceHolderDrawables;
    private boolean mFadeInImage = true;
    private int mMaxImageHeight = 0;
    private int mMaxImageWidth = 0;

    public SimpleImageLoader(RequestQueue queue) {
        this(queue, BitmapImageCache.getInstance(null));
    }

    public SimpleImageLoader(RequestQueue queue, ImageCache imageCache) {
        this(queue, imageCache, null);
    }

    public SimpleImageLoader(RequestQueue queue, ImageCache imageCache, Resources resources) {
        super(queue, imageCache, resources);
    }

    public SimpleImageLoader(FragmentActivity activity) {
        super(SimpleImageLoader.newRequestQueue((Context)activity, null), BitmapImageCache.getInstance(activity.getSupportFragmentManager()), activity.getResources());
    }

    public SimpleImageLoader(FragmentActivity activity, DiskLruBasedCache.ImageCacheParams imageCacheParams) {
        super(SimpleImageLoader.newRequestQueue((Context)activity, imageCacheParams), BitmapImageCache.getInstance(activity.getSupportFragmentManager(), imageCacheParams), activity.getResources());
    }

    public SimpleImageLoader(Context context) {
        super(SimpleImageLoader.newRequestQueue(context, null), BitmapImageCache.getInstance(null), context.getResources());
    }

    public SimpleImageLoader(Context context, DiskLruBasedCache.ImageCacheParams imageCacheParams) {
        super(SimpleImageLoader.newRequestQueue(context, imageCacheParams), BitmapImageCache.getInstance(null, imageCacheParams), context.getResources());
    }

    public void startProcessingQueue() {
        this.getRequestQueue().start();
    }

    public void stopProcessingQueue() {
        this.getRequestQueue().stop();
    }

    public void clearCache() {
        this.getCache().clear();
    }

    public void flushCache() {
        this.getImageCache().clear();
        this.getCache().flush();
    }

    public void closeCache() {
        this.getCache().close();
    }

    public void invalidate(String key) {
        String cacheKey = SimpleImageLoader.getCacheKey(key, this.mMaxImageWidth, this.mMaxImageHeight);
        this.getImageCache().invalidateBitmap(cacheKey);
        this.getCache().invalidate(key, true);
    }

    public SimpleImageLoader setFadeInImage(boolean fadeInImage) {
        this.mFadeInImage = fadeInImage;
        return this;
    }

    public SimpleImageLoader setMaxImageSize(int maxImageWidth, int maxImageHeight) {
        this.mMaxImageWidth = maxImageWidth;
        this.mMaxImageHeight = maxImageHeight;
        return this;
    }

    public SimpleImageLoader setMaxImageSize(int maxImageSize) {
        return this.setMaxImageSize(maxImageSize, maxImageSize);
    }

    public SimpleImageLoader setDefaultDrawable(int defaultPlaceHolderResId) {
        this.mPlaceHolderDrawables = new ArrayList(1);
        this.mPlaceHolderDrawables.add(defaultPlaceHolderResId == -1 ? null : this.getResources().getDrawable(defaultPlaceHolderResId));
        return this;
    }

    public SimpleImageLoader setDefaultDrawables(ArrayList<Drawable> placeHolderDrawables) {
        this.mPlaceHolderDrawables = placeHolderDrawables;
        return this;
    }

    public int getMaxImageWidth() {
        return this.mMaxImageWidth;
    }

    public int getMaxImageHeight() {
        return this.mMaxImageHeight;
    }

    public ImageLoader.ImageContainer get(String requestUrl, ImageView imageView) {
        return this.get(requestUrl, imageView, 0);
    }

    public ImageLoader.ImageContainer get(String requestUrl, ImageView imageView, int maxImageWidth, int maxImageHeight) {
        return this.get(requestUrl, imageView, this.mPlaceHolderDrawables != null ? this.mPlaceHolderDrawables.get(0) : null, maxImageWidth, maxImageHeight);
    }

    public ImageLoader.ImageContainer get(String requestUrl, ImageView imageView, int placeHolderIndex) {
        return this.get(requestUrl, imageView, this.mPlaceHolderDrawables != null ? this.mPlaceHolderDrawables.get(placeHolderIndex) : null, this.mMaxImageWidth, this.mMaxImageHeight);
    }

    public ImageLoader.ImageContainer get(String requestUrl, ImageView imageView, Drawable placeHolder) {
        return this.get(requestUrl, imageView, placeHolder, this.mMaxImageWidth, this.mMaxImageHeight);
    }

    public ImageLoader.ImageContainer get(String requestUrl, ImageView imageView, Drawable placeHolder, int maxWidth, int maxHeight) {
        String recycledImageUrl;
        ImageLoader.ImageContainer imageContainer = imageView.getTag() != null && imageView.getTag() instanceof ImageLoader.ImageContainer ? (ImageLoader.ImageContainer)imageView.getTag() : null;
        String string = recycledImageUrl = imageContainer != null ? imageContainer.getRequestUrl() : null;
        if (requestUrl == null || !requestUrl.equals(recycledImageUrl)) {
            if (imageContainer != null) {
                imageContainer.cancelRequest();
                imageView.setTag(null);
            }
            if (requestUrl != null) {
                imageContainer = this.get(requestUrl, SimpleImageLoader.getImageListener(this.getResources(), imageView, placeHolder, this.mFadeInImage), maxWidth, maxHeight);
                imageView.setTag((Object)imageContainer);
            } else {
                if (!(imageView instanceof PhotoView)) {
                    imageView.setImageDrawable(placeHolder);
                }
                imageView.setTag(null);
            }
        }
        return imageContainer;
    }

    public ImageLoader.ImageContainer set(String requestUrl, ImageView imageView, Bitmap bitmap) {
        return this.set(requestUrl, imageView, 0, bitmap);
    }

    public ImageLoader.ImageContainer set(String requestUrl, ImageView imageView, int placeHolderIndex, Bitmap bitmap) {
        return this.set(requestUrl, imageView, this.mPlaceHolderDrawables != null ? this.mPlaceHolderDrawables.get(placeHolderIndex) : null, this.mMaxImageWidth, this.mMaxImageHeight, bitmap);
    }

    public ImageLoader.ImageContainer set(String requestUrl, ImageView imageView, Drawable placeHolder, Bitmap bitmap) {
        return this.set(requestUrl, imageView, placeHolder, this.mMaxImageWidth, this.mMaxImageHeight, bitmap);
    }

    public ImageLoader.ImageContainer set(String requestUrl, ImageView imageView, Drawable placeHolder, int maxWidth, int maxHeight, Bitmap bitmap) {
        ImageLoader.ImageContainer imageContainer;
        ImageLoader.ImageContainer imageContainer2 = imageContainer = imageView.getTag() != null && imageView.getTag() instanceof ImageLoader.ImageContainer ? (ImageLoader.ImageContainer)imageView.getTag() : null;
        if (imageContainer != null) {
            imageContainer.cancelRequest();
            imageView.setTag(null);
        }
        if (requestUrl != null) {
            imageContainer = this.set(requestUrl, SimpleImageLoader.getImageListener(this.getResources(), imageView, placeHolder, this.mFadeInImage), maxWidth, maxHeight, bitmap);
            imageView.setTag((Object)imageContainer);
        } else {
            if (!(imageView instanceof PhotoView)) {
                imageView.setImageDrawable(placeHolder);
            }
            imageView.setTag(null);
        }
        return imageContainer;
    }

    private static ImageLoader.ImageListener getImageListener(final Resources resources, final ImageView imageView, final Drawable placeHolder, final boolean fadeInImage) {
        return new ImageLoader.ImageListener(){

            @Override
            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                imageView.setTag(null);
                if (response.getBitmap() != null) {
                    if (imageView instanceof PhotoView) {
                        SimpleImageLoader.setPhotoImageBitmap((PhotoView)imageView, response.getBitmap(), resources, fadeInImage && !isImmediate);
                    } else {
                        SimpleImageLoader.setImageBitmap(imageView, response.getBitmap(), resources, fadeInImage && !isImmediate);
                    }
                } else if (!(imageView instanceof PhotoView)) {
                    imageView.setImageDrawable(placeHolder);
                }
            }

            @Override
            public void onErrorResponse(VolleyError volleyError) {
            }
        };
    }

    private static RequestQueue newRequestQueue(Context context, DiskLruBasedCache.ImageCacheParams imageCacheParams) {
        BasicNetwork network = new BasicNetwork(Utils.hasHoneycomb() ? new HurlStack() : new HttpClientStack((HttpClient)AndroidHttpClient.newInstance((String)NetUtils.getUserAgent(context))));
        DiskLruBasedCache cache = null != imageCacheParams ? new DiskLruBasedCache(imageCacheParams) : new DiskLruBasedCache(Utils.getDiskCacheDir(context, CACHE_DIR));
        RequestQueue queue = new RequestQueue(cache, network);
        queue.start();
        return queue;
    }

    @TargetApi(value=12)
    private static void setImageBitmap(final ImageView imageView, final BitmapDrawable bitmapDrawable, Resources resources, boolean fadeIn) {
        if (fadeIn && Utils.hasHoneycombMR1()) {
            imageView.animate().scaleY(0.95f).scaleX(0.95f).alpha(0.0f).setDuration(imageView.getDrawable() == null ? 0L : 100L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    imageView.setImageDrawable((Drawable)bitmapDrawable);
                    imageView.animate().alpha(1.0f).scaleY(1.0f).scaleX(1.0f).setDuration(100L).setListener(null);
                }
            });
        } else if (fadeIn) {
            Object initialDrawable = imageView.getDrawable() != null ? imageView.getDrawable() : transparentDrawable;
            TransitionDrawable td = new TransitionDrawable(new Drawable[]{initialDrawable, bitmapDrawable});
            imageView.setImageDrawable((Drawable)td);
            td.startTransition(200);
        } else {
            imageView.setImageDrawable((Drawable)bitmapDrawable);
        }
    }

    @TargetApi(value=12)
    private static void setPhotoImageBitmap(final PhotoView imageView, final BitmapDrawable bitmapDrawable, Resources resources, boolean fadeIn) {
        if (fadeIn && Utils.hasHoneycombMR1()) {
            imageView.animate().scaleY(0.95f).scaleX(0.95f).alpha(0.0f).setDuration(imageView.getDrawable() == null ? 0L : 100L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    imageView.bindDrawable((Drawable)bitmapDrawable);
                    imageView.animate().alpha(1.0f).scaleY(1.0f).scaleX(1.0f).setDuration(100L).setListener(null);
                }
            });
        } else if (fadeIn) {
            Object initialDrawable = imageView.getDrawable() != null ? imageView.getDrawable() : transparentDrawable;
            TransitionDrawable td = new TransitionDrawable(new Drawable[]{initialDrawable, bitmapDrawable});
            imageView.bindDrawable((Drawable)td);
            td.startTransition(200);
        } else {
            imageView.bindDrawable((Drawable)bitmapDrawable);
        }
    }

    public static interface ImageLoaderProvider {
        public SimpleImageLoader getImageLoaderInstance();
    }
}

