/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.snapper;

import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import dev.chrisbanes.snapper.ExperimentalSnapperApi;
import dev.chrisbanes.snapper.LazyListSnapperLayoutInfo;
import dev.chrisbanes.snapper.SnapperLayoutInfo;
import dev.chrisbanes.snapper.SnapperLayoutItemInfo;
import dev.chrisbanes.snapper.SnapperLog;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001BQ\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\u0002\u0010\u000eJ\b\u0010!\u001a\u00020\u000bH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J&\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)2\u0006\u0010*\u001a\u00020'H\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bH\u0016J\b\u0010-\u001a\u00020'H\u0002R\u001d\u0010\u000f\u001a\u0004\u0018\u00010\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006."}, d2={"Ldev/chrisbanes/snapper/LazyListSnapperLayoutInfo;", "Ldev/chrisbanes/snapper/SnapperLayoutInfo;", "lazyListState", "Landroidx/compose/foundation/lazy/LazyListState;", "snapOffsetForItem", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "layoutInfo", "Ldev/chrisbanes/snapper/SnapperLayoutItemInfo;", "item", "", "endContentPadding", "(Landroidx/compose/foundation/lazy/LazyListState;Lkotlin/jvm/functions/Function2;I)V", "(Landroidx/compose/foundation/lazy/LazyListState;Lkotlin/jvm/functions/Function2;)V", "currentItem", "getCurrentItem", "()Ldev/chrisbanes/snapper/SnapperLayoutItemInfo;", "currentItem$delegate", "Landroidx/compose/runtime/State;", "endScrollOffset", "getEndScrollOffset", "()I", "itemCount", "getItemCount", "startScrollOffset", "getStartScrollOffset", "totalItemsCount", "getTotalItemsCount", "visibleItems", "Lkotlin/sequences/Sequence;", "getVisibleItems", "()Lkotlin/sequences/Sequence;", "calculateItemSpacing", "canScrollTowardsEnd", "", "canScrollTowardsStart", "determineTargetIndex", "velocity", "", "decayAnimationSpec", "Landroidx/compose/animation/core/DecayAnimationSpec;", "maximumFlingDistance", "distanceToIndexSnap", "index", "estimateDistancePerItem", "lib_release"})
@ExperimentalSnapperApi
@StabilityInferred(parameters=0)
public final class LazyListSnapperLayoutInfo
extends SnapperLayoutInfo {
    @NotNull
    private final LazyListState lazyListState;
    @NotNull
    private final Function2<SnapperLayoutInfo, SnapperLayoutItemInfo, Integer> snapOffsetForItem;
    private final int startScrollOffset;
    @NotNull
    private final State currentItem$delegate;
    public static final int $stable;

    public LazyListSnapperLayoutInfo(@NotNull LazyListState lazyListState, @NotNull Function2<? super SnapperLayoutInfo, ? super SnapperLayoutItemInfo, Integer> snapOffsetForItem) {
        Intrinsics.checkNotNullParameter((Object)lazyListState, (String)"lazyListState");
        Intrinsics.checkNotNullParameter(snapOffsetForItem, (String)"snapOffsetForItem");
        this.lazyListState = lazyListState;
        this.snapOffsetForItem = snapOffsetForItem;
        this.currentItem$delegate = SnapshotStateKt.derivedStateOf((Function0)((Function0)new Function0<SnapperLayoutItemInfo>(this){
            final /* synthetic */ LazyListSnapperLayoutInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final SnapperLayoutItemInfo invoke() {
                void $this$lastOrNull$iv;
                Sequence<SnapperLayoutItemInfo> sequence = this.this$0.getVisibleItems();
                LazyListSnapperLayoutInfo lazyListSnapperLayoutInfo = this.this$0;
                boolean $i$f$lastOrNull = false;
                Object last$iv = null;
                for (E element$iv : $this$lastOrNull$iv) {
                    SnapperLayoutItemInfo it = (SnapperLayoutItemInfo)element$iv;
                    boolean bl = false;
                    if (!(it.getOffset() <= ((Number)LazyListSnapperLayoutInfo.access$getSnapOffsetForItem$p(lazyListSnapperLayoutInfo).invoke((Object)lazyListSnapperLayoutInfo, (Object)it)).intValue())) continue;
                    last$iv = element$iv;
                }
                return last$iv;
            }
        }));
    }

    @Deprecated(message="endContentPadding is no longer necessary to be passed in", replaceWith=@ReplaceWith(expression="LazyListSnapperLayoutInfo(lazyListState, snapOffsetForItem)", imports={}))
    public LazyListSnapperLayoutInfo(@NotNull LazyListState lazyListState, @NotNull Function2<? super SnapperLayoutInfo, ? super SnapperLayoutItemInfo, Integer> snapOffsetForItem, int endContentPadding) {
        Intrinsics.checkNotNullParameter((Object)lazyListState, (String)"lazyListState");
        Intrinsics.checkNotNullParameter(snapOffsetForItem, (String)"snapOffsetForItem");
        this(lazyListState, snapOffsetForItem);
    }

    public /* synthetic */ LazyListSnapperLayoutInfo(LazyListState lazyListState, Function2 function2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(lazyListState, (Function2<? super SnapperLayoutInfo, ? super SnapperLayoutItemInfo, Integer>)function2, n);
    }

    @Override
    public int getStartScrollOffset() {
        return this.startScrollOffset;
    }

    @Override
    public int getEndScrollOffset() {
        LazyListLayoutInfo it = this.lazyListState.getLayoutInfo();
        boolean bl = false;
        return it.getViewportEndOffset() - it.getAfterContentPadding();
    }

    private final int getItemCount() {
        return this.lazyListState.getLayoutInfo().getTotalItemsCount();
    }

    @Override
    public int getTotalItemsCount() {
        return this.lazyListState.getLayoutInfo().getTotalItemsCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public SnapperLayoutItemInfo getCurrentItem() {
        void $this$getValue$iv;
        State state = this.currentItem$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (SnapperLayoutItemInfo)$this$getValue$iv.getValue();
    }

    @Override
    @NotNull
    public Sequence<SnapperLayoutItemInfo> getVisibleItems() {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.lazyListState.getLayoutInfo().getVisibleItemsInfo()), (Function1)visibleItems.1.INSTANCE);
    }

    @Override
    public int distanceToIndexSnap(int index) {
        Object v0;
        block3: {
            Sequence<SnapperLayoutItemInfo> $this$firstOrNull$iv = this.getVisibleItems();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SnapperLayoutItemInfo it = (SnapperLayoutItemInfo)element$iv;
                boolean bl = false;
                if (!(it.getIndex() == index)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        SnapperLayoutItemInfo itemInfo = v0;
        if (itemInfo != null) {
            return itemInfo.getOffset() - ((Number)this.snapOffsetForItem.invoke((Object)this, (Object)itemInfo)).intValue();
        }
        SnapperLayoutItemInfo snapperLayoutItemInfo = this.getCurrentItem();
        if (snapperLayoutItemInfo == null) {
            return 0;
        }
        SnapperLayoutItemInfo currentItem2 = snapperLayoutItemInfo;
        return MathKt.roundToInt((float)((float)(index - currentItem2.getIndex()) * this.estimateDistancePerItem())) + currentItem2.getOffset() - ((Number)this.snapOffsetForItem.invoke((Object)this, (Object)currentItem2)).intValue();
    }

    @Override
    public boolean canScrollTowardsStart() {
        boolean bl;
        LazyListItemInfo lazyListItemInfo = (LazyListItemInfo)CollectionsKt.firstOrNull((List)this.lazyListState.getLayoutInfo().getVisibleItemsInfo());
        if (lazyListItemInfo != null) {
            LazyListItemInfo it = lazyListItemInfo;
            boolean bl2 = false;
            bl = it.getIndex() > 0 || it.getOffset() < this.getStartScrollOffset();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canScrollTowardsEnd() {
        boolean bl;
        LazyListItemInfo lazyListItemInfo = (LazyListItemInfo)CollectionsKt.lastOrNull((List)this.lazyListState.getLayoutInfo().getVisibleItemsInfo());
        if (lazyListItemInfo != null) {
            LazyListItemInfo it = lazyListItemInfo;
            boolean bl2 = false;
            bl = it.getIndex() < this.getItemCount() - 1 || it.getOffset() + it.getSize() > this.getEndScrollOffset();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int determineTargetIndex(float velocity, @NotNull DecayAnimationSpec<Float> decayAnimationSpec, float maximumFlingDistance) {
        int n;
        Intrinsics.checkNotNullParameter(decayAnimationSpec, (String)"decayAnimationSpec");
        SnapperLayoutItemInfo snapperLayoutItemInfo = this.getCurrentItem();
        if (snapperLayoutItemInfo == null) {
            return -1;
        }
        SnapperLayoutItemInfo curr = snapperLayoutItemInfo;
        float distancePerItem = this.estimateDistancePerItem();
        if (distancePerItem <= 0.0f) {
            return curr.getIndex();
        }
        int distanceToCurrent = this.distanceToIndexSnap(curr.getIndex());
        int distanceToNext = this.distanceToIndexSnap(curr.getIndex() + 1);
        if (Math.abs(velocity) < 0.5f) {
            return RangesKt.coerceIn((int)(Math.abs(distanceToCurrent) < Math.abs(distanceToNext) ? curr.getIndex() : curr.getIndex() + 1), (int)0, (int)(this.getItemCount() - 1));
        }
        float distance = RangesKt.coerceIn((float)DecayAnimationSpecKt.calculateTargetValue(decayAnimationSpec, (float)0.0f, (float)velocity), (float)(-maximumFlingDistance), (float)maximumFlingDistance);
        boolean bl = false;
        float flingDistance = velocity < 0.0f ? RangesKt.coerceAtMost((float)(distance + (float)distanceToNext), (float)0.0f) : RangesKt.coerceAtLeast((float)(distance + (float)distanceToCurrent), (float)0.0f);
        double flingIndexDelta = (double)flingDistance / (double)distancePerItem;
        double currentItemOffsetRatio = (double)distanceToCurrent / (double)distancePerItem;
        int indexOffset = MathKt.roundToInt((double)(flingIndexDelta - currentItemOffsetRatio));
        int result = n = RangesKt.coerceIn((int)(curr.getIndex() + indexOffset), (int)0, (int)(this.getItemCount() - 1));
        boolean bl2 = false;
        SnapperLog this_$iv = SnapperLog.INSTANCE;
        String tag$iv = "SnapperFlingBehavior";
        boolean $i$f$d = false;
        return n;
    }

    private final int calculateItemSpacing() {
        int n;
        LazyListLayoutInfo $this$calculateItemSpacing_u24lambda_u2d7 = this.lazyListState.getLayoutInfo();
        boolean bl = false;
        if ($this$calculateItemSpacing_u24lambda_u2d7.getVisibleItemsInfo().size() >= 2) {
            LazyListItemInfo first = (LazyListItemInfo)$this$calculateItemSpacing_u24lambda_u2d7.getVisibleItemsInfo().get(0);
            LazyListItemInfo second = (LazyListItemInfo)$this$calculateItemSpacing_u24lambda_u2d7.getVisibleItemsInfo().get(1);
            n = second.getOffset() - (first.getSize() + first.getOffset());
        } else {
            n = 0;
        }
        return n;
    }

    private final float estimateDistancePerItem() {
        Object v2;
        Object v0;
        LazyListLayoutInfo $this$estimateDistancePerItem_u24lambda_u2d10 = this.lazyListState.getLayoutInfo();
        boolean bl = false;
        if ($this$estimateDistancePerItem_u24lambda_u2d10.getVisibleItemsInfo().isEmpty()) {
            return -1.0f;
        }
        Iterable $this$minByOrNull$iv = $this$estimateDistancePerItem_u24lambda_u2d10.getVisibleItemsInfo();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                LazyListItemInfo it = (LazyListItemInfo)minElem$iv;
                boolean bl2 = false;
                int minValue$iv = it.getOffset();
                do {
                    Object e$iv = iterator$iv.next();
                    LazyListItemInfo it2 = (LazyListItemInfo)e$iv;
                    $i$a$-minByOrNull-LazyListSnapperLayoutInfo$estimateDistancePerItem$1$minPosView$1 = false;
                    int v$iv = it2.getOffset();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        LazyListItemInfo lazyListItemInfo = v0;
        if (lazyListItemInfo == null) {
            return -1.0f;
        }
        LazyListItemInfo minPosView = lazyListItemInfo;
        Iterable $this$maxByOrNull$iv = $this$estimateDistancePerItem_u24lambda_u2d10.getVisibleItemsInfo();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = maxElem$iv;
            } else {
                LazyListItemInfo it = (LazyListItemInfo)maxElem$iv;
                boolean bl3 = false;
                int maxValue$iv = it.getOffset() + it.getSize();
                do {
                    Object e$iv = iterator$iv2.next();
                    LazyListItemInfo it3 = (LazyListItemInfo)e$iv;
                    $i$a$-maxByOrNull-LazyListSnapperLayoutInfo$estimateDistancePerItem$1$maxPosView$1 = false;
                    int v$iv = it3.getOffset() + it3.getSize();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = maxElem$iv;
            }
        }
        LazyListItemInfo lazyListItemInfo2 = v2;
        if (lazyListItemInfo2 == null) {
            return -1.0f;
        }
        LazyListItemInfo maxPosView = lazyListItemInfo2;
        int start = Math.min(minPosView.getOffset(), maxPosView.getOffset());
        int end = Math.max(minPosView.getOffset() + minPosView.getSize(), maxPosView.getOffset() + maxPosView.getSize());
        int distance = end - start;
        return distance == 0 ? -1.0f : (float)(distance + this.calculateItemSpacing()) / (float)$this$estimateDistancePerItem_u24lambda_u2d10.getVisibleItemsInfo().size();
    }

    public static final /* synthetic */ Function2 access$getSnapOffsetForItem$p(LazyListSnapperLayoutInfo $this) {
        return $this.snapOffsetForItem;
    }
}

