/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.haze;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutAwareModifierNode;
import androidx.compose.ui.unit.IntSizeKt;
import dev.chrisbanes.haze.HazeArea;
import dev.chrisbanes.haze.HazeState;
import dev.chrisbanes.haze.HazeStyle;
import dev.chrisbanes.haze.PlatformKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J'\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\b\u0010$\u001a\u00020\u001fH\u0002J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\b\u0010+\u001a\u00020\u001fH\u0016J\b\u0010,\u001a\u00020\u001fH\u0016J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020\u001fJ\t\u00101\u001a\u000202H\u00d6\u0001R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u00063"}, d2={"Ldev/chrisbanes/haze/HazeChildNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/LayoutAwareModifierNode;", "Landroidx/compose/ui/node/CompositionLocalConsumerModifierNode;", "state", "Ldev/chrisbanes/haze/HazeState;", "shape", "Landroidx/compose/ui/graphics/Shape;", "style", "Ldev/chrisbanes/haze/HazeStyle;", "(Ldev/chrisbanes/haze/HazeState;Landroidx/compose/ui/graphics/Shape;Ldev/chrisbanes/haze/HazeStyle;)V", "area", "Ldev/chrisbanes/haze/HazeArea;", "getArea", "()Ldev/chrisbanes/haze/HazeArea;", "area$delegate", "Lkotlin/Lazy;", "attachedState", "getShape", "()Landroidx/compose/ui/graphics/Shape;", "setShape", "(Landroidx/compose/ui/graphics/Shape;)V", "getState", "()Ldev/chrisbanes/haze/HazeState;", "setState", "(Ldev/chrisbanes/haze/HazeState;)V", "getStyle", "()Ldev/chrisbanes/haze/HazeStyle;", "setStyle", "(Ldev/chrisbanes/haze/HazeStyle;)V", "attachToHazeState", "", "component1", "component2", "component3", "copy", "detachFromHazeState", "equals", "", "other", "", "hashCode", "", "onAttach", "onDetach", "onPlaced", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "onUpdate", "toString", "", "haze_release"})
final class HazeChildNode
extends Modifier.Node
implements LayoutAwareModifierNode,
CompositionLocalConsumerModifierNode {
    @NotNull
    private HazeState state;
    @NotNull
    private Shape shape;
    @NotNull
    private HazeStyle style;
    @NotNull
    private final Lazy area$delegate;
    @Nullable
    private HazeState attachedState;

    public HazeChildNode(@NotNull HazeState state, @NotNull Shape shape, @NotNull HazeStyle style) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.state = state;
        this.shape = shape;
        this.style = style;
        this.area$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HazeArea>(this){
            final /* synthetic */ HazeChildNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HazeArea invoke() {
                return new HazeArea(0L, 0L, this.this$0.getShape(), this.this$0.getStyle(), 3, null);
            }
        }));
    }

    @NotNull
    public final HazeState getState() {
        return this.state;
    }

    public final void setState(@NotNull HazeState hazeState) {
        Intrinsics.checkNotNullParameter((Object)hazeState, (String)"<set-?>");
        this.state = hazeState;
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    public final void setShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"<set-?>");
        this.shape = shape;
    }

    @NotNull
    public final HazeStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull HazeStyle hazeStyle) {
        Intrinsics.checkNotNullParameter((Object)hazeStyle, (String)"<set-?>");
        this.style = hazeStyle;
    }

    private final HazeArea getArea() {
        Lazy lazy = this.area$delegate;
        return (HazeArea)lazy.getValue();
    }

    public void onAttach() {
        this.attachToHazeState();
    }

    public final void onUpdate() {
        this.getArea().setShape$haze_release(this.shape);
        this.getArea().setStyle$haze_release(this.style);
        if (!Intrinsics.areEqual((Object)this.state, (Object)this.attachedState)) {
            this.detachFromHazeState();
            this.attachToHazeState();
        }
    }

    public void onPlaced(@NotNull LayoutCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.getArea().setPositionOnScreen-k-4lQ0M$haze_release(Offset.plus-MK-Hz9U((long)LayoutCoordinatesKt.positionInWindow((LayoutCoordinates)coordinates), (long)PlatformKt.calculateWindowOffset(this)));
        this.getArea().setSize-uvyYCjk$haze_release(IntSizeKt.toSize-ozmzZPI((long)coordinates.getSize-YbymL2g()));
    }

    public void onDetach() {
        this.detachFromHazeState();
    }

    private final void attachToHazeState() {
        this.state.registerArea(this.getArea());
        this.attachedState = this.state;
        DelegatableNodeKt.invalidateSubtree((DelegatableNode)((DelegatableNode)this));
    }

    private final void detachFromHazeState() {
        HazeState hazeState = this.attachedState;
        if (hazeState != null) {
            hazeState.unregisterArea(this.getArea());
        }
        this.attachedState = null;
    }

    @NotNull
    public final HazeState component1() {
        return this.state;
    }

    @NotNull
    public final Shape component2() {
        return this.shape;
    }

    @NotNull
    public final HazeStyle component3() {
        return this.style;
    }

    @NotNull
    public final HazeChildNode copy(@NotNull HazeState state, @NotNull Shape shape, @NotNull HazeStyle style) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return new HazeChildNode(state, shape, style);
    }

    public static /* synthetic */ HazeChildNode copy$default(HazeChildNode hazeChildNode, HazeState hazeState, Shape shape, HazeStyle hazeStyle, int n, Object object) {
        if ((n & 1) != 0) {
            hazeState = hazeChildNode.state;
        }
        if ((n & 2) != 0) {
            shape = hazeChildNode.shape;
        }
        if ((n & 4) != 0) {
            hazeStyle = hazeChildNode.style;
        }
        return hazeChildNode.copy(hazeState, shape, hazeStyle);
    }

    @NotNull
    public String toString() {
        return "HazeChildNode(state=" + this.state + ", shape=" + this.shape + ", style=" + this.style + ")";
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = result * 31 + this.shape.hashCode();
        result = result * 31 + this.style.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HazeChildNode)) {
            return false;
        }
        HazeChildNode hazeChildNode = (HazeChildNode)((Object)other);
        if (!Intrinsics.areEqual((Object)this.state, (Object)hazeChildNode.state)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shape, (Object)hazeChildNode.shape)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.style, (Object)hazeChildNode.style);
    }
}

