/*
 * Decompiled with CFR 0.152.
 */
package mva2.adapter.internal;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v7.util.DiffUtil;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class DiffUtilCallback<M>
extends DiffUtil.Callback {
    private final List<M> oldList;
    private final List<M> newList;

    protected DiffUtilCallback(List<M> oldList, List<M> newList) {
        this.oldList = oldList;
        this.newList = newList;
    }

    public int getOldListSize() {
        return this.oldList.size();
    }

    public int getNewListSize() {
        return this.newList.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        return this.areItemsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        return this.areContentsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    @Nullable
    public Object getChangePayload(int oldItemPosition, int newItemPosition) {
        Object payload = this.getChangePayload(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
        return payload != null ? payload : super.getChangePayload(oldItemPosition, newItemPosition);
    }

    public abstract boolean areItemsTheSame(M var1, M var2);

    public abstract boolean areContentsTheSame(M var1, M var2);

    public abstract Object getChangePayload(M var1, M var2);
}

