/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

import de.undercouch.citeproc.csl.CSLCitation;
import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLProperties;

public class CSLCitationBuilder {
    private CSLCitationItem[] citationItems;
    private String citationID;
    private CSLProperties properties;

    public CSLCitationBuilder(CSLCitationItem ... citationItems) {
        this.citationItems = citationItems;
        this.citationID = Long.toString((long)Math.floor(Math.random() * 1.0E14), 32);
        this.properties = new CSLProperties();
    }

    public CSLCitationBuilder citationID(String citationID) {
        this.citationID = citationID;
        return this;
    }

    public CSLCitationBuilder properties(CSLProperties properties) {
        this.properties = properties;
        return this;
    }

    public CSLCitationBuilder(CSLCitation original) {
        this.citationItems = original.getCitationItems();
        this.citationID = original.getCitationID();
        this.properties = original.getProperties();
    }

    public CSLCitation build() {
        return new CSLCitation(this.citationItems, this.citationID, this.properties);
    }

    public CSLCitationBuilder citationID(long citationID) {
        this.citationID(String.valueOf(citationID));
        return this;
    }
}

