/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.core.resolve;

import com.slimjars.dist.gnu.trove.TLongCollection;
import com.slimjars.dist.gnu.trove.set.hash.TLongHashSet;
import de.topobyte.adt.multicollections.MultiSet;
import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import de.topobyte.osm4j.core.resolve.AbstractEntityFinder;
import de.topobyte.osm4j.core.resolve.EntityNotFoundException;
import de.topobyte.osm4j.core.resolve.OsmEntityProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityFinderLogMissing
extends AbstractEntityFinder {
    static final Logger logger = LoggerFactory.getLogger(EntityFinderLogMissing.class);
    private OsmEntityProvider entityProvider;

    public EntityFinderLogMissing(OsmEntityProvider entityProvider) {
        this.entityProvider = entityProvider;
    }

    protected abstract void log(String var1);

    private void logNodeNotFound(long id) {
        String message = String.format("Unable to find node with id %d", id);
        this.log(message);
    }

    private void logWayNotFound(long id) {
        String message = String.format("Unable to find way with id %d", id);
        this.log(message);
    }

    private void logRelationNotFound(long id) {
        String message = String.format("Unable to find relation with id %d", id);
        this.log(message);
    }

    private void logWayNodeNotFound(OsmWay way, long nodeId) {
        String message = String.format("Unable to find way node: way id %d, node id %d", way.getId(), nodeId);
        this.log(message);
    }

    private void logMemberNotFound(OsmRelation relation, OsmRelationMember member) {
        String message = String.format("Unable to find member: relation id %d, member %s:%d", relation.getId(), member.getType().toString(), member.getId());
        this.log(message);
    }

    @Override
    public List<OsmNode> findNodes(TLongCollection ids) throws EntityNotFoundException {
        ArrayList<OsmNode> nodes = new ArrayList<OsmNode>();
        for (long id : ids) {
            try {
                nodes.add(this.entityProvider.getNode(id));
            }
            catch (EntityNotFoundException e) {
                this.logNodeNotFound(id);
            }
        }
        return nodes;
    }

    @Override
    public List<OsmWay> findWays(TLongCollection ids) throws EntityNotFoundException {
        ArrayList<OsmWay> ways = new ArrayList<OsmWay>();
        for (long id : ids) {
            try {
                ways.add(this.entityProvider.getWay(id));
            }
            catch (EntityNotFoundException e) {
                this.logWayNotFound(id);
            }
        }
        return ways;
    }

    @Override
    public List<OsmRelation> findRelations(TLongCollection ids) {
        ArrayList<OsmRelation> relations = new ArrayList<OsmRelation>();
        for (long id : ids) {
            try {
                relations.add(this.entityProvider.getRelation(id));
            }
            catch (EntityNotFoundException e) {
                this.logRelationNotFound(id);
            }
        }
        return relations;
    }

    @Override
    public void findWayNodes(OsmWay way, Collection<OsmNode> outNodes) {
        for (int i = 0; i < way.getNumberOfNodes(); ++i) {
            long nodeId = way.getNodeId(i);
            try {
                outNodes.add(this.entityProvider.getNode(nodeId));
                continue;
            }
            catch (EntityNotFoundException e) {
                this.logWayNodeNotFound(way, nodeId);
            }
        }
    }

    @Override
    public void findMemberNodes(OsmRelation relation, Set<OsmNode> outNodes) {
        for (OsmRelationMember member : OsmModelUtil.membersAsList(relation)) {
            try {
                this.addMember(member, outNodes, null, null, this.entityProvider);
            }
            catch (EntityNotFoundException e) {
                this.logMemberNotFound(relation, member);
            }
        }
    }

    @Override
    public void findMemberWays(OsmRelation relation, Set<OsmWay> outWays) {
        for (OsmRelationMember member : OsmModelUtil.membersAsList(relation)) {
            try {
                this.addMember(member, null, outWays, null, this.entityProvider);
            }
            catch (EntityNotFoundException e) {
                this.logMemberNotFound(relation, member);
            }
        }
    }

    @Override
    public void findMemberWays(OsmRelation relation, MultiSet<OsmWay> outWays) throws EntityNotFoundException {
        for (OsmRelationMember member : OsmModelUtil.membersAsList(relation)) {
            if (member.getType() != EntityType.Way) continue;
            try {
                outWays.add((Object)this.entityProvider.getWay(member.getId()));
            }
            catch (EntityNotFoundException e) {
                this.logMemberNotFound(relation, member);
            }
        }
    }

    @Override
    public void findMemberRelations(OsmRelation relation, Set<OsmRelation> outRelations) throws EntityNotFoundException {
        for (OsmRelationMember member : OsmModelUtil.membersAsList(relation)) {
            try {
                this.addMember(member, null, null, outRelations, this.entityProvider);
            }
            catch (EntityNotFoundException e) {
                this.logMemberNotFound(relation, member);
            }
        }
    }

    @Override
    public void findMemberRelationsRecursively(OsmRelation relation, Set<OsmRelation> outRelations) {
        LinkedList<OsmRelation> queue = new LinkedList<OsmRelation>();
        queue.add(relation);
        this.findMemberRelationsRecursively((Deque<OsmRelation>)queue, outRelations);
    }

    @Override
    public void findMemberRelationsRecursively(Collection<OsmRelation> relations, Set<OsmRelation> outRelations) {
        LinkedList<OsmRelation> queue = new LinkedList<OsmRelation>();
        queue.addAll(relations);
        this.findMemberRelationsRecursively((Deque<OsmRelation>)queue, outRelations);
    }

    private void findMemberRelationsRecursively(Deque<OsmRelation> queue, Set<OsmRelation> outRelations) {
        TLongHashSet ids = new TLongHashSet();
        while (!queue.isEmpty()) {
            OsmRelation relation = queue.remove();
            for (OsmRelationMember member : OsmModelUtil.membersAsList(relation)) {
                long id;
                if (member.getType() != EntityType.Relation || ids.contains(id = member.getId())) continue;
                ids.add(id);
                try {
                    OsmRelation child = this.entityProvider.getRelation(id);
                    outRelations.add(child);
                    queue.add(child);
                }
                catch (EntityNotFoundException e) {
                    this.logRelationNotFound(id);
                }
            }
        }
    }

    @Override
    public void findMemberNodesAndWays(OsmRelation relation, Set<OsmNode> outNodes, Set<OsmWay> outWays) {
        for (OsmRelationMember member : OsmModelUtil.membersAsList(relation)) {
            try {
                this.addMember(member, outNodes, outWays, null, this.entityProvider);
            }
            catch (EntityNotFoundException e) {
                this.logMemberNotFound(relation, member);
            }
        }
    }

    @Override
    public void findMemberNodesAndWayNodes(OsmRelation relation, Set<OsmNode> outNodes) throws EntityNotFoundException {
        HashSet<OsmWay> ways = new HashSet<OsmWay>();
        this.findMemberNodesAndWays(relation, outNodes, ways);
        this.findWayNodes(ways, outNodes);
    }
}

