/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.sisu.bean;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.DefaultBindingScopingVisitor;
import com.google.inject.spi.ProvisionListener;
import java.util.ArrayList;

public abstract class $BeanScheduler {
    static final Object CYCLE_ACTIVATOR;
    static final Object CANDIDATE_CYCLE;
    static final Object CYCLE_CONFIRMED;
    public static final Module MODULE;
    static final ThreadLocal<Object[]> pendingHolder;

    public static void detectCycle(Object value) {
        Object pending;
        Object[] holder;
        if (null != CYCLE_ACTIVATOR && Scopes.isCircularProxy((Object)value) && null != (holder = pendingHolder.get()) && CANDIDATE_CYCLE.equals(pending = holder[0])) {
            holder[0] = CYCLE_CONFIRMED;
        }
    }

    public final void schedule(Object bean) {
        Object[] holder;
        if (null != CYCLE_ACTIVATOR && null != (holder = pendingHolder.get())) {
            Object pending = holder[0];
            if (CYCLE_CONFIRMED.equals(pending)) {
                holder[0] = new Pending(bean);
                return;
            }
            if (pending instanceof Pending) {
                ((Pending)pending).add(bean);
                return;
            }
        }
        this.activate(bean);
    }

    protected abstract void activate(Object var1);

    static {
        CycleActivator cycleActivator;
        Object candidateCycle = new Object();
        Object cycleConfirmed = new Object();
        try {
            Binder.class.getMethod("bindListener", Matcher.class, ProvisionListener[].class);
            String detectCycles = System.getProperty("sisu.detect.cycles");
            cycleActivator = "false".equalsIgnoreCase(detectCycles) ? null : new CycleActivator();
            if ("pessimistic".equalsIgnoreCase(detectCycles)) {
                candidateCycle = cycleConfirmed;
            }
        }
        catch (Exception e) {
            cycleActivator = null;
        }
        catch (LinkageError e) {
            cycleActivator = null;
        }
        CYCLE_ACTIVATOR = cycleActivator;
        CANDIDATE_CYCLE = candidateCycle;
        CYCLE_CONFIRMED = cycleConfirmed;
        MODULE = new Module(){

            public void configure(Binder binder) {
                if (null != CYCLE_ACTIVATOR) {
                    binder.bindListener(Matchers.any(), new ProvisionListener[]{(ProvisionListener)CYCLE_ACTIVATOR});
                }
            }
        };
        pendingHolder = new ThreadLocal();
    }

    private final class Pending
    extends ArrayList<Object> {
        Pending(Object bean) {
            this.add(bean);
        }

        public void activate() {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                $BeanScheduler.this.activate(this.get(i));
            }
        }
    }

    static final class CycleActivator
    implements ProvisionListener {
        private static final BindingScopingVisitor<Boolean> IS_SCOPED = new DefaultBindingScopingVisitor<Boolean>(){

            public Boolean visitNoScoping() {
                return Boolean.FALSE;
            }

            protected Boolean visitOther() {
                return Boolean.TRUE;
            }
        };

        CycleActivator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> pi) {
            if (Boolean.TRUE.equals(pi.getBinding().acceptScopingVisitor(IS_SCOPED))) {
                Object[] holder = pendingHolder.get();
                if (null == holder) {
                    holder = new Object[1];
                    pendingHolder.set(holder);
                }
                if (null == holder[0]) {
                    Object pending;
                    holder[0] = CANDIDATE_CYCLE;
                    try {
                        pi.provision();
                    }
                    finally {
                        pending = holder[0];
                        holder[0] = null;
                    }
                    if (pending instanceof Pending) {
                        ((Pending)pending).activate();
                    }
                }
            }
        }
    }
}

