/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.aether.named.support;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class $Retry {
    private static final Logger LOGGER = LoggerFactory.getLogger($Retry.class);

    private $Retry() {
    }

    public static <R> R retry(long time, TimeUnit unit, long sleepMillis, Callable<R> operation, Predicate<Exception> retryPredicate, R defaultResult) throws InterruptedException {
        long now = System.nanoTime();
        long barrier = now + unit.toNanos(time);
        int attempt = 1;
        Object result = null;
        while (now < barrier && result == null) {
            block7: {
                try {
                    result = operation.call();
                    if (result == null) {
                        LOGGER.trace("Retry attempt {}: no result", (Object)attempt);
                        Thread.sleep(sleepMillis);
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.trace("Retry attempt {}: operation failure", (Object)attempt, (Object)e);
                    if (e instanceof DoNotRetry) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new IllegalStateException(e);
                    }
                    if (retryPredicate == null || retryPredicate.test(e)) break block7;
                    throw new IllegalStateException(e);
                }
            }
            now = System.nanoTime();
            ++attempt;
        }
        return (R)(result == null ? defaultResult : result);
    }

    public static <R> R retry(int attempts, long sleepMillis, Callable<R> operation, Predicate<Exception> retryPredicate, R defaultResult) throws InterruptedException {
        Object result = null;
        for (int attempt = 1; attempt <= attempts && result == null; ++attempt) {
            try {
                result = operation.call();
                if (result != null) continue;
                LOGGER.trace("Retry attempt {}: no result", (Object)attempt);
                Thread.sleep(sleepMillis);
                continue;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.trace("Retry attempt {}: operation failure", (Object)attempt, (Object)e);
                if (e instanceof DoNotRetry) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
                if (retryPredicate == null || retryPredicate.test(e)) continue;
                throw new IllegalStateException(e);
            }
        }
        return (R)(result == null ? defaultResult : result);
    }

    public static interface DoNotRetry {
    }
}

