/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven;

import de.softwareforge.testing.maven.MavenVersionMatchBuilder;
import de.softwareforge.testing.maven.VersionStrategy;
import de.softwareforge.testing.maven.org.apache.maven.repository.internal.$MavenRepositorySystemUtils;
import de.softwareforge.testing.maven.org.apache.maven.settings.$Profile;
import de.softwareforge.testing.maven.org.apache.maven.settings.$Repository;
import de.softwareforge.testing.maven.org.apache.maven.settings.$Settings;
import de.softwareforge.testing.maven.org.apache.maven.settings.building.$DefaultSettingsBuilder;
import de.softwareforge.testing.maven.org.apache.maven.settings.building.$DefaultSettingsBuilderFactory;
import de.softwareforge.testing.maven.org.apache.maven.settings.building.$DefaultSettingsBuildingRequest;
import de.softwareforge.testing.maven.org.apache.maven.settings.building.$SettingsBuildingException;
import de.softwareforge.testing.maven.org.apache.maven.settings.building.$SettingsBuildingResult;
import de.softwareforge.testing.maven.org.eclipse.aether.$DefaultRepositorySystemSession;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositoryException;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositorySystem;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositorySystemSession;
import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$Artifact;
import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$DefaultArtifact;
import de.softwareforge.testing.maven.org.eclipse.aether.connector.basic.;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$DefaultServiceLocator;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$LocalRepository;
import de.softwareforge.testing.maven.org.eclipse.aether.resolution.$ArtifactRequest;
import de.softwareforge.testing.maven.org.eclipse.aether.resolution.$ArtifactResult;
import de.softwareforge.testing.maven.org.eclipse.aether.resolution.$VersionRangeRequest;
import de.softwareforge.testing.maven.org.eclipse.aether.resolution.$VersionRangeResolutionException;
import de.softwareforge.testing.maven.org.eclipse.aether.resolution.$VersionRangeResult;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.transport.;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.locator.$ServiceLocator;
import de.softwareforge.testing.maven.org.eclipse.aether.transport.file.;
import de.softwareforge.testing.maven.org.eclipse.aether.transport.http.;
import de.softwareforge.testing.maven.org.eclipse.aether.version.$Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenArtifactLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MavenArtifactLoader.class);
    static final .RemoteRepository CENTRAL_REPO = new .RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2/").build();
    private static final String USER_HOME = System.getProperty("user.home");
    private static final File USER_MAVEN_HOME = new File(USER_HOME, ".m2");
    private static final String ENV_M2_HOME = System.getenv("M2_HOME");
    private static final File DEFAULT_USER_SETTINGS_FILE = new File(USER_MAVEN_HOME, "settings.xml");
    private static final File DEFAULT_USER_REPOSITORY = new File(USER_MAVEN_HOME, "repository");
    private static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", Objects.requireNonNullElse(ENV_M2_HOME, "")), "conf/settings.xml");
    private final $RepositorySystem repositorySystem;
    private final $RepositorySystemSession mavenSession;
    private final List<.RemoteRepository> remoteRepositories;
    private final String extension;

    public MavenArtifactLoader() {
        this("jar");
    }

    public MavenArtifactLoader(String extension) {
        this(extension, null);
    }

    MavenArtifactLoader(String extension, List<.RemoteRepository> remoteRepositoriesForTesting) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
        $ServiceLocator serviceLocator = MavenArtifactLoader.createServiceLocator();
        this.repositorySystem = serviceLocator.getService($RepositorySystem.class);
        try {
            $Settings settings = MavenArtifactLoader.createSettings();
            File localRepositoryLocation = settings.getLocalRepository() != null ? new File(settings.getLocalRepository()) : DEFAULT_USER_REPOSITORY;
            $LocalRepository localRepository = new $LocalRepository(localRepositoryLocation);
            this.remoteRepositories = remoteRepositoriesForTesting != null ? remoteRepositoriesForTesting : MavenArtifactLoader.extractRemoteRepositories(settings);
            $DefaultRepositorySystemSession mavenSession = $MavenRepositorySystemUtils.newSession();
            this.mavenSession = mavenSession.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager(mavenSession, localRepository));
        }
        catch ($SettingsBuildingException e) {
            throw new IllegalStateException("Could not load maven settings:", e);
        }
    }

    public MavenVersionMatchBuilder builder(String groupId, String artifactId) {
        Objects.requireNonNull(groupId, "groupId is null");
        Objects.requireNonNull(artifactId, "artifactId is null");
        return new MavenVersionMatchBuilder(this, groupId, artifactId);
    }

    public File getArtifactFile(String groupId, String artifactId, String version) throws IOException {
        Objects.requireNonNull(groupId, "groupId is null");
        Objects.requireNonNull(artifactId, "artifactId is null");
        Objects.requireNonNull(version, "version is null");
        $ArtifactRequest artifactRequest = new $ArtifactRequest();
        artifactRequest.setArtifact(new $DefaultArtifact(groupId, artifactId, this.extension, version));
        artifactRequest.setRepositories(this.remoteRepositories);
        try {
            $ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.mavenSession, artifactRequest);
            $Artifact artifact = artifactResult.getArtifact();
            return artifact.getFile();
        }
        catch ($RepositoryException e) {
            throw new IOException(e);
        }
    }

    public String findLatestVersion(String groupId, String artifactId, String version) throws IOException {
        Objects.requireNonNull(groupId, "groupId is null");
        Objects.requireNonNull(artifactId, "artifactId is null");
        Objects.requireNonNull(version, "version is null");
        return this.builder(groupId, artifactId).partialMatch(version).extension(this.extension).includeSnapshots(true).findBestMatch().orElseThrow(() -> new IOException(String.format("No suitable candidate for %s:%s:%s found!", groupId, artifactId, version)));
    }

    SortedSet<$Version> findAllVersions(MavenVersionMatchBuilder builder) throws IOException {
        $DefaultArtifact artifact = new $DefaultArtifact(builder.groupId(), builder.artifactId(), builder.extension(), "[0,)");
        $VersionRangeRequest rangeRequest = new $VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.remoteRepositories);
        try {
            $VersionRangeResult rangeResult = this.repositorySystem.resolveVersionRange(this.mavenSession, rangeRequest);
            TreeSet<$Version> resultBuilder = new TreeSet<$Version>();
            List<$Version> artifactVersions = rangeResult.getVersions();
            VersionStrategy versionStrategy = builder.versionStrategy();
            if (artifactVersions != null) {
                for ($Version artifactVersion : artifactVersions) {
                    boolean isSnapshot = artifactVersion.toString().endsWith("-SNAPSHOT");
                    boolean match = versionStrategy.matchVersion(artifactVersion);
                    if (isSnapshot) {
                        match &= builder.includeSnapshots();
                    }
                    if (!match) continue;
                    resultBuilder.add(artifactVersion);
                }
            }
            return Collections.unmodifiableSortedSet(resultBuilder);
        }
        catch ($VersionRangeResolutionException e) {
            throw new IOException(String.format("Could not resolve version range: %s", rangeRequest), e);
        }
    }

    private static $ServiceLocator createServiceLocator() {
        $DefaultServiceLocator locator = $MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(.RepositoryConnectorFactory.class, .BasicRepositoryConnectorFactory.class);
        locator.addService(.TransporterFactory.class, .FileTransporterFactory.class);
        locator.addService(.TransporterFactory.class, .HttpTransporterFactory.class);
        locator.setErrorHandler(new $DefaultServiceLocator.ErrorHandler(){

            @Override
            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable e) {
                LOG.error(String.format("Could not create instance of %s (implementation %s): ", type.getSimpleName(), impl.getSimpleName()), e);
            }
        });
        return locator;
    }

    private static $Settings createSettings() throws $SettingsBuildingException {
        $DefaultSettingsBuildingRequest settingsBuildingRequest = new $DefaultSettingsBuildingRequest().setSystemProperties(System.getProperties()).setUserSettingsFile(DEFAULT_USER_SETTINGS_FILE).setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        $DefaultSettingsBuilderFactory settingBuilderFactory = new $DefaultSettingsBuilderFactory();
        $DefaultSettingsBuilder settingsBuilder = settingBuilderFactory.newInstance();
        $SettingsBuildingResult settingsBuildingResult = settingsBuilder.build(settingsBuildingRequest);
        return settingsBuildingResult.getEffectiveSettings();
    }

    private static List<.RemoteRepository> extractRemoteRepositories($Settings settings) {
        Map<String, $Profile> profiles = settings.getProfilesAsMap();
        ArrayList<.RemoteRepository> builder = new ArrayList<.RemoteRepository>();
        boolean foundRepository = false;
        for (String profileName : settings.getActiveProfiles()) {
            List<$Repository> repositories;
            $Profile profile = profiles.get(profileName);
            if (profile == null || (repositories = profile.getRepositories()) == null) continue;
            for ($Repository repo : repositories) {
                builder.add(new .RemoteRepository.Builder(repo.getId(), "default", repo.getUrl()).build());
                foundRepository = true;
            }
        }
        if (!foundRepository && !settings.isOffline()) {
            builder.add(CENTRAL_REPO);
        }
        return Collections.unmodifiableList(builder);
    }
}

