/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.ServerOptions;
import com.dumbster.smtp.SmtpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SmtpServerFactory.class);

    public static SmtpServer startServer() {
        ServerOptions serverOptions = new ServerOptions();
        return SmtpServerFactory.startServer(serverOptions);
    }

    public static SmtpServer startServer(ServerOptions options) {
        SmtpServer server = SmtpServerFactory.wireUpServer(options);
        SmtpServerFactory.wrapInShutdownHook(server);
        SmtpServerFactory.startServerThread(server);
        LOG.info(String.format("Dumbster SMTP Server started on port '%d'.", options.getPort()));
        return server;
    }

    private static SmtpServer wireUpServer(ServerOptions options) {
        SmtpServer server = new SmtpServer(options);
        return server;
    }

    private static void wrapInShutdownHook(final SmtpServer server) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    server.stop();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                LOG.info("Dumbster SMTP Server stopped.");
                LOG.info(String.format("\t%d messages received.", server.getEmailCount()));
            }
        });
    }

    private static void startServerThread(SmtpServer server) {
        Thread serverThread = new Thread(server);
        serverThread.setName(String.format("Dumbster-SMTP-Server @ %d", server.getPort()));
        serverThread.start();
        int timeout = 1000;
        while (!server.isRunning()) {
            try {
                Thread.sleep(1L);
                if (timeout <= 0 || --timeout >= 1) continue;
                throw new IllegalStateException("Server could not be started.");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

