/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.ClientSession;
import com.dumbster.smtp.MailMessage;
import com.dumbster.smtp.MailStore;
import com.dumbster.smtp.ServerOptions;
import com.dumbster.smtp.SocketWrapper;
import com.dumbster.smtp.TimedClientSession;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpServer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SmtpServer.class);
    private static final int SERVER_SOCKET_TIMEOUT = 10;
    private static final int MAX_THREADS = 10;
    private volatile boolean running = false;
    private volatile boolean stopped = true;
    private volatile Thread serverThread = null;
    private final int port;
    private final MailStore mailStore;
    private final boolean threaded;
    private final int waitInResponse;

    public SmtpServer(ServerOptions serverOptions) {
        Objects.requireNonNull(serverOptions, "serverOptions is null");
        this.port = serverOptions.getPort();
        this.mailStore = serverOptions.getMailStore();
        this.threaded = serverOptions.isThreaded();
        this.waitInResponse = serverOptions.getWaitInResponse();
    }

    @Override
    public void run() {
        this.serverThread = Thread.currentThread();
        try (ServerSocket serverSocket = new ServerSocket(this.port);){
            serverSocket.setSoTimeout(10);
            this.serverLoop(serverSocket);
        }
        catch (IOException e) {
            LOG.warn("Server Loop terminated: ", (Throwable)e);
        }
    }

    private void serverLoop(ServerSocket serverSocket) throws IOException {
        final String serverThreadName = Thread.currentThread().getName();
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger threadId = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread serviceThread = new Thread(r);
                serviceThread.setDaemon(true);
                serviceThread.setName(serverThreadName + "-" + this.threadId.getAndIncrement());
                return serviceThread;
            }
        };
        ExecutorService executorService = this.threaded ? Executors.newFixedThreadPool(10, threadFactory) : Executors.newSingleThreadExecutor(threadFactory);
        this.running = true;
        this.stopped = false;
        do {
            try {
                Socket clientSocket = serverSocket.accept();
                SocketWrapper source = new SocketWrapper(clientSocket);
                ClientSession session = this.waitInResponse == 0 ? new ClientSession(source, this.mailStore) : new TimedClientSession(source, this.mailStore, this.waitInResponse);
                executorService.execute(session);
            }
            catch (SocketTimeoutException e) {
                LOG.trace("Tick ...");
            }
            catch (IOException e) {
                if (!this.isRunning()) continue;
                LOG.warn("In accept loop: ", (Throwable)e);
            }
        } while (this.isRunning());
        executorService.shutdown();
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void stop() throws InterruptedException {
        this.running = false;
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
        this.serverThread.join();
    }

    public MailMessage[] getMessages() {
        return this.mailStore.getMessages();
    }

    public MailMessage getMessage(int i) {
        return this.mailStore.getMessage(i);
    }

    public int getEmailCount() {
        return this.mailStore.getEmailCount();
    }

    public void anticipateMessageCountFor(int messageCount, int ticks) {
        for (int tickdown = ticks; this.mailStore.getEmailCount() < messageCount && tickdown > 0; --tickdown) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public void clearMessages() {
        this.mailStore.clearMessages();
    }

    public int getPort() {
        return this.port;
    }
}

