/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.IOSource;
import com.dumbster.smtp.MailMessage;
import com.dumbster.smtp.MailMessageImpl;
import com.dumbster.smtp.MailStore;
import com.dumbster.smtp.Request;
import com.dumbster.smtp.Response;
import com.dumbster.smtp.SmtpState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSession
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSession.class);
    private IOSource socket;
    private volatile MailStore mailStore;
    private MailMessage msg;
    private Response smtpResponse;
    private PrintWriter out;
    private BufferedReader input;
    private SmtpState smtpState;
    private String line;
    private String lastHeaderName = null;
    private volatile boolean running = true;

    protected ClientSession(IOSource socket, MailStore mailStore) {
        this.socket = socket;
        this.mailStore = mailStore;
        this.msg = new MailMessageImpl();
        Request request = Request.initialRequest();
        this.smtpResponse = request.execute(this.mailStore, this.msg);
    }

    @Override
    public void run() {
        do {
            try {
                this.prepareSessionLoop();
                this.sessionLoop();
                this.running = false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.running = false;
            }
            catch (IOException e) {
                LOG.warn("Caught IO Exception", (Throwable)e);
            }
        } while (this.running);
        try {
            this.socket.close();
        }
        catch (Exception e) {
            LOG.debug("While closing socket", (Throwable)e);
        }
    }

    public void stop() {
        this.running = false;
    }

    protected void doWaitInResponse() throws InterruptedException {
    }

    protected boolean prepareSessionLoop() throws IOException, InterruptedException {
        this.prepareOutput();
        this.prepareInput();
        this.sendResponse();
        this.updateSmtpState();
        return true;
    }

    private void prepareOutput() throws IOException {
        this.out = this.socket.getOutputStream();
        this.out.flush();
    }

    private void prepareInput() throws IOException {
        this.input = this.socket.getInputStream();
    }

    private void sendResponse() throws InterruptedException {
        if (this.smtpResponse.getCode() > 0) {
            this.doWaitInResponse();
            int code = this.smtpResponse.getCode();
            String message = this.smtpResponse.getMessage();
            this.out.print(code + " " + message + "\r\n");
            this.out.flush();
        }
    }

    private void updateSmtpState() {
        this.smtpState = this.smtpResponse.getNextState();
    }

    protected void sessionLoop() throws IOException, InterruptedException {
        while (this.smtpState != SmtpState.CONNECT && this.readNextLineReady()) {
            Request request = Request.createRequest(this.smtpState, this.line);
            this.smtpResponse = request.execute(this.mailStore, this.msg);
            this.storeInputInMessage(request);
            this.sendResponse();
            this.updateSmtpState();
            this.saveAndRefreshMessageIfComplete();
        }
    }

    private boolean readNextLineReady() throws IOException {
        this.readLine();
        return this.line != null;
    }

    private void readLine() throws IOException {
        this.line = this.input.readLine();
    }

    private void saveAndRefreshMessageIfComplete() {
        if (this.smtpState == SmtpState.QUIT) {
            this.mailStore.addMessage(this.msg);
            this.msg = new MailMessageImpl();
        }
    }

    private void storeInputInMessage(Request request) {
        String params = request.getParams();
        if (null == params) {
            return;
        }
        if (SmtpState.DATA_HDR.equals((Object)this.smtpResponse.getNextState())) {
            this.addDataHeader(params);
            return;
        }
        if (SmtpState.DATA_BODY == this.smtpResponse.getNextState()) {
            this.msg.appendBody(params);
            return;
        }
    }

    private void addDataHeader(String params) {
        int headerNameEnd = params.indexOf(58);
        if (headerNameEnd > 0 && !this.whiteSpacedLineStart(params)) {
            this.lastHeaderName = params.substring(0, headerNameEnd).trim();
            String value = params.substring(headerNameEnd + 1).trim();
            this.msg.addHeader(this.lastHeaderName, value);
        } else if (this.whiteSpacedLineStart(params) && this.lastHeaderName != null) {
            this.msg.appendHeader(this.lastHeaderName, params);
        }
    }

    private boolean whiteSpacedLineStart(String s) {
        if (s == null || "".equals(s)) {
            return false;
        }
        char c = s.charAt(0);
        return c == ' ' || c == '\u000b' || c == '\n' || c == '\r' || c == '\t' || c == '\f';
    }
}

