/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.semantic;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 6034927062401119911L;
    private static final String[] EMPTY_ARRAY = new String[0];
    public static final Version COMPLIANCE = Version.create(2, 0, 0);
    public static final Comparator<Version> NATURAL_ORDER = new Comparator<Version>(){

        @Override
        public int compare(Version o1, Version o2) {
            return Version.compare(o1, o2);
        }
    };
    public static final Comparator<Version> WITH_BUILD_META_DATA_ORDER = new Comparator<Version>(){

        @Override
        public int compare(Version o1, Version o2) {
            return Version.compareWithBuildMetaData(o1, o2);
        }
    };
    private static final int TO_STRING_ESTIMATE = 16;
    private static final int HASH_PRIME = 31;
    private static final int STATE_MAJOR_INIT = 0;
    private static final int STATE_MAJOR_LEADING_ZERO = 1;
    private static final int STATE_MAJOR_DEFAULT = 2;
    private static final int STATE_MINOR_INIT = 3;
    private static final int STATE_MINOR_LEADING_ZERO = 4;
    private static final int STATE_MINOR_DEFAULT = 5;
    private static final int STATE_PATCH_INIT = 6;
    private static final int STATE_PATCH_LEADING_ZERO = 7;
    private static final int STATE_PATCH_DEFAULT = 8;
    private static final int STATE_PRERELEASE_INIT = 9;
    private static final int STATE_BUILDMD_INIT = 10;
    private static final int STATE_PART_INIT = 0;
    private static final int STATE_PART_LEADING_ZERO = 1;
    private static final int STATE_PART_NUMERIC = 2;
    private static final int STATE_PART_DEFAULT = 3;
    private static final int DECIMAL = 10;
    private static final int EOS = -1;
    private static final int FAILURE = -2;
    private final int major;
    private final int minor;
    private final int patch;
    private final String[] preReleaseParts;
    private final String[] buildMetaDataParts;
    @Deprecated
    private String preRelease;
    @Deprecated
    private String buildMetaData;
    private volatile int hash;

    private Version(int major, int minor, int patch, String[] preRelease, String[] buildMd) {
        Version.checkParams(major, minor, patch);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preReleaseParts = preRelease;
        this.buildMetaDataParts = buildMd;
    }

    private static Version parse(String s, boolean verifyOnly) {
        char[] stream = s.toCharArray();
        int major = 0;
        int minor = 0;
        int patch = 0;
        int state = 0;
        List preRelease = null;
        List buildMd = null;
        block13: for (int i = 0; i <= stream.length; ++i) {
            int c = i < stream.length ? stream[i] : -1;
            switch (state) {
                case 0: {
                    if (c == 48) {
                        state = 1;
                        continue block13;
                    }
                    if (c >= 49 && c <= 57) {
                        major = major * 10 + Character.digit(c, 10);
                        state = 2;
                        continue block13;
                    }
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 1: {
                    if (c == 46) {
                        state = 3;
                        continue block13;
                    }
                    if (c >= 48 && c <= 57) {
                        if (verifyOnly) {
                            return null;
                        }
                        throw Version.illegalLeadingChar(s, 48, "major");
                    }
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 2: {
                    if (c >= 48 && c <= 57) {
                        major = major * 10 + Character.digit(c, 10);
                        continue block13;
                    }
                    if (c == 46) {
                        state = 3;
                        continue block13;
                    }
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 3: {
                    if (c == 48) {
                        state = 4;
                        continue block13;
                    }
                    if (c >= 49 && c <= 57) {
                        minor = minor * 10 + Character.digit(c, 10);
                        state = 5;
                        continue block13;
                    }
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 4: {
                    if (c == 46) {
                        state = 6;
                        continue block13;
                    }
                    if (c >= 48 && c <= 57) {
                        if (verifyOnly) {
                            return null;
                        }
                        throw Version.illegalLeadingChar(s, 48, "minor");
                    }
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 5: {
                    if (c >= 48 && c <= 57) {
                        minor = minor * 10 + Character.digit(c, 10);
                        continue block13;
                    }
                    if (c == 46) {
                        state = 6;
                        continue block13;
                    }
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 6: {
                    if (c == 48) {
                        state = 7;
                        continue block13;
                    }
                    if (c >= 49 && c <= 57) {
                        patch = patch * 10 + Character.digit(c, 10);
                        state = 8;
                        continue block13;
                    }
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 7: {
                    if (c == 45) {
                        state = 9;
                        continue block13;
                    }
                    if (c == 43) {
                        state = 10;
                        continue block13;
                    }
                    if (c == -1) break block13;
                    if (c >= 48 && c <= 57) {
                        if (verifyOnly) {
                            return null;
                        }
                        throw Version.illegalLeadingChar(s, 48, "patch");
                    }
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 8: {
                    if (c >= 48 && c <= 57) {
                        patch = patch * 10 + Character.digit(c, 10);
                        continue block13;
                    }
                    if (c == 45) {
                        state = 9;
                        continue block13;
                    }
                    if (c == 43) {
                        state = 10;
                        continue block13;
                    }
                    if (c == -1) continue block13;
                    if (verifyOnly) {
                        return null;
                    }
                    throw Version.unexpectedChar(s, c);
                }
                case 9: {
                    int c1;
                    preRelease = verifyOnly ? null : new ArrayList();
                    i = Version.parseID(stream, s, i, verifyOnly, false, true, preRelease, "pre-release");
                    if (i == -2) {
                        return null;
                    }
                    int n = c1 = i < stream.length ? stream[i] : -1;
                    if (c1 != 43) break block13;
                    state = 10;
                    continue block13;
                }
                case 10: {
                    buildMd = verifyOnly ? null : new ArrayList();
                    i = Version.parseID(stream, s, i, verifyOnly, true, false, buildMd, "build-meta-data");
                    if (i != -2) break block13;
                    return null;
                }
                default: {
                    throw new IllegalStateException("Illegal state: " + state);
                }
            }
        }
        String[] prerelease = preRelease == null ? EMPTY_ARRAY : preRelease.toArray(new String[preRelease.size()]);
        String[] buildmetadata = buildMd == null ? EMPTY_ARRAY : buildMd.toArray(new String[buildMd.size()]);
        return new Version(major, minor, patch, prerelease, buildmetadata);
    }

    private static int parseID(char[] stream, String full, int start, boolean verifyOnly, boolean allowLeading0, boolean preRelease, List<String> parts, String partName) {
        assert (verifyOnly || parts != null);
        StringBuilder b = verifyOnly ? null : new StringBuilder(stream.length - start);
        for (int i = start; i <= stream.length; ++i) {
            int c;
            if ((i = Version.parseIDPart(stream, full, i, verifyOnly, allowLeading0, preRelease, true, b, partName)) == -2) {
                return -2;
            }
            if (!verifyOnly) {
                parts.add(b.toString());
            }
            int n = c = i < stream.length ? stream[i] : -1;
            if (c == 46) {
                continue;
            }
            return i;
        }
        throw new IllegalStateException();
    }

    private static int parseIDPart(char[] stream, String full, int start, boolean verifyOnly, boolean allowLeading0, boolean preRelease, boolean allowDot, StringBuilder b, String partName) {
        if (b != null) {
            b.setLength(0);
        }
        int state = 0;
        block6: for (int i = start; i <= stream.length; ++i) {
            int c = i < stream.length ? stream[i] : -1;
            switch (state) {
                case 0: {
                    if (c == 48 && !allowLeading0) {
                        state = 1;
                        if (b == null) continue block6;
                        b.append('0');
                        continue block6;
                    }
                    if (c == 45 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57) {
                        if (b != null) {
                            b.appendCodePoint(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    if (c == 46) {
                        if (verifyOnly) {
                            return -2;
                        }
                        throw Version.unexpectedChar(full, -1);
                    }
                    if (verifyOnly) {
                        return -2;
                    }
                    throw Version.unexpectedChar(full, c);
                }
                case 1: {
                    if (c == 45 || c >= 97 && c <= 122 || c >= 65 && c <= 90) {
                        if (b != null) {
                            b.appendCodePoint(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    if (c >= 48 && c <= 57) {
                        if (b != null) {
                            b.appendCodePoint(c);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c == 46 && allowDot || c == -1 || c == 43 && preRelease) {
                        return i;
                    }
                    if (verifyOnly) {
                        return -2;
                    }
                    throw Version.unexpectedChar(full, c);
                }
                case 2: {
                    if (c == 45 || c >= 97 && c <= 122 || c >= 65 && c <= 90) {
                        if (b != null) {
                            b.appendCodePoint(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    if (c >= 48 && c <= 57) {
                        if (b == null) continue block6;
                        b.appendCodePoint(c);
                        continue block6;
                    }
                    if (c == 46 || c == -1 || c == 43 && preRelease) {
                        if (verifyOnly) {
                            return -2;
                        }
                        throw Version.illegalLeadingChar(full, 48, partName);
                    }
                    if (verifyOnly) {
                        return -2;
                    }
                    throw Version.unexpectedChar(full, c);
                }
                case 3: {
                    if (c == 45 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57) {
                        if (b == null) continue block6;
                        b.appendCodePoint(c);
                        continue block6;
                    }
                    if (c == 46 && allowDot || c == -1 || c == 43 && preRelease) {
                        return i;
                    }
                    if (verifyOnly) {
                        return -2;
                    }
                    throw Version.unexpectedChar(full, c);
                }
            }
        }
        throw new IllegalStateException();
    }

    private static VersionFormatException illegalLeadingChar(String v, int c, String part) {
        return new VersionFormatException(String.format("Illegal leading char '%c' in %s part of %s", c, part, v));
    }

    private static VersionFormatException unexpectedChar(String v, int c) {
        if (c == -1) {
            return new VersionFormatException(String.format("Incomplete version part in %s", v));
        }
        return new VersionFormatException(String.format("Unexpected char in %s: %c", v, c));
    }

    public Version withMajor(int newMajor) {
        return new Version(newMajor, this.minor, this.patch, this.preReleaseParts, this.buildMetaDataParts);
    }

    public Version withMinor(int newMinor) {
        return new Version(this.major, newMinor, this.patch, this.preReleaseParts, this.buildMetaDataParts);
    }

    public Version withPatch(int newPatch) {
        return new Version(this.major, this.minor, newPatch, this.preReleaseParts, this.buildMetaDataParts);
    }

    public Version withPreRelease(String newPreRelease) {
        Version.require(newPreRelease != null, "newPreRelease is null");
        String[] newPreReleaseParts = Version.parsePreRelease(newPreRelease);
        return new Version(this.major, this.minor, this.patch, newPreReleaseParts, this.buildMetaDataParts);
    }

    public Version withPreRelease(String[] newPreRelease) {
        Version.require(newPreRelease != null, "newPreRelease is null");
        String joined = Version.join(newPreRelease);
        String[] newPreReleaseParts = Version.parsePreRelease(joined);
        return new Version(this.major, this.minor, this.patch, newPreReleaseParts, this.buildMetaDataParts);
    }

    public Version withBuildMetaData(String newBuildMetaData) {
        Version.require(newBuildMetaData != null, "newBuildMetaData is null");
        String[] newBuildMdParts = Version.parseBuildMd(newBuildMetaData);
        return new Version(this.major, this.minor, this.patch, this.preReleaseParts, newBuildMdParts);
    }

    public Version withBuildMetaData(String[] newBuildMetaData) {
        Version.require(newBuildMetaData != null, "newBuildMetaData is null");
        String joined = Version.join(newBuildMetaData);
        String[] newBuildMdParts = Version.parseBuildMd(joined);
        return new Version(this.major, this.minor, this.patch, this.preReleaseParts, newBuildMdParts);
    }

    private String[] verifyAndCopyArray(String[] parts, boolean allowLeading0) {
        String[] result = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            Version.require(part != null, "version part is null");
            if (part.isEmpty()) {
                throw new VersionFormatException("Incomplete version part in " + Version.join(parts));
            }
            result[i] = part;
            Version.parseIDPart(part.toCharArray(), part, 0, false, allowLeading0, false, false, null, "pre-release");
        }
        return result;
    }

    public Version nextMajor() {
        return new Version(this.major + 1, 0, 0, EMPTY_ARRAY, EMPTY_ARRAY);
    }

    public Version nextMajor(String newPrelease) {
        Version.require(newPrelease != null, "newPreRelease is null");
        String[] preReleaseParts = Version.parsePreRelease(newPrelease);
        return new Version(this.major + 1, 0, 0, preReleaseParts, EMPTY_ARRAY);
    }

    public Version nextMajor(String[] newPrelease) {
        Version.require(newPrelease != null, "newPreRelease is null");
        String[] newPreReleaseParts = this.verifyAndCopyArray(newPrelease, false);
        return new Version(this.major + 1, 0, 0, newPreReleaseParts, EMPTY_ARRAY);
    }

    public Version nextMinor() {
        return new Version(this.major, this.minor + 1, 0, EMPTY_ARRAY, EMPTY_ARRAY);
    }

    public Version nextMinor(String newPrelease) {
        Version.require(newPrelease != null, "newPreRelease is null");
        String[] preReleaseParts = Version.parsePreRelease(newPrelease);
        return new Version(this.major, this.minor + 1, 0, preReleaseParts, EMPTY_ARRAY);
    }

    public Version nextMinor(String[] newPrelease) {
        Version.require(newPrelease != null, "newPreRelease is null");
        String[] newPreReleaseParts = this.verifyAndCopyArray(newPrelease, false);
        return new Version(this.major, this.minor + 1, 0, newPreReleaseParts, EMPTY_ARRAY);
    }

    public Version nextPatch() {
        return new Version(this.major, this.minor, this.patch + 1, EMPTY_ARRAY, EMPTY_ARRAY);
    }

    public Version nextPatch(String newPrelease) {
        Version.require(newPrelease != null, "newPreRelease is null");
        String[] preReleaseParts = Version.parsePreRelease(newPrelease);
        return new Version(this.major, this.minor, this.patch + 1, preReleaseParts, EMPTY_ARRAY);
    }

    public Version nextPatch(String[] newPrelease) {
        Version.require(newPrelease != null, "newPreRelease is null");
        String[] newPreReleaseParts = this.verifyAndCopyArray(newPrelease, false);
        return new Version(this.major, this.minor, this.patch + 1, newPreReleaseParts, EMPTY_ARRAY);
    }

    public Version nextPreRelease() {
        String[] newPreReleaseParts = this.incrementIdentifier(this.preReleaseParts);
        return new Version(this.major, this.minor, this.patch, newPreReleaseParts, EMPTY_ARRAY);
    }

    public Version nextBuildMetaData() {
        String[] newBuildMetaData = this.incrementIdentifier(this.buildMetaDataParts);
        return new Version(this.major, this.minor, this.patch, this.preReleaseParts, newBuildMetaData);
    }

    private String[] incrementIdentifier(String[] parts) {
        if (parts.length == 0) {
            return new String[]{"1"};
        }
        int lastIdx = parts.length - 1;
        String lastPart = parts[lastIdx];
        int num = Version.isNumeric(lastPart);
        int newLength = parts.length;
        if (num >= 0) {
            ++num;
        } else {
            ++newLength;
            num = 1;
        }
        String[] result = Arrays.copyOf(parts, newLength);
        result[newLength - 1] = String.valueOf(num);
        return result;
    }

    public static boolean isValidVersion(String version) {
        return version != null && !version.isEmpty() && Version.parse(version, true) != null;
    }

    public static boolean isValidPreRelease(String preRelease) {
        if (preRelease == null) {
            return false;
        }
        if (preRelease.isEmpty()) {
            return true;
        }
        return Version.parseID(preRelease.toCharArray(), preRelease, 0, true, false, false, null, "") != -2;
    }

    public static boolean isValidBuildMetaData(String buildMetaData) {
        if (buildMetaData == null) {
            return false;
        }
        if (buildMetaData.isEmpty()) {
            return true;
        }
        return Version.parseID(buildMetaData.toCharArray(), buildMetaData, 0, true, true, false, null, "") != -2;
    }

    public static Version max(Version v1, Version v2) {
        Version.require(v1 != null, "v1 is null");
        Version.require(v2 != null, "v2 is null");
        return Version.compare(v1, v2, false) < 0 ? v2 : v1;
    }

    public static Version min(Version v1, Version v2) {
        Version.require(v1 != null, "v1 is null");
        Version.require(v2 != null, "v2 is null");
        return Version.compare(v1, v2, false) <= 0 ? v1 : v2;
    }

    public static int compare(Version v1, Version v2) {
        if (v1 == null) {
            throw new NullPointerException("v1 is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is null");
        }
        return Version.compare(v1, v2, false);
    }

    public static int compareWithBuildMetaData(Version v1, Version v2) {
        if (v1 == null) {
            throw new NullPointerException("v1 is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is null");
        }
        return Version.compare(v1, v2, true);
    }

    private static int compare(Version v1, Version v2, boolean withBuildMetaData) {
        int result = 0;
        if (v1 != v2) {
            int mc = Version.compareInt(v1.major, v2.major);
            if (mc != 0) {
                result = mc;
            } else {
                int mm = Version.compareInt(v1.minor, v2.minor);
                if (mm != 0) {
                    result = mm;
                } else {
                    int mp = Version.compareInt(v1.patch, v2.patch);
                    if (mp != 0) {
                        result = mp;
                    } else {
                        int md;
                        int pr = Version.comparePreRelease(v1, v2);
                        if (pr != 0) {
                            result = pr;
                        } else if (withBuildMetaData && (md = Version.compareBuildMetaData(v1, v2)) != 0) {
                            result = md;
                        }
                    }
                }
            }
        }
        return result;
    }

    private static int compareInt(int a, int b) {
        return a - b;
    }

    private static int comparePreRelease(Version v1, Version v2) {
        return Version.compareLiterals(v1.preReleaseParts, v2.preReleaseParts);
    }

    private static int compareBuildMetaData(Version v1, Version v2) {
        return Version.compareLiterals(v1.buildMetaDataParts, v2.buildMetaDataParts);
    }

    private static int compareLiterals(String[] v1Literal, String[] v2Literal) {
        int result = v1Literal.length > 0 && v2Literal.length > 0 ? Version.compareIdentifiers(v1Literal, v2Literal) : (v1Literal.length > 0 ? -1 : (v2Literal.length > 0 ? 1 : 0));
        return result;
    }

    private static int compareIdentifiers(String[] parts1, String[] parts2) {
        int min = Math.min(parts1.length, parts2.length);
        for (int i = 0; i < min; ++i) {
            int r = Version.compareIdentifierParts(parts1[i], parts2[i]);
            if (r == 0) continue;
            return r;
        }
        return Version.compareInt(parts1.length, parts2.length);
    }

    private static int compareIdentifierParts(String p1, String p2) {
        int num1 = Version.isNumeric(p1);
        int num2 = Version.isNumeric(p2);
        int result = num1 < 0 && num2 < 0 ? p1.compareTo(p2) : (num1 >= 0 && num2 >= 0 ? Version.compareInt(num1, num2) : (num1 >= 0 ? -1 : 1));
        return result;
    }

    private static int isNumeric(String s) {
        char[] chars = s.toCharArray();
        int num = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < '0' || c > '9') {
                return -1;
            }
            num = num * 10 + Character.digit(c, 10);
        }
        return num;
    }

    private static String[] parsePreRelease(String preRelease) {
        if (preRelease != null && !preRelease.isEmpty()) {
            ArrayList<String> parts = new ArrayList<String>();
            Version.parseID(preRelease.toCharArray(), preRelease, 0, false, false, false, parts, "pre-release");
            return parts.toArray(new String[parts.size()]);
        }
        return EMPTY_ARRAY;
    }

    private static String[] parseBuildMd(String buildMetaData) {
        if (buildMetaData != null && !buildMetaData.isEmpty()) {
            ArrayList<String> parts = new ArrayList<String>();
            Version.parseID(buildMetaData.toCharArray(), buildMetaData, 0, false, true, false, parts, "build-meta-data");
            return parts.toArray(new String[parts.size()]);
        }
        return EMPTY_ARRAY;
    }

    private static final Version createInternal(int major, int minor, int patch, String preRelease, String buildMetaData) {
        String[] preReleaseParts = Version.parsePreRelease(preRelease);
        String[] buildMdParts = Version.parseBuildMd(buildMetaData);
        return new Version(major, minor, patch, preReleaseParts, buildMdParts);
    }

    public static final Version create(int major, int minor, int patch, String preRelease, String buildMetaData) {
        Version.require(preRelease != null, "preRelease is null");
        Version.require(buildMetaData != null, "buildMetaData is null");
        return Version.createInternal(major, minor, patch, preRelease, buildMetaData);
    }

    public static final Version create(int major, int minor, int patch, String preRelease) {
        return Version.create(major, minor, patch, preRelease, "");
    }

    public static final Version create(int major, int minor, int patch) {
        return new Version(major, minor, patch, EMPTY_ARRAY, EMPTY_ARRAY);
    }

    private static void checkParams(int major, int minor, int patch) {
        Version.require(major >= 0, "major < 0");
        Version.require(minor >= 0, "minor < 0");
        Version.require(patch >= 0, "patch < 0");
        Version.require(major != 0 || minor != 0 || patch != 0, "all parts are 0");
    }

    private static void require(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final Version parseVersion(String versionString) {
        Version.require(versionString != null, "versionString is null");
        return Version.parse(versionString, false);
    }

    public static Version parseVersion(String versionString, boolean allowPreRelease) {
        Version version = Version.parseVersion(versionString);
        if (!allowPreRelease && (version.isPreRelease() || version.hasBuildMetaData())) {
            throw new VersionFormatException(String.format("Version string '%s' is expected to have no pre-release or build meta data part", versionString));
        }
        return version;
    }

    public Version min(Version other) {
        return Version.min(this, other);
    }

    public Version max(Version other) {
        return Version.max(this, other);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String[] getPreReleaseParts() {
        if (this.preReleaseParts.length == 0) {
            return EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.preReleaseParts, this.preReleaseParts.length);
    }

    public String getPreRelease() {
        return Version.join(this.preReleaseParts);
    }

    public String getBuildMetaData() {
        return Version.join(this.buildMetaDataParts);
    }

    private static String join(String[] parts) {
        if (parts.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            b.append(part);
            if (i >= parts.length - 1) continue;
            b.append(".");
        }
        return b.toString();
    }

    public String[] getBuildMetaDataParts() {
        if (this.buildMetaDataParts.length == 0) {
            return EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.buildMetaDataParts, this.buildMetaDataParts.length);
    }

    public boolean isInitialDevelopment() {
        return this.major == 0;
    }

    public boolean isPreRelease() {
        return this.preReleaseParts.length > 0;
    }

    public boolean hasBuildMetaData() {
        return this.buildMetaDataParts.length > 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(16);
        b.append(this.major).append(".").append(this.minor).append(".").append(this.patch);
        if (this.isPreRelease()) {
            b.append("-").append(this.getPreRelease());
        }
        if (this.hasBuildMetaData()) {
            b.append("+").append(this.getBuildMetaData());
        }
        return b.toString();
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 31 + this.major;
            h = 31 * h + this.minor;
            h = 31 * h + this.patch;
            this.hash = h = 31 * h + Arrays.hashCode(this.preReleaseParts);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        return this.testEquality(obj, false);
    }

    public boolean equalsWithBuildMetaData(Object obj) {
        return this.testEquality(obj, true);
    }

    private boolean testEquality(Object obj, boolean includeBuildMd) {
        return obj == this || obj instanceof Version && Version.compare(this, (Version)obj, includeBuildMd) == 0;
    }

    @Override
    public int compareTo(Version other) {
        return Version.compare(this, other);
    }

    public int compareToWithBuildMetaData(Version other) {
        return Version.compareWithBuildMetaData(this, other);
    }

    public Version toUpperCase() {
        return new Version(this.major, this.minor, this.patch, Version.copyCase(this.preReleaseParts, true), Version.copyCase(this.buildMetaDataParts, true));
    }

    public Version toLowerCase() {
        return new Version(this.major, this.minor, this.patch, Version.copyCase(this.preReleaseParts, false), Version.copyCase(this.buildMetaDataParts, false));
    }

    private static String[] copyCase(String[] source, boolean toUpper) {
        String[] result = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            String string = source[i];
            result[i] = toUpper ? string.toUpperCase() : string.toLowerCase();
        }
        return result;
    }

    public boolean isGreaterThan(Version other) {
        Version.require(other != null, "other must no be null");
        return this.compareTo(other) > 0;
    }

    public boolean isLowerThan(Version other) {
        Version.require(other != null, "other must no be null");
        return this.compareTo(other) < 0;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.preRelease != null || this.buildMetaData != null) {
            return Version.createInternal(this.major, this.minor, this.patch, this.preRelease, this.buildMetaData);
        }
        return this;
    }

    public static class VersionFormatException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private VersionFormatException(String message) {
            super(message);
        }
    }
}

