/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.semantic;

import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 6034927062401119911L;
    public static final Version COMPLIANCE = Version.create(2, 0, 0);
    public static final Comparator<Version> NATURAL_ORDER = new Comparator<Version>(){

        @Override
        public int compare(Version o1, Version o2) {
            return Version.compare(o1, o2);
        }
    };
    public static final Comparator<Version> WITH_BUILD_META_DATA_ORDER = new Comparator<Version>(){

        @Override
        public int compare(Version o1, Version o2) {
            return Version.compareWithBuildMetaData(o1, o2);
        }
    };
    private static final Pattern PRE_RELEASE = Pattern.compile("(?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0)(?:\\.(?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0))*");
    private static final Pattern BUILD_MD = Pattern.compile("[\\w-]+(\\.[\\w-]+)*");
    private static final Pattern VERSION_PATTERN = Pattern.compile("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0)(?:\\.(?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0))*))?(?:\\+([\\w-]+(\\.[\\w-]+)*))?");
    private static final int MAJOR_GROUP = 1;
    private static final int MINOR_GROUP = 2;
    private static final int PATCH_GROUP = 3;
    private static final int PRE_RELEASE_GROUP = 4;
    private static final int BUILD_MD_GROUP = 5;
    private static final int TO_STRING_ESTIMATE = 24;
    private static final int HASH_PRIME = 31;
    private final int major;
    private final int minor;
    private final int patch;
    private final String preRelease;
    private final String buildMetaData;
    private volatile int hash;

    private Version(int major, int minor, int patch, String preRelease, String buildMd) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.buildMetaData = buildMd;
    }

    public static boolean isValidVersion(String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        return VERSION_PATTERN.matcher(version).matches();
    }

    public static boolean isValidPreRelease(String preRelease) {
        return preRelease != null && (preRelease.isEmpty() || PRE_RELEASE.matcher(preRelease).matches());
    }

    public static boolean isValidBuildMetaData(String buildMetaData) {
        return buildMetaData != null && (buildMetaData.isEmpty() || BUILD_MD.matcher(buildMetaData).matches());
    }

    public static Version max(Version v1, Version v2) {
        Version.require(v1 != null, "v1 is null");
        Version.require(v2 != null, "v2 is null");
        return Version.compare(v1, v2, false) < 0 ? v2 : v1;
    }

    public static Version min(Version v1, Version v2) {
        Version.require(v1 != null, "v1 is null");
        Version.require(v2 != null, "v2 is null");
        return Version.compare(v1, v2, false) <= 0 ? v1 : v2;
    }

    public static int compare(Version v1, Version v2) {
        if (v1 == null) {
            throw new NullPointerException("v1 is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is null");
        }
        return Version.compare(v1, v2, false);
    }

    public static int compareWithBuildMetaData(Version v1, Version v2) {
        if (v1 == null) {
            throw new NullPointerException("v1 is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is null");
        }
        return Version.compare(v1, v2, true);
    }

    private static int compare(Version v1, Version v2, boolean withBuildMetaData) {
        int result = 0;
        if (v1 != v2) {
            int mc = Version.compareInt(v1.major, v2.major);
            if (mc != 0) {
                result = mc;
            } else {
                int mm = Version.compareInt(v1.minor, v2.minor);
                if (mm != 0) {
                    result = mm;
                } else {
                    int mp = Version.compareInt(v1.patch, v2.patch);
                    if (mp != 0) {
                        result = mp;
                    } else {
                        int md;
                        int pr = Version.comparePreRelease(v1, v2);
                        if (pr != 0) {
                            result = pr;
                        } else if (withBuildMetaData && (md = Version.compareBuildMetaData(v1, v2)) != 0) {
                            result = md;
                        }
                    }
                }
            }
        }
        return result;
    }

    private static int compareInt(int a, int b) {
        return a - b;
    }

    private static int comparePreRelease(Version v1, Version v2) {
        int result = 0;
        if (v1.isPreRelease() && v2.isPreRelease()) {
            result = Version.compareIdentifiers(v1.getPreReleaseParts(), v2.getPreReleaseParts());
        } else if (v1.isPreRelease()) {
            result = -1;
        } else if (v2.isPreRelease()) {
            result = 1;
        }
        return result;
    }

    private static int compareBuildMetaData(Version v1, Version v2) {
        int result = 0;
        if (v1.hasBuildMetaData() && v2.hasBuildMetaData()) {
            result = Version.compareIdentifiers(v1.getBuildMetaDataParts(), v2.getBuildMetaDataParts());
        } else if (v1.hasBuildMetaData()) {
            result = -1;
        } else if (v2.hasBuildMetaData()) {
            result = 1;
        }
        return result;
    }

    private static int compareIdentifiers(String[] parts1, String[] parts2) {
        int min = Math.min(parts1.length, parts2.length);
        for (int i = 0; i < min; ++i) {
            int r = Version.comparePreReleaseParts(parts1[i], parts2[i]);
            if (r == 0) continue;
            return r;
        }
        return Version.compareInt(parts1.length, parts2.length);
    }

    private static int comparePreReleaseParts(String p1, String p2) {
        int num1 = Version.isNumeric(p1);
        int num2 = Version.isNumeric(p2);
        int result = num1 < 0 && num2 < 0 ? p1.compareTo(p2) : (num1 >= 0 && num2 >= 0 ? Version.compareInt(num1, num2) : (num1 >= 0 ? -1 : 1));
        return result;
    }

    private static int isNumeric(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static final Version create(int major, int minor, int patch, String preRelease, String buildMetaData) {
        Version.checkParams(major, minor, patch);
        Version.require(preRelease != null, "preRelease is null");
        Version.require(buildMetaData != null, "buildMetaData is null");
        if (!preRelease.isEmpty() && !PRE_RELEASE.matcher(preRelease).matches()) {
            throw new VersionFormatException(preRelease);
        }
        if (!buildMetaData.isEmpty() && !BUILD_MD.matcher(buildMetaData).matches()) {
            throw new VersionFormatException(buildMetaData);
        }
        return new Version(major, minor, patch, preRelease, buildMetaData);
    }

    public static final Version create(int major, int minor, int patch, String preRelease) {
        Version.checkParams(major, minor, patch);
        Version.require(preRelease != null, "preRelease is null");
        if (!preRelease.isEmpty() && !PRE_RELEASE.matcher(preRelease).matches()) {
            throw new VersionFormatException(preRelease);
        }
        return new Version(major, minor, patch, preRelease, "");
    }

    public static final Version create(int major, int minor, int patch) {
        Version.checkParams(major, minor, patch);
        return new Version(major, minor, patch, "", "");
    }

    private static void checkParams(int major, int minor, int patch) {
        Version.require(major >= 0, "major < 0");
        Version.require(minor >= 0, "minor < 0");
        Version.require(patch >= 0, "patch < 0");
        Version.require(major != 0 || minor != 0 || patch != 0, "all parts are 0");
    }

    private static void require(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final Version parseVersion(String versionString) {
        Version.require(versionString != null, "versionString is null");
        Matcher m = VERSION_PATTERN.matcher(versionString);
        if (!m.matches()) {
            throw new VersionFormatException(versionString);
        }
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        int patch = Integer.parseInt(m.group(3));
        Version.checkParams(major, minor, patch);
        String preRelease = m.group(4) != null ? m.group(4) : "";
        String buildMD = m.group(5) != null ? m.group(5) : "";
        return new Version(major, minor, patch, preRelease, buildMD);
    }

    public static Version parseVersion(String versionString, boolean allowPreRelease) {
        Version version = Version.parseVersion(versionString);
        if (!allowPreRelease && (version.isPreRelease() || version.hasBuildMetaData())) {
            throw new VersionFormatException(String.format("Version is expected to have no pre-release or build meta data part", new Object[0]));
        }
        return version;
    }

    public Version min(Version other) {
        return Version.min(this, other);
    }

    public Version max(Version other) {
        return Version.max(this, other);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String[] getPreReleaseParts() {
        return this.preRelease.split("\\.");
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public String getBuildMetaData() {
        return this.buildMetaData;
    }

    public String[] getBuildMetaDataParts() {
        return this.buildMetaData.split("\\.");
    }

    public boolean isInitialDevelopment() {
        return this.major == 0;
    }

    public boolean isPreRelease() {
        return !this.preRelease.isEmpty();
    }

    public boolean hasBuildMetaData() {
        return !this.buildMetaData.isEmpty();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.preRelease.length() + this.buildMetaData.length() + 24);
        b.append(this.major).append(".").append(this.minor).append(".").append(this.patch);
        if (!this.preRelease.isEmpty()) {
            b.append("-").append(this.preRelease);
        }
        if (!this.buildMetaData.isEmpty()) {
            b.append("+").append(this.buildMetaData);
        }
        return b.toString();
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 31 + this.major;
            h = 31 * h + this.minor;
            h = 31 * h + this.patch;
            this.hash = h = 31 * h + this.preRelease.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        return this.testEquality(obj, false);
    }

    public boolean equalsWithBuildMetaData(Object obj) {
        return this.testEquality(obj, true);
    }

    private boolean testEquality(Object obj, boolean includeBuildMd) {
        return obj == this || obj instanceof Version && Version.compare(this, (Version)obj, includeBuildMd) == 0;
    }

    @Override
    public int compareTo(Version other) {
        return Version.compare(this, other);
    }

    public int compareToWithBuildMetaData(Version other) {
        return Version.compareWithBuildMetaData(this, other);
    }

    public static class VersionFormatException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VersionFormatException(String message) {
            super(message);
        }
    }
}

