/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.StatusListener;
import java.util.concurrent.atomic.AtomicLong;

public class CollectingStatusListener
implements StatusListener {
    private volatile long fileSize;
    private final AtomicLong recordCount = new AtomicLong();
    private final AtomicLong byteCount = new AtomicLong();
    private volatile boolean completionStatus;
    private volatile Throwable failedThrowable;

    @Override
    public void onInit(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void onReadRecord() {
        this.recordCount.incrementAndGet();
    }

    public long getRecordCount() {
        return this.recordCount.longValue();
    }

    @Override
    public void onReadBytes(int bytes) {
        this.byteCount.addAndGet(bytes);
    }

    public long getByteCount() {
        return this.byteCount.longValue();
    }

    @Override
    public void onComplete() {
        this.completionStatus = true;
    }

    public boolean isCompleted() {
        return this.completionStatus;
    }

    @Override
    public void onError(Throwable throwable) {
        this.failedThrowable = throwable;
    }

    public Throwable getThrowable() {
        return this.failedThrowable;
    }

    public String toString() {
        long byteCntVal = this.byteCount.longValue();
        double percentage = (double)byteCntVal * 100.0 / (double)this.fileSize;
        return String.format("Read %,d records and %,d of %,d bytes (%.2f %%)", this.recordCount.longValue(), byteCntVal, this.fileSize, percentage);
    }
}

