/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CsvRow;
import de.siegmar.fastcsv.reader.ReusableStringBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CsvParser
implements Closeable {
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final int BUFFER_SIZE = 8192;
    private static final int DEFAULT_ROW_CAPACITY = 10;
    private final Reader reader;
    private final char fieldSeparator;
    private final char textDelimiter;
    private final boolean containsHeader;
    private final boolean skipEmptyRows;
    private final boolean errorOnDifferentFieldCount;
    private final char[] buf = new char[8192];
    private final ReusableStringBuilder currentField = new ReusableStringBuilder(512);
    private int bufPos;
    private int bufLen;
    private int prevChar = -1;
    private int copyStart;
    private Map<String, Integer> headerMap;
    private List<String> headerList;
    private long lineNo;
    private int firstLineFieldCount = -1;
    private int maxFieldCount;
    private boolean inQuotes;
    private boolean finished;

    CsvParser(Reader reader, char fieldSeparator, char textDelimiter, boolean containsHeader, boolean skipEmptyRows, boolean errorOnDifferentFieldCount) {
        this.reader = reader;
        this.fieldSeparator = fieldSeparator;
        this.textDelimiter = textDelimiter;
        this.containsHeader = containsHeader;
        this.skipEmptyRows = skipEmptyRows;
        this.errorOnDifferentFieldCount = errorOnDifferentFieldCount;
    }

    public List<String> getHeader() {
        if (!this.containsHeader) {
            throw new IllegalStateException("No header available - header parsing is disabled");
        }
        if (this.lineNo == 0L) {
            throw new IllegalStateException("No header available - call nextRow() first");
        }
        return this.headerList;
    }

    public CsvRow nextRow() throws IOException {
        while (!this.finished) {
            long startingLineNo = ++this.lineNo;
            List<String> currentFields = this.readLine();
            int fieldCount = currentFields.size();
            if (fieldCount == 0) break;
            if (this.skipEmptyRows && fieldCount == 1 && currentFields.get(0).isEmpty()) continue;
            if (this.errorOnDifferentFieldCount) {
                if (this.firstLineFieldCount == -1) {
                    this.firstLineFieldCount = fieldCount;
                } else if (fieldCount != this.firstLineFieldCount) {
                    throw new IOException(String.format("Line %d has %d fields, but first line has %d fields", this.lineNo, fieldCount, this.firstLineFieldCount));
                }
            }
            if (fieldCount > this.maxFieldCount) {
                this.maxFieldCount = fieldCount;
            }
            if (this.containsHeader && this.headerList == null) {
                this.initHeader(currentFields);
                continue;
            }
            return new CsvRow(startingLineNo, this.headerMap, currentFields);
        }
        return null;
    }

    private void initHeader(List<String> currentFields) {
        this.headerList = Collections.unmodifiableList(currentFields);
        LinkedHashMap<String, Integer> localHeaderMap = new LinkedHashMap<String, Integer>(currentFields.size());
        for (int i = 0; i < currentFields.size(); ++i) {
            String field = currentFields.get(i);
            if (field == null || field.isEmpty() || localHeaderMap.containsKey(field)) continue;
            localHeaderMap.put(field, i);
        }
        this.headerMap = Collections.unmodifiableMap(localHeaderMap);
    }

    private List<String> readLine() throws IOException {
        ArrayList<String> currentFields = new ArrayList<String>(this.maxFieldCount > 0 ? this.maxFieldCount : 10);
        ReusableStringBuilder localCurrentField = this.currentField;
        char[] localBuf = this.buf;
        int localBufPos = this.bufPos;
        int localPrevChar = this.prevChar;
        int localCopyStart = this.copyStart;
        int copyLen = 0;
        while (true) {
            if (this.bufLen == localBufPos) {
                if (copyLen > 0) {
                    localCurrentField.append(localBuf, localCopyStart, copyLen);
                }
                this.bufLen = this.reader.read(localBuf, 0, localBuf.length);
                if (this.bufLen < 0) {
                    this.finished = true;
                    if (localPrevChar != this.fieldSeparator && !localCurrentField.hasContent()) break;
                    currentFields.add(localCurrentField.toStringAndReset());
                    break;
                }
                copyLen = 0;
                localBufPos = 0;
                localCopyStart = 0;
            }
            int c = localBuf[localBufPos++];
            if (this.inQuotes) {
                if (c == this.textDelimiter) {
                    this.inQuotes = false;
                    if (copyLen > 0) {
                        localCurrentField.append(localBuf, localCopyStart, copyLen);
                        copyLen = 0;
                    }
                    localCopyStart = localBufPos;
                } else {
                    if (c == 13 || c == 10 && this.prevChar != 13) {
                        ++this.lineNo;
                    }
                    ++copyLen;
                }
            } else if (c == this.fieldSeparator) {
                if (copyLen > 0) {
                    localCurrentField.append(localBuf, localCopyStart, copyLen);
                    copyLen = 0;
                }
                currentFields.add(localCurrentField.toStringAndReset());
                localCopyStart = localBufPos;
            } else if (c == this.textDelimiter) {
                this.inQuotes = true;
                if (localPrevChar == this.textDelimiter) {
                    ++copyLen;
                } else {
                    localCopyStart = localBufPos;
                }
            } else {
                if (c == 13) {
                    if (copyLen > 0) {
                        localCurrentField.append(localBuf, localCopyStart, copyLen);
                    }
                    currentFields.add(localCurrentField.toStringAndReset());
                    localPrevChar = c;
                    localCopyStart = localBufPos;
                    break;
                }
                if (c == 10) {
                    if (localPrevChar != 13) {
                        if (copyLen > 0) {
                            localCurrentField.append(localBuf, localCopyStart, copyLen);
                        }
                        currentFields.add(localCurrentField.toStringAndReset());
                        localPrevChar = c;
                        localCopyStart = localBufPos;
                        break;
                    }
                    localCopyStart = localBufPos;
                } else {
                    ++copyLen;
                }
            }
            localPrevChar = c;
        }
        this.bufPos = localBufPos;
        this.prevChar = localPrevChar;
        this.copyStart = localCopyStart;
        return currentFields;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

