/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth.message;

import de.sciss.osc.Message;
import de.sciss.synth.Server;
import de.sciss.synth.message.Handler;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

public interface Responder
extends Handler {
    public Server server();

    public Responder add();

    public Responder remove();

    private static final class Impl
    implements Responder {
        private final Server server;
        private final PartialFunction<Message, BoxedUnit> handler;
        private final boolean once;

        public Impl(Server server, PartialFunction<Message, BoxedUnit> handler, boolean once) {
            this.server = server;
            this.handler = handler;
            this.once = once;
        }

        @Override
        public Server server() {
            return this.server;
        }

        @Override
        public Impl add() {
            this.server().addResponder(this);
            return this;
        }

        @Override
        public Impl remove() {
            this.server().removeResponder(this);
            return this;
        }

        @Override
        public boolean handle(Message msg) {
            boolean handled = this.handler.isDefinedAt((Object)msg);
            if (handled) {
                try {
                    this.handler.apply((Object)msg);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        e.printStackTrace();
                    }
                    throw throwable;
                }
            }
            return this.once && handled;
        }

        @Override
        public void removed() {
        }

        public String toString() {
            return "Responder(" + this.server() + (this.once ? ", once = true" : "") + ")@" + RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(this.hashCode()));
        }
    }
}

