/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth.impl;

import de.sciss.osc.Dump;
import de.sciss.osc.Message;
import de.sciss.osc.Packet;
import de.sciss.synth.Client;
import de.sciss.synth.Server;
import de.sciss.synth.Server$;
import de.sciss.synth.Server$Running$;
import de.sciss.synth.impl.ServerImpl;
import de.sciss.synth.message.Responder;
import de.sciss.synth.message.StatusReply;
import java.net.InetSocketAddress;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;

public final class OfflineServerImpl
extends ServerImpl {
    private final String name;
    private final Server.Config config;
    private final Client.Config clientConfig;
    private final StatusReply counts;

    public OfflineServerImpl(String name, Server.Config config, Client.Config clientConfig, StatusReply counts) {
        this.name = name;
        this.config = config;
        this.clientConfig = clientConfig;
        this.counts = counts;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Server.Config config() {
        return this.config;
    }

    @Override
    public Client.Config clientConfig() {
        return this.clientConfig;
    }

    @Override
    public StatusReply counts() {
        return this.counts;
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean isOffline() {
        return false;
    }

    private Exception offlineException() {
        return new Exception("Server is not connected");
    }

    @Override
    public void $bang(Packet p) {
        throw this.offlineException();
    }

    @Override
    public <A> Future<A> $bang$bang(Packet packet, Duration timeout, PartialFunction<Message, A> handler) {
        return Future$.MODULE$.failed((Throwable)this.offlineException());
    }

    @Override
    public Server.Condition condition() {
        return Server$Running$.MODULE$;
    }

    @Override
    public void startAliveThread(float delay, float period, int deathBounces) {
    }

    @Override
    public void stopAliveThread() {
    }

    @Override
    public void dumpInOSC(Dump mode, Function1<Packet, Object> filter) {
    }

    @Override
    public void dumpOutOSC(Dump mode, Function1<Packet, Object> filter) {
    }

    @Override
    public void addResponder(Responder resp) {
    }

    @Override
    public void removeResponder(Responder resp) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void quit() {
    }

    @Override
    public InetSocketAddress addr() {
        return Server$.MODULE$.mkAddress(this.config());
    }
}

