/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth;

import de.sciss.optional.Optional$;
import de.sciss.osc.Packet;
import de.sciss.osc.Packet$;
import de.sciss.synth.SynthDef$;
import de.sciss.synth.UGenGraph;
import de.sciss.synth.message.SynthDefFree;
import de.sciss.synth.message.SynthDefFree$;
import de.sciss.synth.message.SynthDefLoad;
import de.sciss.synth.message.SynthDefLoad$;
import de.sciss.synth.message.SynthDefLoadDir;
import de.sciss.synth.message.SynthDefRecv;
import de.sciss.synth.message.SynthDefRecv$;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class SynthDef
implements Product,
Serializable {
    private final String name;
    private final UGenGraph graph;

    public static SynthDef apply(String string, Function0 function0, UGenGraph.BuilderFactory builderFactory) {
        return SynthDef$.MODULE$.apply(string, function0, builderFactory);
    }

    public static SynthDef apply(String string, UGenGraph uGenGraph) {
        return SynthDef$.MODULE$.apply(string, uGenGraph);
    }

    public static String defaultDir() {
        return SynthDef$.MODULE$.defaultDir();
    }

    public static void defaultDir_$eq(String string) {
        SynthDef$.MODULE$.defaultDir_$eq(string);
    }

    public static String extension() {
        return SynthDef$.MODULE$.extension();
    }

    public static SynthDef fromProduct(Product product) {
        return SynthDef$.MODULE$.fromProduct(product);
    }

    public static SynthDefLoadDir loadDirMsg(String string, Option option) {
        return SynthDef$.MODULE$.loadDirMsg(string, option);
    }

    public static List<SynthDef> read(InputStream inputStream) {
        return SynthDef$.MODULE$.read(inputStream);
    }

    public static List<SynthDef> read(String string) {
        return SynthDef$.MODULE$.read(string);
    }

    public static SynthDef unapply(SynthDef synthDef) {
        return SynthDef$.MODULE$.unapply(synthDef);
    }

    public static Option loadDirMsg$default$2() {
        return SynthDef$.MODULE$.loadDirMsg$default$2();
    }

    public static UGenGraph.BuilderFactory apply$default$3(String string, Function0 function0) {
        return SynthDef$.MODULE$.apply$default$3(string, function0);
    }

    public static int write$default$3() {
        return SynthDef$.MODULE$.write$default$3();
    }

    public SynthDef(String name, UGenGraph graph) {
        this.name = name;
        this.graph = graph;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SynthDef)) return false;
        SynthDef synthDef = (SynthDef)object;
        String string = this.name();
        String string2 = synthDef.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        UGenGraph uGenGraph = this.graph();
        UGenGraph uGenGraph2 = synthDef.graph();
        if (uGenGraph == null) {
            if (uGenGraph2 == null) return true;
            return false;
        } else {
            if (!uGenGraph.equals(uGenGraph2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof SynthDef;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "SynthDef";
    }

    public Object productElement(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = this._1();
        } else if (1 == n2) {
            string = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "name";
        } else if (1 == n2) {
            string = "graph";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public String name() {
        return this.name;
    }

    public UGenGraph graph() {
        return this.graph;
    }

    public String toString() {
        return "SynthDef(" + this.name() + ")";
    }

    public SynthDefFree freeMsg() {
        return SynthDefFree$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.name()}));
    }

    public SynthDefRecv recvMsg() {
        return this.recvMsg(Optional$.MODULE$.apply((Option)None$.MODULE$), this.recvMsg$default$2());
    }

    public SynthDefRecv recvMsg(Option completion, int version) {
        return SynthDefRecv$.MODULE$.apply(this.toBytes(version), (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public int recvMsg$default$2() {
        return 1;
    }

    public ByteBuffer toBytes(int version) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(1396926310);
        dos.writeInt(version);
        dos.writeShort(1);
        this.de$sciss$synth$SynthDef$$write(dos, version);
        dos.close();
        return ByteBuffer.wrap(bos.toByteArray()).asReadOnlyBuffer();
    }

    public int toBytes$default$1() {
        return 1;
    }

    public void de$sciss$synth$SynthDef$$write(DataOutputStream dos, int version) {
        this.writePascalString(dos, this.name());
        this.graph().write(dos, version);
    }

    public SynthDefLoad loadMsg() {
        return this.loadMsg(this.loadMsg$default$1(), this.loadMsg$default$2());
    }

    public SynthDefLoad loadMsg(String dir, Option completion) {
        return SynthDefLoad$.MODULE$.apply("" + dir + File.separator + this.name() + "." + "scsyndef", (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public String loadMsg$default$1() {
        return SynthDef$.MODULE$.defaultDir();
    }

    public Option loadMsg$default$2() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public void write(String dir, boolean overwrite) {
        File file = new File(dir, "" + this.name() + "." + "scsyndef");
        if (file.exists()) {
            if (overwrite) {
                file.delete();
            } else {
                return;
            }
        }
        SynthDef$.MODULE$.write(file.getAbsolutePath(), (Seq<SynthDef>)package$.MODULE$.Nil().$colon$colon((Object)this), SynthDef$.MODULE$.write$default$3());
    }

    public String write$default$1() {
        return SynthDef$.MODULE$.defaultDir();
    }

    public boolean write$default$2() {
        return true;
    }

    private void writePascalString(DataOutputStream dos, String str) {
        dos.writeByte(str.length());
        dos.write(str.getBytes());
    }

    public void hexDump(int version) {
        Packet$.MODULE$.printHexOn(this.toBytes(version), Console$.MODULE$.out());
    }

    public int hexDump$default$1() {
        return 1;
    }

    public void testTopologicalSort() {
        ((IterableOnceOps)this.graph().ugens().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            UGenGraph.IndexedUGen ru = (UGenGraph.IndexedUGen)tuple2._1();
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            ((List)ru.inputSpecs().toList().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    int ref = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    int j = BoxesRunTime.unboxToInt((Object)tuple22._2());
                    if (ref >= 0 && ref <= i) {
                        throw scala.sys.package$.MODULE$.error("Test failed : ugen " + i + " = " + ru.ugen() + " -> input " + j + " = " + ref);
                    }
                } else {
                    throw new MatchError((Object)tuple22);
                }
            });
        });
        Predef$.MODULE$.println((Object)"Test succeeded.");
    }

    public void debugDump() {
        ((IterableOnceOps)this.graph().ugens().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            UGenGraph.IndexedUGen ru = (UGenGraph.IndexedUGen)tuple2._1();
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            String special = ru.ugen().specialIndex() != 0 ? "-" + ru.ugen().specialIndex() : "";
            String specs = ((IterableOnceOps)ru.inputSpecs().map((Function1 & Serializable)x$1 -> {
                String string;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    int n2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (-1 == n) {
                        int idx = n2;
                        string = this.graph().constants().apply(idx).toString();
                    } else {
                        int uIdx = n;
                        int oIdx = n2;
                        UGenGraph.IndexedUGen ru = (UGenGraph.IndexedUGen)this.graph().ugens().apply(uIdx);
                        String oStr = oIdx > 0 ? "@" + oIdx : "";
                        string = "#" + uIdx + " : " + ru.ugen().name() + oStr;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                return string;
            })).mkString("( ", ", ", " )");
            Predef$.MODULE$.println((Object)("#" + i + " : " + ru.ugen().name() + special + specs));
        });
    }

    public SynthDef copy(String name, UGenGraph graph) {
        return new SynthDef(name, graph);
    }

    public String copy$default$1() {
        return this.name();
    }

    public UGenGraph copy$default$2() {
        return this.graph();
    }

    public String _1() {
        return this.name();
    }

    public UGenGraph _2() {
        return this.graph();
    }
}

